/***********************************************************
Copyright 1996 Roberto Alsina

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char menu_create__doc__[] =
"Creates a menu"
;

static PyObject *
menu_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int	t,x,y,w,h;
	char	*l;
	long	o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_menu(t,x,y,w,h,l);
	return Py_BuildValue ("l",o);
}

static char menu_clear__doc__[] =
"Removes all the menu's options"
;

static PyObject *
menu_clear(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_clear_menu ((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}

static char menu_set__doc__[] =
"Sets the menu contents"
;

static PyObject *
menu_set(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*s;

	if (!PyArg_ParseTuple(args, "ls",&o,&s))
		return NULL;
	fl_set_menu ((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char menu_addto__doc__[] =
"Adds an option to an existing menu"
;

static PyObject *
menu_addto(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*s;

	if (!PyArg_ParseTuple(args, "ls",&o,&s))
		return NULL;
	fl_addto_menu ((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char menu_replace_item__doc__[] =
"Replaces an item from the menu"
;

static PyObject *
menu_replace_item(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;
	char	*s;

	if (!PyArg_ParseTuple(args, "lis",&o,&i,&s))
		return NULL;
	fl_replace_menu_item((FL_OBJECT *)o,i,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char menu_delete_item__doc__[] =
"Deletes an option from a menu"
;

static PyObject *
menu_delete_item(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_delete_menu_item((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char menu_set_item_shortcut__doc__[] =
"Sets a menu item's shortcut"
;

static PyObject *
menu_set_item_shortcut(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;
	char	*s;

	if (!PyArg_ParseTuple(args, "lis",&o,&i,&s))
		return NULL;
	fl_set_menu_item_shortcut((FL_OBJECT *)o,i,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char menu_set_item_mode__doc__[] =
"Sets the item mode (unselectable, etc)"
;

static PyObject *
menu_set_item_mode(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long		o;
	int		i;
	unsigned long	m;

	if (!PyArg_ParseTuple(args, "lil",&o,&i,&m))
		return NULL;
	fl_set_menu_item_mode((FL_OBJECT *)o,i,m);
	Py_INCREF(Py_None);
	return Py_None;
}

static char menu_show_symbol__doc__[] =
"Shows a simbol menu with the label"
;

static PyObject *
menu_show_symbol(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_show_menu_symbol ((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char menu_get__doc__[] =
"Gets the last selected item's number"
;

static PyObject *
menu_get(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_menu((FL_OBJECT *)o);
	return Py_BuildValue ("i",r);
}

static char menu_get_maxitems__doc__[] =
"returns the number of items in a menu"
;

static PyObject *
menu_get_maxitems(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_menu_maxitems((FL_OBJECT *)o);
	return Py_BuildValue ("i",r);
}

static char menu_get_text__doc__[] =
"Returns the text of the menu last selected choice"
;

static PyObject *
menu_get_text(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	s[2048];

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	strcpy (s,fl_get_menu_text((FL_OBJECT *)o));
	return Py_BuildValue ("s",s);
}

/* List of methods defined in the module */

static struct PyMethodDef menu_methods[] = {
	{"create",	menu_create,	1,	menu_create__doc__},
 {"clear",	menu_clear,	1,	menu_clear__doc__},
 {"set",	menu_set,	1,	menu_set__doc__},
 {"addto",	menu_addto,	1,	menu_addto__doc__},
 {"replace_item",	menu_replace_item,	1,	menu_replace_item__doc__},
 {"delete_item",	menu_delete_item,	1,	menu_delete_item__doc__},
 {"set_item_shortcut",	menu_set_item_shortcut,	1,	menu_set_item_shortcut__doc__},
 {"set_item_mode",	menu_set_item_mode,	1,	menu_set_item_mode__doc__},
 {"show_symbol",	menu_show_symbol,	1,	menu_show_symbol__doc__},
 {"get",	menu_get,	1,	menu_get__doc__},
 {"get_maxitems",	menu_get_maxitems,	1,	menu_get_maxitems__doc__},
 {"get_text",	menu_get_text,	1,	menu_get_text__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initmenu) */

static char menu_module_documentation[] = 
""
;

void
initmenu()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("menu", menu_methods,
		menu_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("menu.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module menu");
}

