#include <Python.h>
#include <forms.h>
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char goodies_set_font__doc__[] =
"Sets the goodies font XXXXXXBroken?"
;

static PyObject *
goodies_set_font(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int i,j;
	if (!PyArg_ParseTuple(args, "ii"),&i,&j)
		return NULL;
	fl_set_goodies_font (i,j);
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_show_message__doc__[] =
"Shows a message (3 lines)"
;

static PyObject *
goodies_show_message(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	char *s1,*s2,*s3;

	if (!PyArg_ParseTuple(args, "sss",&s1,&s2,&s3))
		return NULL;
	fl_show_message (s1,s2,s3);
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_show_alert__doc__[] =
"Shows an alert message"
;

static PyObject *
goodies_show_alert(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char *s1,*s2,*s3;
	int i;

	if (!PyArg_ParseTuple(args, "sssi",&s1,&s2,&s3,&i))
		return NULL;
	fl_show_alert (s1,s2,s3,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_show_question__doc__[] =
"Shows a question"
;

static PyObject *
goodies_show_question(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char *s1,*s2,*s3;
	int r;
	if (!PyArg_ParseTuple(args, "sss",&s1,&s2,&s3))
		return NULL;
	r=fl_show_question (s1,s2,s3);
	return Py_BuildValue ("i",r);
}

static char goodies_show_input__doc__[] =
"Asks a line of text"
;

static PyObject *
goodies_show_input(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char *s1,*s2,r[2048];

	if (!PyArg_ParseTuple(args, "ss",&s1,&s2))
		return NULL;
	strcpy (r,fl_show_input(s1,s2));
	return Py_BuildValue ("s",r);
}

static char goodies_show_colormap__doc__[] =
"Shows a colormap"
;

static PyObject *
goodies_show_colormap(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int i,r;

	if (!PyArg_ParseTuple(args, "i",&i))
		return NULL;
	r=fl_show_colormap (i);
	return Py_BuildValue ("i",r);
}

static char goodies_show_choice__doc__[] =
"Shows a choice"
;

static PyObject *
goodies_show_choice(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char *s1,*s2,*s3,*s4,*s5,*s6;
	int i,r;

	if (!PyArg_ParseTuple(args, "sssisss",&s1,&s2,&s3,&i,&s4,&s5,&s6))
		return NULL;
	r=fl_show_choice (s1,s2,s3,i,s4,s5,s6);
	return Py_BuildValue("i",r);
}

static char goodies_set_choices_shortcut__doc__[] =
"Sets the choice's shortcuts"
;

static PyObject *
goodies_set_choices_shortcut(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char *s1,*s2,*s3;

	if (!PyArg_ParseTuple(args, "sss",&s1,&s2,&s3))
		return NULL;
	fl_set_choices_shortcut (s1,s2,s3);
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_show_oneliner__doc__[] =
"Shows a one-liner"
;

static PyObject *
goodies_show_oneliner(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char	*s1;
	int	i,j;

	if (!PyArg_ParseTuple(args, "sii",&s1,&i,&j))
		return NULL;
	fl_show_oneliner (s1,i,j);
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_hide_oneliner__doc__[] =
"Hides a oneliner"
;

static PyObject *
goodies_hide_oneliner(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	fl_hide_oneliner();
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_set_oneliner_font__doc__[] =
"Sets the oneliner font"
;

static PyObject *
goodies_set_oneliner_font(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int i,j;

	if (!PyArg_ParseTuple(args, "ii",&i,&j))
		return NULL;
	fl_set_oneliner_font(i,j);
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_set_oneliner_color__doc__[] =
"Sets the oneliner color"
;

static PyObject *
goodies_set_oneliner_color(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int i,j;

	if (!PyArg_ParseTuple(args, "ii",&i,&j))
		return NULL;
	fl_set_oneliner_color (i,j);
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_use_fselector__doc__[] =
"??"
;

static PyObject *
goodies_use_fselector(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int i;

	if (!PyArg_ParseTuple(args, "i",&i))
		return NULL;
	fl_use_fselector (i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_show_fselector__doc__[] =
"Shows a fselector"
;

static PyObject *
goodies_show_fselector(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char *s1,*s2,*s3,*s4,r[2048];

	if (!PyArg_ParseTuple(args, "ssss",&s1,&s2,&s3,&s4))
		return NULL;
	strcpy (r,fl_show_fselector (s1,s2,s3,s4));
	return Py_BuildValue ("s",r);
}

static char goodies_set_fselector_placement__doc__[] =
""
;

static PyObject *
goodies_set_fselector_placement(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int i;

	if (!PyArg_ParseTuple(args, "i",&i))
		return NULL;
	fl_set_fselector_placement(i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_set_fselector_callback__doc__[] =
"XXXXXX Not implemented"
;

static PyObject *
goodies_set_fselector_callback(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_get_directory__doc__[] =
""
;

static PyObject *
goodies_get_directory(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char r[2048];
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	strcpy (r,fl_get_directory());
	return Py_BuildValue ("s",r);
}

static char goodies_get_pattern__doc__[] =
""
;

static PyObject *
goodies_get_pattern(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char r[2048];

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	strcpy (r,fl_get_pattern());
	return Py_BuildValue ("s",r);
}

static char goodies_get_filename__doc__[] =
""
;

static PyObject *
goodies_get_filename(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	char r[2048];

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	strcpy (r,fl_get_filename());
	return Py_BuildValue ("s",r);
}

static char goodies_refresh_fselector__doc__[] =
""
;

static PyObject *
goodies_refresh_fselector(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	fl_refresh_fselector();
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_add_fselector_appbutton__doc__[] =
"XXXXXX Not implemented"
;

static PyObject *
goodies_add_fselector_appbutton(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_disable_fselector_cache__doc__[] =
"XXXXXX Not implemented"
;

static PyObject *
goodies_disable_fselector_cache(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_invalidate_fselector_cache__doc__[] =
"XXXXXX Not implemented"
;

static PyObject *
goodies_invalidate_fselector_cache(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_get_fselector_form__doc__[] =
"XXXXXX Not implemented"
;

static PyObject *
goodies_get_fselector_form(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char goodies_hide_fselector__doc__[] =
"Hides a fselector"
;

static PyObject *
goodies_hide_fselector(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	fl_hide_fselector();
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef goodies_methods[] = {
	{"set_font",	goodies_set_font,	1,	goodies_set_font__doc__},
 {"show_message",	goodies_show_message,	1,	goodies_show_message__doc__},
 {"show_alert",	goodies_show_alert,	1,	goodies_show_alert__doc__},
 {"show_question",	goodies_show_question,	1,	goodies_show_question__doc__},
 {"show_input",	goodies_show_input,	1,	goodies_show_input__doc__},
 {"show_colormap",	goodies_show_colormap,	1,	goodies_show_colormap__doc__},
 {"show_choice",	goodies_show_choice,	1,	goodies_show_choice__doc__},
 {"set_choices_shortcut",	goodies_set_choices_shortcut,	1,	goodies_set_choices_shortcut__doc__},
 {"show_oneliner",	goodies_show_oneliner,	1,	goodies_show_oneliner__doc__},
 {"hide_oneliner",	goodies_hide_oneliner,	1,	goodies_hide_oneliner__doc__},
 {"set_oneliner_font",	goodies_set_oneliner_font,	1,	goodies_set_oneliner_font__doc__},
 {"set_oneliner_color",	goodies_set_oneliner_color,	1,	goodies_set_oneliner_color__doc__},
 {"use_fselector",	goodies_use_fselector,	1,	goodies_use_fselector__doc__},
 {"show_fselector",	goodies_show_fselector,	1,	goodies_show_fselector__doc__},
 {"set_fselector_placement",	goodies_set_fselector_placement,	1,	goodies_set_fselector_placement__doc__},
 {"set_fselector_callback",	goodies_set_fselector_callback,	1,	goodies_set_fselector_callback__doc__},
 {"get_directory",	goodies_get_directory,	1,	goodies_get_directory__doc__},
 {"get_pattern",	goodies_get_pattern,	1,	goodies_get_pattern__doc__},
 {"get_filename",	goodies_get_filename,	1,	goodies_get_filename__doc__},
 {"refresh_fselector",	goodies_refresh_fselector,	1,	goodies_refresh_fselector__doc__},
 {"add_fselector_appbutton",	goodies_add_fselector_appbutton,	1,	goodies_add_fselector_appbutton__doc__},
 {"disable_fselector_cache",	goodies_disable_fselector_cache,	1,	goodies_disable_fselector_cache__doc__},
 {"invalidate_fselector_cache",	goodies_invalidate_fselector_cache,	1,	goodies_invalidate_fselector_cache__doc__},
 {"get_fselector_form",	goodies_get_fselector_form,	1,	goodies_get_fselector_form__doc__},
 {"hide_fselector",	goodies_hide_fselector,	1,	goodies_hide_fselector__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initgoodies) */

static char goodies_module_documentation[] = 
""
;

void
initgoodies()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("goodies", goodies_methods,
		goodies_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("goodies.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module goodies");
}

