#include <Python.h>
#include <forms.h>
static PyObject *ErrorObject;

/* ----------------------------------------------------- */


static char forms_create__doc__[] =
   "Creates a form"
   ;

static PyObject *
   forms_create(self, args)
   PyObject *self; /* Not used */
PyObject *args;
{
   int	box,w,h;
   FL_FORM	*ret;

   if (!PyArg_ParseTuple(args, "iii",&box,&w,&h))
      return NULL;
   ret=fl_bgn_form (FL_NO_BOX,w,h);
   fl_end_form ();
   return Py_BuildValue("l",(long)ret);
}

static char forms_freeze__doc__[] =
   "Freezes a form"
   ;

static PyObject *
   forms_freeze(self, args)
   PyObject *self; /* Not used */
PyObject *args;
{
   long form;

   if (!PyArg_ParseTuple(args, "l",&form))
      return NULL;
   fl_freeze_form ((FL_FORM *)form);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_unfreeze__doc__[] =
   "Unfreezes a form"
   ;

static PyObject *
   forms_unfreeze(self, args)
   PyObject *self; /* Not used */
PyObject *args;
{
   long form;

   if (!PyArg_ParseTuple(args, "l",&form))
      return NULL;
   fl_unfreeze_form ((FL_FORM *)form);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_deactivate__doc__[] =
   "Deactivates a form"
   ;

static PyObject *
   forms_deactivate(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   long form;
   if (!PyArg_ParseTuple(args, "l",&form))
      return NULL;
   fl_deactivate_form ((FL_FORM *)form);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_activate__doc__[] =
   "Activates a form"
   ;

static PyObject *
   forms_activate(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long form;
   if (!PyArg_ParseTuple(args, "l",&form))
      return NULL;
   fl_activate_form ((FL_FORM *)form);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_activate_all__doc__[] =
   "Activates all forms"
   ;

static PyObject *
   forms_activate_all(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   fl_activate_all_forms ();
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_deactivate_all__doc__[] =
   "Deactivates all forms"
   ;

static PyObject *
   forms_deactivate_all(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   fl_deactivate_all_forms ();
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_freeze_all__doc__[] =
   "Freezes all forms"
   ;

static PyObject *
   forms_freeze_all(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   fl_freeze_all_forms ();
   Py_INCREF(Py_None);
   return Py_None;
}


static char forms_unfreeze_all__doc__[] =
   "Unfreezes all forms"
   ;

static PyObject *
   forms_unfreeze_all(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   fl_unfreeze_all_forms ();
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_scale__doc__[] =
   "Scales a form x and y times"
   ;

static PyObject *
   forms_scale(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;
   double 	x,y;

   if (!PyArg_ParseTuple(args, "ldd",&form,&x,&y))
      return NULL;
   fl_scale_form ((FL_FORM *)form,x,y);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_set_position__doc__[] =
   "Sets the form position"
   ;

static PyObject *
   forms_set_position(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;
   int 	x,y;

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   fl_set_form_position((FL_FORM *)form,x,y);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_set_property__doc__[] =
   "XXXXXXNot implemented"
   ;

static PyObject *
   forms_set_property(self, args)
   PyObject *self; /* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_unset_property__doc__[] =
   "XXXXXXNot implemented"
   ;

static PyObject *
   forms_unset_property(self, args)
   PyObject *self; /* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_set_callback__doc__[] =
   "XXXXXXNot implemented"
   ;

static PyObject *
   forms_set_callback(self, args)
   PyObject *self; /* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_set_size__doc__[] =
   "Sets the form's size"
   ;

static PyObject *
   forms_set_size(self, args)
   PyObject *self; /* Not used */
PyObject *args;
{
   long    form;
   int     x,y;

   if (!PyArg_ParseTuple(args, "lii",&form,&x,&y))
      return NULL;
   fl_set_form_size((FL_FORM *)form,x,y);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_set_hotspot__doc__[] =
   "XXXXXXNot implemented"
   ;

static PyObject *
   forms_set_hotspot(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   Py_INCREF(Py_None);
   return Py_None;
}


static char forms_set_hotobject__doc__[] =
   "XXXXXXNot implemented"
   ;

static PyObject *
   forms_set_hotobject(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_set_minsize__doc__[] =
   "Sets the form minimum size"
   ;

static PyObject *
   forms_set_minsize(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;
   int	x,y;

   if (!PyArg_ParseTuple(args, "lii",&form,&x,&y))
      return NULL;
   fl_set_form_minsize ((FL_FORM *)form,x,y);
   Py_INCREF(Py_None);
   return Py_None;
}


static char forms_set_maxsize__doc__[] =
   "Sets the form maximum size"
   ;

static PyObject *
   forms_set_maxsize(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;
   int	x,y;

   if (!PyArg_ParseTuple(args, "lii",&form,&x,&y))
      return NULL;
   fl_set_form_maxsize ((FL_FORM *)form,x,y);
   Py_INCREF(Py_None);
   return Py_None;
}


static char forms_set_event_cmask__doc__[] =
   "XXXXXXNot implemented"
   ;

static PyObject *
   forms_set_event_cmask(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_get_event_cmask__doc__[] =
   "XXXXXXNot implemented"
   ;

static PyObject *
   forms_get_event_cmask(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_set_geometry__doc__[] =
   "Set the form's geometry"
   ;

static PyObject *
   forms_set_geometry(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long 	form;
   int	x,y,w,h;

   if (!PyArg_ParseTuple(args, "liiii",&form,&x,&y,&w,&h))
      return NULL;
   fl_set_form_geometry ((FL_FORM *)form,x,y,w,h);
   Py_INCREF(Py_None);
   return Py_None;
}


static char forms_get_geometry__doc__[] =
   "Get the form's geometry"
   ;

static PyObject *
   forms_get_geometry(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long 	form;
   int	x,y,w,h;

   if (!PyArg_ParseTuple(args, "l",&form))
      return NULL;
   x=((FL_FORM *)form)->x;
   y=((FL_FORM *)form)->y;
   w=((FL_FORM *)form)->w;
   h=((FL_FORM *)form)->h;
   return Py_BuildValue ("iiii",x,y,w,h);
}

static char forms_show__doc__[] =
   "Shows the form"
   ;

static PyObject *
   forms_show(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long 	form,ret;
   int	a,b;
   char	*c;

   if (!PyArg_ParseTuple(args, "liis",&form,&a,&b,&c))
      return NULL;
   ret=fl_show_form ((FL_FORM *)form,a,b,c);
   return Py_BuildValue("l",ret);
}

static char forms_hide__doc__[] =
   "Hides a form"
   ;

static PyObject *
   forms_hide(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;

   if (!PyArg_ParseTuple(args, "l",&form))
      return NULL;
   fl_hide_form ((FL_FORM *)form);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_free__doc__[] =
   "Releases a form's memory"
   ;

static PyObject *
   forms_free(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;

   if (!PyArg_ParseTuple(args, "l",&form))
      return NULL;
   fl_free_form ((FL_FORM *)form);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_redraw__doc__[] =
   "Redraws a form"
   ;

static PyObject *
   forms_redraw(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;

   if (!PyArg_ParseTuple(args, "l",&form))
      return NULL;
   fl_redraw_form ((FL_FORM *)form);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_set_dblbuffer__doc__[] =
   "Sets the form as doublebuffered or not"
   ;

static PyObject *
   forms_set_dblbuffer(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;
   int	choice;

   if (!PyArg_ParseTuple(args, "li",&form,&choice))
      return NULL;
   fl_set_form_dblbuffer ((FL_FORM *)form,choice);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_prepare_window__doc__[] =
   "XXXXXXNot implemented"
   ;

static PyObject *
   forms_prepare_window(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_show_window__doc__[] =
   "XXXXXXNot implemented"
   ;

static PyObject *
   forms_show_window(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{

   if (!PyArg_ParseTuple(args, ""))
      return NULL;
   Py_INCREF(Py_None);
   return Py_None;
}


static char forms_add_object__doc__[] =
   "Adds an object to the form"
   ;

static PyObject *
   forms_add_object(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	f,o;
   if (!PyArg_ParseTuple(args, "ll",&f,&o))
      return NULL;
   fl_add_object((FL_FORM *)f,(FL_OBJECT *)o);
   Py_INCREF(Py_None);
   return Py_None;
}


static char forms_get_attr__doc__[] =
   "Gets a bunch of attributes from the form"
   ;

static PyObject *forms_get_attr(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	o;
   if (!PyArg_ParseTuple(args, "l",&o))
      return NULL;
   return Py_BuildValue ("iiiiiil",
      ((FL_FORM *)o)->vmode,
      ((FL_FORM *)o)->deactivated,
      ((FL_FORM *)o)->use_pixmap,
      ((FL_FORM *)o)->frozen,
      ((FL_FORM *)o)->visible,
      ((FL_FORM *)o)->wm_border,
      (long)((FL_FORM *)o)->prop);
}


static char forms_set_title__doc__[] =
   "Sets the form's title"
   ;

static PyObject *
   forms_set_title(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;
   char	*title;

   if (!PyArg_ParseTuple(args, "ls",&form,&title))
      return NULL;
   fl_set_form_title ((FL_FORM *)form,title);
   Py_INCREF(Py_None);
   return Py_None;
}

static char forms_get_title__doc__[] =
   "Gets the form's title (Undocumented on XForms, but...)"
   ;

static PyObject *
   forms_get_title(self, args)
   PyObject *self;	/* Not used */
PyObject *args;
{
   long	form;
   char	title[2048];

   if (!PyArg_ParseTuple(args, "l",&form))
      return NULL;
   strcpy (title,((FL_FORM *)form)->label);
   return Py_BuildValue ("s",title);
}


/* List of methods defined in the module */

static struct PyMethodDef forms_methods[] = {
   {  "create",	                        forms_create,	1,	forms_create__doc__  },
      {  "freeze",	forms_freeze,	1,	forms_freeze__doc__  },
      {  "unfreeze",	forms_unfreeze,	1,	forms_unfreeze__doc__  },
      {  "deactivate",	forms_deactivate,	1,	forms_deactivate__doc__  },
      {  "activate",	forms_activate,	1,	forms_activate__doc__  },
      {  "activate_all",	forms_activate_all,	1,	forms_activate_all__doc__  },
      {  "deactivate_all",	forms_deactivate_all,	1,	forms_deactivate_all__doc__  },
      {  "freeze_all",	forms_freeze_all,	1,	forms_freeze_all__doc__  },
      {  "unfreeze_all",	forms_unfreeze_all,	1,	forms_unfreeze_all__doc__  },
      {  "scale",	forms_scale,	1,	forms_scale__doc__  },
      {  "set_position",	forms_set_position,	1,	forms_set_position__doc__  },
      {  "set_property",	forms_set_property,	1,	forms_set_property__doc__  },
      {  "unset_property",	forms_unset_property,	1,	forms_unset_property__doc__  },
      {  "set_callback",	forms_set_callback,	1,	forms_set_callback__doc__  },
      {  "set_size",	forms_set_size,	1,	forms_set_size__doc__  },
      {  "set_hotspot",	forms_set_hotspot,	1,	forms_set_hotspot__doc__  },
      {  "set_hotobject",	forms_set_hotobject,	1,	forms_set_hotobject__doc__  },
      {  "set_minsize",	forms_set_minsize,	1,	forms_set_minsize__doc__  },
      {  "set_maxsize",	forms_set_maxsize,	1,	forms_set_maxsize__doc__  },
      {  "set_event_cmask",	forms_set_event_cmask,	1,	forms_set_event_cmask__doc__  },
      {  "get_event_cmask",	forms_get_event_cmask,	1,	forms_get_event_cmask__doc__  },
      {  "set_geometry",	forms_set_geometry,	1,	forms_set_geometry__doc__  },
      {  "get_geometry",	forms_get_geometry,	1,	forms_get_geometry__doc__  },
      {  "show",	forms_show,	1,	forms_show__doc__  },
      {  "hide",	forms_hide,	1,	forms_hide__doc__  },
      {  "free",	forms_free,	1,	forms_free__doc__  },
      {  "redraw",	forms_redraw,	1,	forms_redraw__doc__  },
      {  "set_dblbuffer",	forms_set_dblbuffer,	1,	forms_set_dblbuffer__doc__  },
      {  "prepare_window",	forms_prepare_window,	1,	forms_prepare_window__doc__  },
      {  "show_window",	forms_show_window,	1,	forms_show_window__doc__  },
      {  "add_object",	forms_add_object,	1,	forms_add_object__doc__  },
      {  "get_attr",	forms_get_attr,	1,	forms_get_attr__doc__  },
      {  "set_title",	forms_set_title,	1,	forms_set_title__doc__  },
      {  "get_title",	forms_get_title,	1,	forms_get_title__doc__  },

      {  NULL,		NULL  }		/* sentinel */
};


/* Initialization function for the module (*must* be called initforms) */

static char forms_module_documentation[] =
   ""
   ;

void
   initforms()
   {
      PyObject *m, *d;

/* Create the module and add the functions */
      m = Py_InitModule4("forms", forms_methods,
         forms_module_documentation,
         (PyObject*)NULL,PYTHON_API_VERSION);

/* Add some symbolic constants to the module */
      d = PyModule_GetDict(m);
      ErrorObject = PyString_FromString("forms.error");
      PyDict_SetItemString(d, "error", ErrorObject);

/* XXXX Add constants here */

/* Check for errors */
      if (PyErr_Occurred())
         Py_FatalError("can't initialize module forms");
   }

