/***********************************************************
Copyright 1996 Roberto Alsina

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char dial_create__doc__[] =
"Creates a dial"
;

static PyObject *
dial_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int	t,x,y,w,h;
	char	*l;
	long	o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_dial(t,x,y,w,h,l);
	return Py_BuildValue ("l",o);;
}

static char dial_set_value__doc__[] =
"Sets the dial value"
;

static PyObject *
dial_set_value(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	v;

	if (!PyArg_ParseTuple(args, "ld",&o,&v))
		return NULL;
	fl_set_dial_value ((FL_OBJECT *)o,v);
	Py_INCREF(Py_None);
	return Py_None;
}

static char dial_get_value__doc__[] =
"Gets the dial's value"
;

static PyObject *
dial_get_value(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_dial_value((FL_OBJECT *)o);
	return Py_BuildValue("d",r);
}

static char dial_set_bounds__doc__[] =
"Sets the dial bounds"
;

static PyObject *
dial_set_bounds(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	min,max;

	if (!PyArg_ParseTuple(args, "ldd",&o,&min,&max))
		return NULL;
	fl_set_dial_bounds((FL_OBJECT *)o,min,max);
	Py_INCREF(Py_None);
	return Py_None;
}

static char dial_get_bounds__doc__[] =
"Gets the dial bounds"
;

static PyObject *
dial_get_bounds(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	min,max;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_get_dial_bounds((FL_OBJECT *)o,&min,&max);
	return Py_BuildValue("dd",min,max);
}

static char dial_set_step__doc__[] =
"Sets the dial step"
;

static PyObject *
dial_set_step(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	s;

	if (!PyArg_ParseTuple(args, "ld",&o,&s))
		return NULL;
	fl_set_dial_step ((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char dial_set_return__doc__[] =
"Makes a dial return always or when released"
;

static PyObject *
dial_set_return(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_dial_return ((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef dial_methods[] = {
	{"create",	dial_create,	1,	dial_create__doc__},
 {"set_value",	dial_set_value,	1,	dial_set_value__doc__},
 {"get_value",	dial_get_value,	1,	dial_get_value__doc__},
 {"set_bounds",	dial_set_bounds,	1,	dial_set_bounds__doc__},
 {"get_bounds",	dial_get_bounds,	1,	dial_get_bounds__doc__},
 {"set_step",	dial_set_step,	1,	dial_set_step__doc__},
 {"set_return",	dial_set_return,	1,	dial_set_return__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initdial) */

static char dial_module_documentation[] = 
""
;

void
initdial()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("dial", dial_methods,
		dial_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("dial.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module dial");
}

