/***********************************************************
Copyright 1996 Roberto Alsina


			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char button_create__doc__[] =
"Creates a normal button"
;

static PyObject *
button_create(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    o;
	int     t,x,y,w,h;
	char    *l;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_button(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

static char button_create_round__doc__[] =
"Creates a round button"
;


static PyObject *
button_create_round(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    o;
	int     t,x,y,w,h;
	char    *l;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_roundbutton(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

static char button_create_light__doc__[] =
"Creates a light button"
;

static PyObject *
button_create_light(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    o;
	int     t,x,y,w,h;
	char    *l;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_lightbutton(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

static char button_create_check__doc__[] =
"Creates a check button"
;

static PyObject *
button_create_check(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    o;
	int     t,x,y,w,h;
	char    *l;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_checkbutton(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

static char button_create_bitmap__doc__[] =
"Creates a bitmap button"
;

static PyObject *
button_create_bitmap(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    o;
	int     t,x,y,w,h;
	char    *l;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_bitmapbutton(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}


static char button_create_pixmap__doc__[] =
"Creates a pixmap button"
;

static PyObject *
button_create_pixmap(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    o;
	int     t,x,y,w,h;
	char    *l;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_pixmapbutton(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

static char button_set_bitmap_data__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
button_set_bitmap_data(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char button_set_bitmap_file__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
button_set_bitmap_file(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char button_set_pixmap_data__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
button_set_pixmap_data(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char button_set_pixmap_file__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
button_set_pixmap_file(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char button_set_pixmap_pixmap__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
button_set_pixmap_pixmap(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char button_get_pixmap_pixmap__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
button_get_pixmap_pixmap(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char button_get__doc__[] =
"Gets the button's value"
;

static PyObject *
button_get(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long	o;
	int	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_button((FL_OBJECT *)o);
	return Py_BuildValue("i",r);
}

static char button_set__doc__[] =
"Sets the button's value"
;

static PyObject *
button_set(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long	o;
	int	v;

	if (!PyArg_ParseTuple(args, "li",&o,&v))
		return NULL;
	fl_set_button((FL_OBJECT *)o,v);
	Py_INCREF(Py_None);
	return Py_None;
}

static char button_get_numb__doc__[] =
"Get's the number of the mouse button last pressed on the button object"
;

static PyObject *
button_get_numb(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long	o;
	int	n;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	n=fl_get_button_numb((FL_OBJECT *)o);
	return Py_BuildValue ("i",n);
}

static char button_create_generic__doc__[] =
"Creates a generic button (useful mainly for extensions)"
;

static PyObject *
button_create_generic(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	int     c,t,x,y,w,h;
	char    *l;
	long    o;

	if (!PyArg_ParseTuple(args, "iiiiiis",&c,&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_generic_button (c,t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

/* List of methods defined in the module */

static struct PyMethodDef button_methods[] = {
	{"create",	button_create,	1,	button_create__doc__},
 {"create_round",	button_create_round,	1,	button_create_round__doc__},
 {"create_light",	button_create_light,	1,	button_create_light__doc__},
 {"create_check",	button_create_check,	1,	button_create_check__doc__},
 {"create_bitmap",	button_create_bitmap,	1,	button_create_bitmap__doc__},
 {"create_pixmap",	button_create_pixmap,	1,	button_create_pixmap__doc__},
 {"set_bitmap_data",	button_set_bitmap_data,	1,	button_set_bitmap_data__doc__},
 {"set_bitmap_file",	button_set_bitmap_file,	1,	button_set_bitmap_file__doc__},
 {"set_pixmap_data",	button_set_pixmap_data,	1,	button_set_pixmap_data__doc__},
 {"set_pixmap_file",	button_set_pixmap_file,	1,	button_set_pixmap_file__doc__},
 {"set_pixmap_pixmap",	button_set_pixmap_pixmap,	1,	button_set_pixmap_pixmap__doc__},
 {"get_pixmap_pixmap",	button_get_pixmap_pixmap,	1,	button_get_pixmap_pixmap__doc__},
 {"get",	button_get,	1,	button_get__doc__},
 {"set",	button_set,	1,	button_set__doc__},
 {"get_numb",	button_get_numb,	1,	button_get_numb__doc__},
 {"create_generic",	button_create_generic,	1,	button_create_generic__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initbutton) */

static char button_module_documentation[] = 
""
;

void
initbutton()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("button", button_methods,
		button_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("button.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module button");
}

