##########################################################
# This is the Python interface to the pyxforms C module
#


import sys
import xforms
import forms
import objects
import bitmaps
import pixmaps
import box
import browser
import button
import choice
import clock
import counter
import dial
import frame
import input
import menu
import positioner
import slider
import timer

###############################################################################
# These are function needed to run the XForms library
# Needs a LOT of work

def xfinit (appname,appclass,argv0):
	xforms.init (appname,appclass,argv0)

###############################################################################
# This is the synthetic event-loop to use under python:

_objects={}

def runforms():
	while 1:
		ob=_objects[str(xforms.do_forms())]
		ob.cb (ob.args)

###############################################################################
# This is the default callback function:

def _nocb(args):
	print "This object has no Callback!"

##############################################################################
#This is the Form class


class Form:
	def __init__(self,t=6,w=200,h=200):
		self.id=forms.create (0,w,h)
		self.__box=Box(t,0,0,w,h,"")
		self.Add (self.__box)
		self.__box.c1=11
		self.__box.c2=15
		self.__minx=1      #  Reasonable defaults for things that 
		self.__miny=1      #  I can't get from XForms
		self.__maxx=10000  #  Notice that if the C code changes them
		self.__maxy=10000  #  They get out of sync!
		self.__title=sys.argv[0] #the "preferred" form title
		self.__placement=16388
		self.__decoration=1
		self.objs=()       # A place to store the obj list. Useful?

	def Show (self):
 		self.winid=forms.show (self.id,self.__placement,self.__decoration,self.title)
	def Hide (self):
		forms.hide (self.id)
	def Freeze (self):
		forms.freeze (self.id)
	def Unfreeze (self):
		forms.unfreeze (self.id)
	def Activate (self):
		forms.activate (self.id)
	def Deactivate (self):
		forms.deactivate (self.id)
	def Scale (self,x,y):
		forms.scale (self.id,x,y)
	def Redraw (self):
		forms.redraw (self.id)
	def Add (self,object):
		forms.add_object (self.id,object.id)
		object.parent=self
	def Setminsize (self,x,y):
		forms.set_minsize (self.id,x,y)
		self.__minx=x # The __ is needed to avoid endless looping
		self.__miny=y # on min[xy], which are non-gettable from XForms 
	def Setmaxsize (self,x,y):
		forms.set_maxsize (self.id,x,y)
		self.__maxx=x
		self.__maxy=y
	def Settitle (self,title):
		forms.set_title (self.id,title)
		self.__title=title
	def Gettitle (self):
		if self.visible:
			return forms.get_title(self.id)
		else:
			return self.__title
	def Setcolor (c1,c2):
		self.__box.Setcolor (c1,c2)

	def __setattr__(self,name,value):
		if name=="x":
			(tx,ty,tw,th)=forms.get_geometry (self.id)
			forms.set_geometry (self.id,value,ty,tw,th)
		elif name=="y":
			(tx,ty,tw,th)=forms.get_geometry (self.id)
			forms.set_geometry (self.id,tx,value,tw,th)
		elif name=="w":
			(tx,ty,tw,th)=forms.get_geometry (self.id)
			forms.set_geometry (self.id,tx,ty,value,th)
		elif name=="h":
			(tx,ty,tw,th)=forms.get_geometry (self.id)
			forms.set_geometry (self.id,tx,ty,tw,value)
		elif name=="dblbuffer":
			forms.set_dblbuffer(self.id,value)
		elif name=="frozen":
			if value:
				self.Freeze()
			else:
				self.Unfreeze()
		elif name=="active":
			if value:
				self.Activate()
			else:
				self.Deactivate()
		elif name=="visible":
			if value:
				self.Show()
			else:
				self.Hide()
		elif name=="minx":
			self.Setminsize (value,self.__miny)
		elif name=="miny":
			self.Setminsize (self.__minx,value)
		elif name=="maxx":
			self.Setminsize (value,self.__maxy)
		elif name=="maxy":
			self.Setminsize (self.__maxx,value)
		elif name=="title":
			self.Settitle (value)
		elif name=="c1":
			self.__box.c1=value
		elif name=="c2":
			self.__box.c2=value
		else:
			self.__dict__ [name]=value


	def __getattr__(self,name):
		if name=="x":
			(tx,ty,tw,th)=forms.get_geometry (self.id)
			return tx
		elif name=="y":
			(tx,ty,tw,th)=forms.get_geometry (self.id)
			return ty
		elif name=="w":
			(tx,ty,tw,th)=forms.get_geometry (self.id)
			return tw
		elif name=="h":
			(tx,ty,tw,th)=forms.get_geometry (self.id)
			return th
		elif name=="minx":
			return self.__minx
		elif name=="miny":
			return self.__miny
		elif name=="maxx":
			return self.__maxx
		elif name=="maxy":
			return self.__maxy
		elif name=="vmode":
			(vmode,active,dblbuffer,frozen,visible,border,other)=forms.get_attr(self.id)
			return vmode
		elif name=="active":
			(vmode,active,dblbuffer,frozen,visible,border,other)=forms.get_attr(self.id)
			return active
		elif name=="dblbuffer":
			(vmode,active,dblbuffer,frozen,visible,border,other)=forms.get_attr(self.id)
			return dblbuffer
		elif name=="frozen":
			(vmode,active,dblbuffer,frozen,visible,border,other)=forms.get_attr(self.id)
			return frozen
		elif name=="visible":
			(vmode,active,dblbuffer,frozen,visible,border,other)=forms.get_attr(self.id)
			return visible
		elif name=="border":
			(vmode,active,dblbuffer,frozen,visible,border,other)=forms.get_attr(self.id)
			return border
		elif name=="other":
			(vmode,active,dblbuffer,frozen,visible,border,other)=forms.get_attr(self.id)
			return other
		elif name=="title":
			return self.Gettitle ()
		elif name=="c1":
			return self.__box.c1
		elif name=="c2":
			return self.__box.c2
	def __del__(self): 
		pass
#I'm not sure if this is a nice thing to do
#		forms.free (self.id)


###############################################################################
#This is the XFObject class, for generic XForms objects

class XFObject:
	def __init__ (self):
		self.id=0
		self.__c1=11
		self.__c2=15
	def Setgravity (self,a,b):
		objects.set_gravity (self.id,a,b)
	def Redraw (self):
		objects.redraw (self.id)
	def Scale (self,x,y):
		objects.scale (self.id,x,y)
	def Show (self):
		objects.show (self.id)
		self.Setcolor (self.__c1,self.__c2)
	def Hide (self):
		objects.hide (self.id)
	def Delete(self):
		objects.delete (self.id)
	def Setcolor (self,c1,c2):
		self.__c1=c1
		self.__c2=c2
		objects.set_color (self.id,c1,c2)
	def Activate (self):
		objects.activate (self.id)
	def Deactivate (self):
		objects.deactivate (self.id)
	def __setattr__ (self,name,value):
		if name=="boxtype":
			objects.set_boxtype (self.id,value)
		elif name=="bw":
			objects.set_bw (self.id,value)
		elif name=="labelsize":
			objects.set_ls (self.id,value)
		elif name=="labelstyle":
			objects.set_lstyle (self.id,value)
		elif name=="labelcolor":
			objects.set_lcol (self.id,value)
		elif name=="labelalign":
			objects.set_lalign (self.id,value)
		elif name=="label":
			objects.set_label (self.id,value)
		elif name=="shortcut":
			objects.set_shortcut (self.id,value,1)
		elif name=="dblbuffer":
			objects.set_dblbuffer(self.id,value)
		elif name=="x":
			(tx,ty,tw,th)=objects.get_geometry (self.id)
			objects.set_geometry (self.id,value,ty,tw,th)
		elif name=="y":
			(tx,ty,tw,th)=objects.get_geometry (self.id)
			objects.set_geometry (self.id,tx,value,tw,th)
		elif name=="w":
			(tx,ty,tw,th)=objects.get_geometry (self.id)
			objects.set_geometry (self.id,tx,ty,value,th)
		elif name=="h":
			(tx,ty,tw,th)=objects.get_geometry (self.id)
			objects.set_geometry (self.id,tx,ty,tw,value)
		elif name=="resize":
			objects.set_resize (self.id,value)
		elif name=="c1":
			self.Setcolor (value,self.__c2)
		elif name=="c2":
			self.Setcolor (self.__c1,value)
		else:
			self.__dict__ [name]=value
	def __getattr__(self,name):
		if name=="c1":
			return self.__c1
		elif name=="c2":
			return self.__c2
		
	def __del__ (self):
#probably a BAD idea
		objects.free(self.id)


###############################################################################
# The Bitmap Class

class Bitmap(XFObject):
	def __init__(self,t=0,x=10,y=10,w=100,h=100,l="Bitmap"):
		XFObject.__init__ (self)
		self.id=bitmaps.create(t,x,y,w,h,l)
	def Load (self,file):
		bitmaps.set_file (self.id,file)
	def __setattr__ (self,name,value):
		if name=="background":
			objects.set_color(self.id,value,0)
		elif name=="foreground":
			objects.set_lcol(self.id,value)
		else:
			XFObject.__setattr__(self,name,value)


###############################################################################
# The Pixmap Class

class Pixmap(XFObject):
	def __init__(self,t=0,x=10,y=10,w=100,h=100,l="Pixmap"):
		XFObject.__init__ (self)
		self.id=pixmaps.create(t,x,y,w,h,l)
	def Load (self,file):
		pixmaps.set_file (self.id,file)
	def __setattr__ (self,name,value):
		if name=="background":
			objects.set_color(self.id,value,0)
		elif name=="foreground":
			objects.set_lcol(self.id,value)
		else:
			XFObject.__setattr__(self,name,value)


###############################################################################
# The Box Class

class Box(XFObject):
	def __init__(self,t=6,x=10,y=10,w=90,h=90,l="Box"):
		XFObject.__init__ (self)
		self.id=box.create(t,x,y,w,h,l)
###############################################################################
# The Browser class
#
# I want the Browser class to act just like what it is: a list
# only with a "few" more methods and stuff

class Browser (XFObject):
	def __init__(self,t=1,x=10,y=10,w=90,h=120,l="Browser"):
		XFObject.__init__ (self)
		self.id=browser.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Add(self,line):
		browser.add_line (self.id,line)
	def Addto(self,line):
		browser.addto (self.id,line)
	def Insert(self,n,line):
		browser.insert_line(self.id,n,line)
	def Delete(self,n):
		browser.delete_line(self.id,n)
	def Replace(self,n,line):
		browser.replace_line(self.id,n,line)
	def Getline(self,n):
		return browser.get_line (self.id,n)
	def Load(self,path):
		return browser.load (self.id,path)
	def Select(self,n):
		browser.select_line (self.id,n)	
	def Deselect(self,n):
		browser.deselect_line (self.id,n)
	def Deselectall(self):
		browser.deselect(self.id)
	def Isselected(self,n):
		return browser.isselected_line(self.id,n)
	def Gettopline(self):
		return browser.get_topline(self.id)
	def Get(self):
		return browser.get(self.id)
	def Getmaxline(self):
		return browser.get_maxline(self.id)
	def Screenlines(self):
		return browser.get_screenlines(self.id)
	def Settopline(self,n):
		browser.set_topline(self.id,n)
	def Setfontsize(self,n):
		browser.set_fontsize(self.id,n)
	def Setfontstyle(self,n):
		browser.set_fontstyle(self.id,n)
	def Setspecialkey(self,c):
		browser.set_specialkey(self.id,c)
	def Setleftslider(self,l):
		browser.set_leftslider(self.id,l)
	def __setattr__ (self,name,value):
		if name=="leftslider":
			self.Setleftslider(value)
		elif name=="specialkey":
			self.Setspecialkey(value)
		elif name=="fontstyle":
			self.Setfontstyle(value)
		elif name=="fontsize":
			self.Setfontsize(value)
		elif name=="topline":
			self.Settopline(value)
		else:
			XFObject.__setattr__(self,name,value)
		
	
		
###############################################################################
#This is the Button class.

class Button(XFObject):
	def __init__(self,t=0,x=10,y=10,w=90,h=30,l="Button"):
		XFObject.__init__ (self)
		self.id=button.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def __call__(self,v=-1):
# I think this is nice: if you have a button called b,
# b() returns the button's value
# b(1) or b(0) SETS the button value.
# You can also set/get it with b.value, though
		if v==-1:
			return button.get(self.id)
		else:
			button.set (self.id,v)

	def __setattr__ (self,name,value):
		if name=="value":
			self(value)
		else:
			XFObject.__setattr__(self,name,value)

	def __getattr__ (self,name):
		if name=="value":
			return self()
		elif name=="numb":
			return button.get_numb (self.id)
			pass
		else:
			return XFObject.__getattr__(self,name)

###############################################################################
# This is the Roundbutton class

class Roundbutton (Button):
	def __init__(self,t=0,x=10,y=10,w=90,h=30,l="Roundbutton"):
		XFObject.__init__ (self)
		self.id=button.create_round(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
###############################################################################
# This is the Lightbutton class

class Lightbutton (Button):
	def __init__(self,t=0,x=10,y=10,w=90,h=30,l="Lightbutton"):
		XFObject.__init__ (self)
		self.id=button.create_light(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
###############################################################################
# This is the Checkbutton class

class Checkbutton (Button):
	def __init__(self,t=0,x=10,y=10,w=90,h=30,l="Checkbutton"):
		XFObject.__init__ (self)
		self.id=button.create_check(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
###############################################################################
# This is the Bitmapbutton class

class Bitmapbutton (Button):
	def __init__(self,t=0,x=10,y=10,w=90,h=30,l="Bitmapbutton"):
		XFObject.__init__ (self)
		self.id=button.create_bitmap(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
###############################################################################
# This is the Pixmapbutton class

class Pixmapbutton (Button):
	def __init__(self,t=0,x=10,y=10,w=90,h=30,l="Pixmapbutton"):
		XFObject.__init__ (self)
		self.id=button.create_pixmap(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
###############################################################################
# This is the Choice Class
#This one needs a getattr, setattr pair

class Choice (XFObject):
	def __init__(self,t=0,x=10,y=10,w=90,h=30,l="Choice"):
		XFObject.__init__ (self)
		self.id=choice.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Clear (self):
		choice.clear(self.id)
	def Addto (self,s):
		choice.addto(self.id,s)
	def Replace (self,n,s):
		choice.replace(self.id,n,s)
	def Delete (self,n):
		choice.delete(self.id,n)
	def Set (self,n):
		choice.set(self.id,n)
	def Settext (self,s):
		choice.set_text (self.id,s)
	def Get (self):
		return choice.get (self.id)
	def Getmaxitems (self):
		return choice.get_maxitems (self.id)
	def Gettext (self):
		return choice.get_text (self.id)
	def Setfontsize (self,n):
		choice.set_fontsize(self.id,n)
	def Setalign (self,n):
		choice.set_align (self.id,n)
	def Setmode (self,n,m):
		choice.set_item_mode (self.id,n,m)

##############################################################################
# This is the clock class

class Clock (XFObject):
	def __init__(self,t=0,x=10,y=10,w=90,h=90,l="Clock"):
		XFObject.__init__ (self)
		self.id=clock.create(t,x,y,w,h,l)
	def Get (self):
		return clock.get (self.id)
##############################################################################
# This is the counter class


class Counter (XFObject):
	def __init__(self,t=0,x=10,y=10,w=90,h=30,l="Counter"):
		XFObject.__init__ (self)
		self.id=counter.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Set (self,v):
		counter.set_value (self.id,v)
	def Setbounds (self,min,max):
		counter.set_bounds (self.id,min,max)
	def Setstep (self,s1,s2):
		counter.set_step (self.id,s1,s2)
	def Setprecision (self,p):
		counter.set_precision (self.id,p)
	def Get (self):
		return counter.get_value (self.id)
	def Setreturn (self,v):
		counter.set_return (self.id,v)

##############################################################################
# This is the Dial class

class Dial (XFObject):
	def __init__(self,t=0,x=10,y=10,w=60,h=60,l="Dial"):
		XFObject.__init__ (self)
		self.id=dial.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Set (self,v):
		dial.set_value(self.id,v)
	def Get (self):
		return dial.get_value (self.id)
	def Setbounds (self,min,max):
		dial.set_bounds (self.id,min,max)
	def Getbounds (self):
		return dial.get_bounds (self.id)
	def Setstep (self,v):
		dial.set_step (self.id,v)
	def Setreturn (self,v):
		dial.set_return (self.id,v)

###############################################################################
# This is the Frame class
class Frame (XFObject):
	def __init__(self,t=0,x=10,y=10,w=60,h=60,l="Frame"):
		XFObject.__init__ (self)
		self.id=frame.create(t,x,y,w,h,l)
###############################################################################
# This is the Input class


class Input (XFObject):
	def __init__(self,t=0,x=10,y=10,w=60,h=30,l="Input"):
		XFObject.__init__ (self)
		self.id=input.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Set (self,s):
		input.set (self.id,s)
	def Setcolor (self,c1,c2):
		input.set_color (self.id,c1,c2)
	def Get (self):
		return input.get(self.id)
	def Setreturn (self,v):
		input.set_return (self.id,v)
	def Setscroll (self,v):
		input.set_scroll (self.id,v)
	def Setcursorpos (self,x,y=1):
		input.set_cursorpos (self.id,x,y)
	def Setselected (self,v):
		input.set_selected (self.id,v)
	def Setselectedrange (self,x1,x2):
		input.set_selected_range (self.id,x1,x2)
	def __setattr__ (self,name,value):
		if name=="value":
			self.Set(value)
		else:
			XFObject.__setattr__(self,name,value)

	def __getattr__ (self,name):
		if name=="value":
			return self.Get()
		else:
			return XFObject.__getattr__(self,name)
	
		
###############################################################################
# This is the Menu class

class Menu (XFObject):
	def __init__(self,t=0,x=10,y=10,w=60,h=30,l="Menu"):
		XFObject.__init__ (self)
		self.id=menu.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Clear (self):
		menu.clear (self.id)
	def Set (self,s):
		menu.set (self.id,s)
	def Addto (self,s):
		menu.addto(self.id,s)
	def Replace (self,n,s):
		menu.replace_item (self.id,n,s)
	def Delete (self,n):
		menu.delete_item (self.id,n)
	def Setshortcut (self,n,s):
		menu.set_item_shortcut (self.id,n,s)
	def Setmode (self,n,m):
		menu.set_item_mode (self.id,n,m)
	def Showsymbol (self,n):
		menu.show_symbol (self.id,n)
	def Get (self):
		return menu.get (self.id)
	def Getmaxitems (self):
		return menu.get_maxitems (self.id)
	def Gettext (self):
		return menu.get_text (self.id)

###############################################################################
# This is the Positioner class

class Positioner (XFObject):
	def __init__(self,t=0,x=10,y=10,w=60,h=60,l="Positioner"):
		XFObject.__init__ (self)
		self.id=positioner.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Setx (self,v):
		positioner.set_xvalue (self.id,v)
	def Sety (self,v):
		positioner.set_yvalue (self.id,v)
	def Setxbounds (self,x1,x2):
		positioner.set_xbounds (self.id,x1,x2)
	def Setybounds (self,y1,y2):
		positioner.set_ybounds (self.id,y1,y2)
	def Setxstep (self,v):
		positioner.set_xstep (self.id,v)
	def Setystep (self,v):
		positioner.set_ystep (self.id,v)
	def Getx (self):
		return positioner.get_xvalue (self.id)
	def Gety (self):
		return positioner.get_yvalue (self.id)
	def Getxbounds (self):
		positioner.get_xbounds (self.id)
	def Getybounds (self):
		positioner.get_ybounds (self.id)
	def Setreturn (self,v):
		positioner.set_return (self.id,v)
###############################################################################
# This is the Slider class

class Slider (XFObject):
	def __init__(self,t=0,x=10,y=10,w=60,h=30,l="Slider"):
		XFObject.__init__ (self)
		self.id=slider.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Get (self):
		return slider.get_value (self.id)
	def Set (self,v):
		slider.set_value(self.id,v)
	def Getbounds (self):
		return slider.get_bounds (self.id)
	def Setbounds (self,v1,v2):
		slider.set_bounds(self.id,v1,v2)
	def Setreturn (self,v):
		slider.set_return (self.id,v)	
	def Setstep (self,v):
		slider.set_step (self.id,v)
	def Setsize (self,v):
		slider.set_size (self.id,v)

###############################################################################
# This is the Valslider class

class Valslider (Slider):
	def __init__(self,t=0,x=10,y=10,w=60,h=30,l="Valslider"):
		XFObject.__init__ (self)
		self.id=slider.create_val(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Setprecision (self,v):
		slider.set_precision (self.id,v)

##############################################################################
# This is the Timer class

class Timer (XFObject):
	def __init__(self,t=1,x=10,y=10,w=60,h=30,l="Timer"):
		XFObject.__init__ (self)
		self.id=timer.create(t,x,y,w,h,l)
		_objects[str(self.id)]=self
		self.cb=_nocb
		self.args=self
	def Set (self,v):
		timer.set(self.id,v)
	def Get (self):
		return timer.get (self.id)
