#
# Test script to test various image modules.
#
import sys
sys.path.append('..')

import imgformat
import imgppm
import imgpgm
import imgpbm
import imgtiff
try:
	import imgsgi
except ImportError:
	imgsgi = None
import imgjpeg
import imggif

warning = 0

def checksize(r):
    if (r.width, r.height) != (width, height):
	print '** W/H change: wanted', (width,height), 'got', (r.width, r.height)
	sys.exit(1)

def checkreader(r, wtddata):
    global warning
    checksize(r)
    d = r.read()
    if len(d) <> len(wtddata):
	print '** Datalength change: wanted',len(wtddata),'got',len(d)
	sys.exit(1)
    if d <> wtddata:
	print '** (warning) data changed'
	warning = 1
	for i in range(len(d)):
	    if d[i] <> wtddata[i]:
		print '   First at byte', i
		print `wtddata[i:i+4]`, `d[i:i+4]`
		break
#
# Part one - Test ppm reader/writer
#
print '- Read ppm original image'
r = imgppm.reader('in-rgb-t2b.ppm')
width, height = r.width, r.height
rgb_t2b_data = r.read()
del r

print '- Write ppm original image'
w = imgppm.writer('out-rgb-t2b.ppm')
w.width, w.height, w.format = width, height, imgformat.rgb
w.write(rgb_t2b_data)
del w

print '- Write ppm upsidedown image'
w = imgppm.writer('out-rgb-b2t.ppm')
w.width, w.height, w.format = width, height, imgformat.rgb_b2t
w.write(rgb_t2b_data)
del w

print '- Read ppm upsidedown image'
r = imgppm.reader('out-rgb-b2t.ppm')
checksize(r)
rgb_b2t_data = r.read()
del r

#
# part 2 - test pgm module
#

print '- Read pgm original image'
r = imgpgm.reader('in-grey-t2b.pgm')
checksize(r)
grey_t2b_data = r.read()
del r

print '- Write pgm original image'
w = imgpgm.writer('out-grey-t2b.pgm')
w.width, w.height, w.format = width, height, imgformat.grey
w.write(grey_t2b_data)
del w

print '- Write pgm upsidedown image'
w = imgpgm.writer('out-grey-b2t.pgm')
w.width, w.height, w.format = width, height, imgformat.grey_b2t
w.write(grey_t2b_data)
del w

print '- Read pgm upsidedown image'
r = imgpgm.reader('out-grey-b2t.pgm')
checksize(r)
grey_b2t_data = r.read()
del r

#
# step 3 - Test sgi module
#
if imgsgi:
	print '- Write sgi rgb image'
	w = imgsgi.writer('out-rgb-t2b.rgb')
	w.width, w.height, w.format = width, height, imgformat.rgb
	w.write(rgb_t2b_data)
	del w
	
	print '-  (checking)'
	r = imgsgi.reader('out-rgb-t2b.rgb')
	checkreader(r, rgb_t2b_data)
	del r
	
	print '- Write sgi rgb image upsidedown'
	w = imgsgi.writer('out-rgb-b2t.rgb')
	w.width, w.height, w.format = width, height, imgformat.rgb
	w.write(rgb_b2t_data)
	del w
	
	print '-  (checking)'
	r = imgsgi.reader('out-rgb-b2t.rgb')
	r.format = imgformat.rgb_b2t
	checkreader(r, rgb_t2b_data)
	del r
	
	print '- Write sgi grey image (cannot check)'
	w = imgsgi.writer('out-grey-t2b.rgb')
	w.width, w.height, w.file_format = width, height, imgformat.grey
	w.write(rgb_t2b_data)
	del w
	
	print '- Write sgi grey image upsidedown (cannot check)'
	w = imgsgi.writer('out-grey-b2t.rgb')
	w.width, w.height, w.file_format = width, height, imgformat.grey_b2t
	w.write(rgb_t2b_data)
	del w
else:
	print '- ** No SGI support available'

#
# Step 4 - JPEG writer
#
print '- Write jpeg rgb image (cannot check)'
w = imgjpeg.writer('out-rgb-t2b.jpg')
w.width, w.height, w.format = width, height, imgformat.rgb
w.write(rgb_t2b_data)
del w

print '- Read jpeg rgb image and copy to ppm'
r = imgjpeg.reader('out-rgb-t2b.jpg')
checksize(r)
w = imgppm.writer('out-rgb-t2b-viajpeg.ppm')
w.width, w.height = width, height
w.write(r.read())
del w
del r

print '- Write jpeg grey image (cannot check)'
w = imgjpeg.writer('out-grey-t2b.jpg')
w.width, w.height, w.format = width, height, imgformat.grey
w.write(grey_t2b_data)
del w

print '- Read jpeg grey image and copy to pgm'
r = imgjpeg.reader('out-grey-t2b.jpg')
r.format = imgformat.grey
checksize(r)
w = imgpgm.writer('out-rgb-t2b-viajpeg.pgm')
w.width, w.height = width, height
w.write(r.read())
del w
del r


#
# step 5 - TIFF writer
#
print '- Write tiff rgb image'
w = imgtiff.writer('out-rgb-t2b.tiff')
w.width, w.height, w.format = width, height, imgformat.rgb
w.write(rgb_t2b_data)
del w

print '  (check)'
r = imgtiff.reader('out-rgb-t2b.tiff')
checkreader(r, rgb_t2b_data)
del r

print '- Write tiff grey image'
w = imgtiff.writer('out-grey-t2b.tiff')
w.width, w.height, w.format = width, height, imgformat.grey
w.write(grey_t2b_data)
del w

print '  (check)'
r = imgtiff.reader('out-grey-t2b.tiff')
checkreader(r, grey_t2b_data)
del r

print '- Read tiff grey image and copy to rgb ppm'
r = imgtiff.reader('out-grey-t2b.tiff')
if r.format <> imgformat.grey:
    print '* It is not a greyscale image!'
r.format = imgformat.rgb
checksize(r)
w = imgppm.writer('out-grey-t2b-rgbviatiff.ppm')
w.width, w.height = width, height
w.write(r.read())
del w
del r

print '- Read tiff rgb image and copy to grey pgm'
r = imgtiff.reader('out-rgb-t2b.tiff')
if r.format <> imgformat.rgb:
    print '* It is not a rgb image!'
r.format = imgformat.grey
checksize(r)
w = imgpgm.writer('out-grey-t2b-greyviatiff.pgm')
w.width, w.height = width, height
w.write(r.read())
del w
del r

#
# Step 6 - GIF reader
#
print '- Read GIF image and copy to GIF'
r = imggif.reader('in-map-t2b.gif')
checksize(r)
w = imggif.writer('out-map-t2b.gif')
w.width, w.height, w.colormap = r.width, r.height, r.colormap
gifdata = r.read()
w.write(gifdata)
gifmap = r.colormap
del r
del w

print '- Re-read GIF image, compare and re-write'
r = imggif.reader('out-map-t2b.gif')
checksize(r)
newdata = r.read()
if newdata <> gifdata:
    print '* Re-read GIF data differs!', (gifdata[:16], newdata[:16])
    warning = 1
if gifmap._map_as_string <> r.colormap._map_as_string:
    print '* Re-read GIF colormap differs!: ', (gifmap._map_as_string[:16],
						r.colormap._map_as_string[:16])
    warning = 1
w = imggif.writer('out-map-t2b-2.gif')
w.width, w.height, w.colormap = r.width, r.height, r.colormap
w.write(newdata)
del r
del w
del gifmap
del gifdata
del newdata

print '- Read GIF image, map, and copy to ppm'
r = imggif.reader('in-map-t2b.gif')
checksize(r)
w = imgppm.writer('out-rgb-t2b-viagif.ppm')
w.width, w.height = r.width, r.height
gifdata = r.read()
rgbdata = r.colormap.map(gifdata, r.width, imgformat.colormap, imgformat.rgb)
w.write(rgbdata)
del r
del w
del rgbdata
del gifdata

print '- Read GIF image upsidedown, map, and copy to ppm'
r = imggif.reader('in-map-t2b.gif')
r.format = imgformat.colormap_b2t
checksize(r)
w = imgppm.writer('out-rgb-b2t-viagif.ppm')
w.width, w.height = r.width, r.height
gifdata = r.read()
rgbdata = r.colormap.map(gifdata, r.width, imgformat.colormap, imgformat.rgb)
w.write(rgbdata)
del r
del w
del rgbdata
del gifdata

#
# Step 7 - Test pict writer
#
##print '- Write PICT rgb image'
##w = imgpict.writer('out-rgb-t2b.pict')
##w.width, w.height, w.format = width, height, imgformat.rgb
##w.write(rgb_t2b_data)
##del w
#
# Part 8 - Test pbm reader/writer
#
print '- Read pbm original image'
r = imgpbm.reader('in-icon.pbm')
width, height = r.width, r.height
mono_data = r.read()
del r

print '- Write pbm original image'
w = imgpbm.writer('out-icon.pbm')
w.width, w.height, w.format = width, height, imgformat.pbmbitmap
w.write(mono_data)
del w

print '- Re-read pbm image'
r = imgpbm.reader('out-icon.pbm')
checkreader(r, mono_data)

print '- Dither grey to mono and write'
try:
    from imgop import dither
except ImportError:
    print '** skipped (no ditherer)'
    dither = None
if dither:
    r = imgpgm.reader('in-grey-t2b.pgm')
    w = imgpbm.writer('out-mono-t2b.pbm')
    d = dither(r.read(), r.width, r.height, r.format, imgformat.pbmbitmap)
    w.width, w.height, w.format = r.width, r.height, imgformat.pbmbitmap
    w.write(d)

print '- Read PBM file as PGM and write'
r = imgpgm.reader('in-icon.pbm')
w = imgpgm.writer('out-icon.pgm')
w.width, w.height, w.format = r.width, r.height, r.format
w.write(r.read())

if warning:
	sys.exit(1)
	

