"""imgconvert - A very simple image converter."""
import img
import sys

# Set trace, so we can see what happens
img.settrace(1)

if len(sys.argv) <> 3:
    print 'Usage:',sys.argv[0],'inimage outimage'
    sys.exit(1)
#
# Create a non-converting writer (we do conversion in the reader)
#
writer = img.writer(None, sys.argv[2])
#
# Create a reader that converts to the preferred output format
#
reader = img.reader(writer.format, sys.argv[1])
#
# Set output file parameters
#
writer.width, writer.height = reader.width, reader.height
if reader.format.descr['type'] == 'mapped':
    writer.colormap = reader.colormap
#
# Copy the data
#
data = reader.read()
writer.write(data)
#
# Done
#
sys.exit(0)
