"""
Read and write SGI image files using the 'rgbimg' module
"""
#
# SGI image file reader/writer module
#
import rgbimg
from imgformat import rgb, rgb_b2t, grey, grey_b2t

error = 'imgsgi.error'

class reader:
    """Object that reads an SGI image file. The 'format', 'width' and
    'height' attributes describe the image"""
    
    def __init__(self, filename):
	self._filename = filename
	self.width, self.height = rgbimg.sizeofimage(filename)
	self.format = rgb
	self.format_choices = (rgb, rgb_b2t)

    def args(self):
	return self.__dict__
	
    def read(self):
	"read the actual image data"
	
	if self.format == rgb:
	    old = rgbimg.ttob(1)
	elif self.format == rgb_b2t:
	    old = rgbimg.ttob(0)
	else:
	    raise error, 'Unsupported image format: '+`self.format`
	data = rgbimg.longimagedata(self._filename)
	rgbimg.ttob(old)
	return data

    def write(self, data):
	"dummy method: you cannot write to a reader object"
	
	raise error, 'Cannot write() to reader'

class writer:
    """Object that writes an SGI image file. The 'format', 'width' and
    'height' attributes describe the image"""
    
    def __init__(self, filename):
	self._filename = filename
	self.format_choices = (rgb, rgb_b2t)
	self.format = rgb
	self.file_format = rgb
	self.file_format_choices = (rgb, rgb_b2t, grey, grey_b2t)

    def args(self):
	return self.__dict__
	
    def _get(self, attr):
	try:
	    return getattr(self, attr)
	except AttributeError:
	    raise error, "Required attribute '%s' missing"%attr

    def read(self):
	"dummy method: you cannot read from a writer object"
	
	raise error, 'Cannot read() from writer'


    def write(self, data):
	"write data to the image file"
	
	w = self._get('width')
	h = self._get('height')

	if not self.format in (rgb, rgb_b2t):
	    raise error, 'Unsupported image format: '+`self.format`
	if not self.file_format in (rgb, rgb_b2t, grey, grey_b2t):
	    raise error, 'Unsupported file format: '+`self.format`

	upside_down = 0
	if self.format in (rgb_b2t, grey_b2t):
	    upside_down = (not upside_down)
	if self.file_format in (rgb_b2t, grey_b2t):
	    upside_down = (not upside_down)
	if upside_down:
	    old = rgbimg.ttob(0)
	else:
	    old = rgbimg.ttob(1)

	if w*h*4 != len(data):
	    raise error, 'Incorrect datasize'

	if self.file_format in (grey, grey_b2t):
	    depth = 1
	else:
	    depth = 3
	    
	data = rgbimg.longstoimage(data, w, h, depth, self._filename)
	rgbimg.ttob(old)
	    
def _test():
    rdr = reader('test.rgb')
    print 'Image size is',rdr.width,'by',rdr.height
    data = rdr.read()
    print 'Saving output'
    wr = writer('test_out.rgb')
    wr.width, wr.height = rdr.width, rdr.height
    wr.file_format = rgb
    wr.write(data)
    print 'Saving upside-down output'
    wr = writer('test_out_b2t.rgb')
    wr.width, wr.height = rdr.width, rdr.height
    wr.file_format = rgb_b2t
    wr.write(data)
    print 'Saving grey output'
    wr = writer('test_out_grey.rgb')
    wr.width, wr.height = rdr.width, rdr.height
    wr.file_format = grey
    wr.write(data)
    print 'Saving grey upside-down output'
    wr = writer('test_out_grey_b2t.rgb')
    wr.width, wr.height = rdr.width, rdr.height
    wr.file_format = grey_b2t
    wr.write(data)
    
if __name__ == '__main__':
    _test()
