#!/usr/local/bin/python -i
import gd
import sys

# our test output image
im_out=gd.image((128,128))
white = im_out.colorAllocate((255,255,255))
im_out.colorTransparent(white)

# input image
im_in=gd.image("demoin.gif")
im_in.copyResizedTo(im_out,(16,16),(0,0),(96,96))

red = im_out.colorAllocate((255,0,0))
green = im_out.colorAllocate((0,255,0))
blue = im_out.colorAllocate((0,0,255))

# test origin - switch to lower left type origin
im_out.origin((0,128),1,-1)
im_out.line((50,0),(128,50), red)
im_out.origin((0,0),1,1)

# rectangle
im_out.line((8,8), (120,8), green)
im_out.line((120,8), (120,120), green)
im_out.line((120,120), (8,120), green)
im_out.line((8,120), (8,8), green)

im_out.string(gd.gdFontLarge, (16,16), "hi", red)
im_out.stringUp(gd.gdFontSmall, (32,32), "hi", red)

im_out.arc((64,64), (30,10), 0, 360, blue)
im_out.arc((64,64), (20,20), 45, 135, blue)

im_out.fill((4,4), blue)

im_out.polygon(((32,0),(0,64),(64,64)),green)

# a brush
im_out.setBrush(gd.image(im_in,(8,8)))
im_out.setStyle((0,0,0,0,0,0,0,1))
im_out.line((128,0),(0,128),gd.gdStyledBrushed)

im_out.interlace(1)

im_out.writeGif("demoout.gif")

