#!/usr/bin/env python
######################################################################
# This module provides some standard dialog classes.
# 
# Mitch Chapman
#---------------------------------------------------------------------
# $Log: StdDialog.py,v $
# Revision 1.1  1996/12/01 22:58:54  mchapman
# Initial revision
#
######################################################################


__version__ = "$Revision: 1.1 $"

import Tkinter; Tk=Tkinter
import Shells, ButtonBox

######################################################################
# This class creates basic dialog contents:  a frame and
# a btnBox.
######################################################################
class Controls:
    ##################################################################
    # Init a new instance.  master must be a Shells.NonModal
    # subclass.
    ##################################################################
    def __init__(self, master, okCB=None, cancelCB=None, helpCB=None):
	self.master = master
	
	# Subclasses should put their custom controls inside the
	# frame.
	self.frame = Tk.Frame(master.top, relief='raised', bd=1)
	self.frame.pack(side='top', fill='both', expand='yes')

	self.btnBox = ButtonBox.T(master.top)
	self.btnBox.frame.pack()


######################################################################
# This class creates "standard" dialog contents and some std buttons.
######################################################################
class StdControls(Controls):
    ##################################################################
    # Init a new instance.  master must be a Shells.NonModal
    # subclass.
    ##################################################################
    def __init__(self, master, okCB=None, cancelCB=None, helpCB=None):
	apply(Controls.__init__, (self, master))

	self.btnBox.addButtons(["OK", okCB],
			       ["Cancel", cancelCB],
			       ["Help", helpCB])

######################################################################
# This is a non-modal dialog with the standard dialog buttons.
######################################################################
class NonModal(Shells.NonModal):
    ##################################################################
    # Init a new instance.
    # The optional arguments are lists or tuples, each specifying the
    # name and (optionally) command for a new dialog button.
    ##################################################################
    def __init__(self, master, *args):
        Shells.NonModal.__init__(self, master)
	self.controls = StdControls(self, self.okCB, self.cancelCB,
				    self.helpCB)

    ##################################################################
    # Define callbacks for the standard buttons, for subclasses.
    ##################################################################
    def okCB(self, event=None):
	self.terminate()
	return self.result

    def cancelCB(self, event=None):
	self.terminate()
	return self.result

    def helpCB(self, event=None):
	return

######################################################################
# This is a modal dialog with the standard set of dialog buttons
# arrayed across the bottom.
######################################################################
class Modal(Shells.Modal):
    ##################################################################
    # Initialize a new instance.
    # The optional arguments are lists or tuples, each specifying the
    # name and (optionally) command for a new dialog button.
    ##################################################################
    def __init__(self, master, *args):
        Shells.Modal.__init__(self, master)
	self.controls = StdControls(self, self.okCB, self.cancelCB,
				    self.helpCB)

    ##################################################################
    # Define callbacks for the standard buttons, for subclasses.
    ##################################################################
    def okCB(self, event=None):
	self.terminate()
	return self.result

    def cancelCB(self, event=None):
	self.terminate()
	return self.result

    def helpCB(self, event=None):
	return


######################################################################
# Main function for unit testing.
######################################################################
def main():
    f = Shells.Main()
    f.pack()

    quitBtn = Tk.Button(f, text="Quit", command=f.quit)
    quitBtn.pack()
    
    d = Modal(f)
    Tk.Label(d.controls.frame, text="Press a button").pack()
    
    result = d.show()
    print "Modal Result =", result
    d.destroy()
    d = NonModal(f)
    Tk.Label(d.controls.frame,
	     text="Press a button\nwhenever you're ready").pack()
    d.show()
    f.mainloop()

if __name__ == "__main__":
    main()
