######################################################################
# This class provides an Entry with a label on its left side.
# The text of the label can be set by means of the 'text'
# configuration key.
#
# Mitch Chapman
#---------------------------------------------------------------------
# $Log: LabelEntry.py,v $
# Revision 1.1  1996/12/01 22:58:54  mchapman
# Initial revision
#
######################################################################

__version__ = "$Revision: 1.1 $"

import Tkinter; Tk=Tkinter

######################################################################
# A MultiColEntry is a label together with one or more entries.
# Clients have direct access to the constituent widgets:
#   frame   -- the frame containing the other widgets.
#   label   -- the label appearing on the left side
#   entries -- The entries arrayed across from left to right
######################################################################
class MultiColEntry:
    ##################################################################
    # Initialize a new instance.
    ##################################################################
    def __init__(self, master=None, columns=2, entryClass=Tk.Entry):
	f = self.frame = Tk.Frame(master)
	l = self.label = Tk.Label(f, anchor='ne')
	l.pack(side='left')
	self.entries = []
	for i in range(columns):
	    e = entryClass(f)
	    self.entries.append(e)
	    e.pack(side='left', fill='x', expand='yes')
	    
    ##################################################################
    # Set the values of one or more entry fields.
    # It's the caller's responsibility not to exceed the number of
    # entries in self.
    ##################################################################
    def setValues(self, startIndex=0, *newValues):
        i = startIndex
        for v in newValues:
            e = self.entries[i]
            e.delete('0', 'end')
	    e.insert('end', v)


######################################################################
# A labelled entry is a MultiColEntry with only one entry column.
# The instance variable "entry" provides a more-convenient way to
# refer to the sole entry widget.
######################################################################
class LabelEntry(MultiColEntry):
    ##################################################################
    # Initialize a new instance.
    ##################################################################
    def __init__(self, master=None, entryClass=Tk.Entry):
	MultiColEntry.__init__(self, master, 1, entryClass)
	self.entry = self.entries[0]

    ##################################################################
    # Set the whole value of an Entry.
    ##################################################################
    def setValue(self, newValue):
	self.entry.delete(0, 'end')
	self.entry.insert('end', newValue)

    ##################################################################
    # Delete LabelEntry text.
    ##################################################################
    def delete(self, first, last=None):
	self.entry.delete(first, last)

    ##################################################################
    # Insert LabelEntry text.
    ##################################################################
    def insert(self, index, string):
	self.entry.insert(index, string)

######################################################################
# A ROLabelEntry is read-only, so far as the user is concerned.
######################################################################
class ROLabelEntry(LabelEntry):
    def __init__(self, master=None):
	LabelEntry.__init__(self, master, Tk.Entry)
	self.entry['state'] = 'disabled'

    ##################################################################
    # Delete text from the entry.
    ##################################################################
    def delete(self, first, last=None):
	self.entry['state'] = 'normal'
	self.entry.delete(first, last)
	self.entry['state'] = 'disabled'

    ##################################################################
    # Insert text into the entry.
    ##################################################################
    def insert(self, index, string):
	self.entry['state'] = 'normal'
	self.entry.insert(index, string)
	self.entry['state'] = 'disabled'
    

######################################################################
# Main function for unit testing.
######################################################################
def main():
    f = Tk.Frame()

    le = LabelEntry(f)
    le.label['text'] = "New Value:"
    newValue = "This is the new value."
    le.entry['width'] = len(newValue)
    le.insert('end', newValue)

    readOnly = ROLabelEntry(f)
    readOnly.label['text'] = 'Label:'
    readOnly.entry['relief'] = 'groove'
    for w in [readOnly.label, readOnly.entry]:
	w['width'] = 40
	
    readOnly.insert('0', 'This is the value')

    mc = MultiColEntry(f, 8)
    mc.label['text'] = "Multi:"
    map(lambda e: e.config(width=8), mc.entries)

    for w in [le, readOnly, mc]:
        w.label['width'] = 12
	w.frame.pack(fill='x')

    f.update()
    f.pack()
    f.wait_visibility()
    f.after(2000, readOnly.insert, 'end', ' after 2 seconds')

    ##################################################################
    # Insert text in a multi-column widget.
    ##################################################################
    def insertMulti(mc):
	map(lambda e: e.insert('end', 'This is ' + `e`), mc.entries)

    mc.setValues(2, "This is entry 2.", "This is entry 3.", "This is entry 4.")

    f.after(4000, insertMulti, mc)
    f.mainloop()

if __name__ == "__main__":
    main()
