#!/usr/bin/env python
######################################################################
# This module defines commonly-used CDE cursors.
#
# Mitch Chapman
#---------------------------------------------------------------------
# $Log: Cursors.py,v $
# Revision 1.1  1996/12/01 22:58:54  mchapman
# Initial revision
#
######################################################################

__version__ = "$Revision: 1.1 $"

import Tkinter

# If you're running Solaris >= 2.4, you might want to try these
# cursors:
#busyCursorTuple = ('@/usr/dt/include/bitmaps/xm_hour16',
#		   '/usr/dt/include/bitmaps/xm_hour16m',
#		   'black', 'white')
#noEnterCursorTuple = ('@/usr/dt/include/bitmaps/xm_noenter16',
#		      '/usr/dt/include/bitmaps/xm_noenter16m',
#		      'black', 'white')
#
# Clients can specify any of these cursors for CDE-style cursoring.
#busyCursor = "%s %s %s %s" % busyCursorTuple
#noEnterCursor = "%s %s %s %s" % noEnterCursorTuple

busyCursor = "watch"
noEnterCursor = "X_cursor red white"

# _instances records all instances of Mixin.  (See below.)
_instances = {}

######################################################################
# This mixin class gives the ability to push and pop cursors on a
# widget.
######################################################################
class Mixin:
    ##################################################################
    # Initialize a new instance.
    ##################################################################
    def __init__(self):
	# Register self to participate in cursoring.  Whenever other
	# Mixin instances pushOtherCursors(), self will get a new
	# cursor.
	_instances[self] = self
	self.cursorStack = []

    ##################################################################
    # Destroy self.  (Is this the right way to do this?)
    ##################################################################
    def destroy(self):
        del _instances[self]  # De-register self
	
    ##################################################################
    # Set a cursor on self.
    ##################################################################
    def setCursor(self, cursor):
	# Why not just self.config(cursor=cursor)?
	# I originally wanted to be able to mix this in to class Tk.
	apply(self.tk.call, (self._w, "configure", "-cursor", cursor))

    ##################################################################
    # Push a cursor on self.  (Doesn't affect other CursorMixin
    # instances.)
    ##################################################################
    def pushCursor(self, newCursor):
	self.setCursor(newCursor)
	self.cursorStack.append(newCursor)

    ##################################################################
    # Pop a cursor off self.
    ##################################################################
    def popCursor(self):
	stack = self.cursorStack
	# Pop.
	if stack:
	    del stack[-1]
	# Re-install the old cursor, or else the default cursor.
	if stack:
	    self.setCursor(stack[-1])
	else:
	    self.setCursor('')

    ##################################################################
    # Push a cursor on all other registered instances.
    # This is useful e.g. when displaying a modal dialog, and
    # displaying busy cursors in other dialogs and toplevels.
    ##################################################################
    def pushOtherCursors(self, newCursor):
	for w in _instances.keys():
	    if w != self:
		w.pushCursor(newCursor)

    ##################################################################
    # Pop a cursor from all other registered instances.
    ##################################################################
    def popOtherCursors(self):
	for w in _instances.keys():
	    if w != self:
		w.popCursor()

