#!/usr/bin/env python
######################################################################
# This module provides a composite widget for dialog buttons.
# 
# Mitch Chapman
#---------------------------------------------------------------------
# $Log: ButtonBox.py,v $
# Revision 1.1  1996/12/01 22:58:54  mchapman
# Initial revision
#
######################################################################

__version__ = "$Revision: 1.1 $"

import Tkinter; Tk=Tkinter
import KWDict

######################################################################
# This class provides a horizontal array of std dialog buttons.
######################################################################
class T:
    ##################################################################
    # Add buttons to self.
    # argtuple should be a tuple of lists or tuples
    # specifying the label and (optionally) command for each button
    # to be added to the frame.
    ##################################################################
    def _addButtons(self, argtuple):
	Button = Tk.Button
	f = self.frame
	maxWidth = self.maxWidth
	for btnInfo in argtuple:
	    label, cmd = btnInfo[0], None
	    if len(btnInfo) > 1:
		cmd = btnInfo[1]
	    btn = Button(f, KWDict.dict(text=label, command=cmd))
	    btn.pack(side='left', padx='2m', expand='yes')
	    self.buttons[label] = btn
	    maxWidth = max(maxWidth, len(label))

	self.maxWidth = maxWidth
	for button in self.buttons.values():
	    button['width'] = maxWidth

    ##################################################################
    # Initialize a new instance.
    # The optional arguments should each be lists or tuples
    # specifying the label and (optionally) command for each button
    # to be added to the frame.
    ##################################################################
    def __init__(self, master, *args):
	self.master = master
	f = self.frame = Tk.Frame(master, relief='raised', bd=1)

	self.buttons = {}
	self.maxWidth = 6
	self._addButtons(args)
	Tk.Pack.config(f, side='bottom', fill='x')

    ##################################################################
    # Add buttons to self.
    # The optional arguments should each be lists or tuples
    # specifying the label and (optionally) command for each button
    # to be added to the frame.
    ##################################################################
    def addButtons(self, *args):
	self._addButtons(args)


######################################################################
# Main function for unit testing.
######################################################################
def main():
    return

if __name__ == "__main__":
    main()
