from Tkinter import *

class Dialog(Frame):
	def createWidgets(self):
		# This dialog box pops up when showDialog is called.
		# In this case it is called by a button press.
		# Note that self.dialog is never packed.
		self.dialog = tixExFileSelectDialog()
		# Because of the way this "mega-widget" is layed out, 
		# 'ok' is not a subwidget of the tixExFileSelectDialog.
		# It is a subwidget of 'fsbox' which is a subwidget
		# of the tixExFileSelectDialog. Therefore, instead of 
		# just saying:
		#  self.dialog.ok = self.dialog.tixSubwidget(self, 'ok')
		# one must first get access to the 'fsbox' subwidget,
		# and then the 'ok' subwidget.
		# Get access to the 'fsbox' subwidget.
		self.dialog.box = self.dialog.tixSubwidget(self, 'fsbox')
		# Get access to the 'ok' subwidget of the 'fsbox' widget.
		self.dialog.box.ok = self.dialog.box.tixSubwidget(self,'ok')
		# When the user clicks 'ok', hide the dialog.
		self.dialog.box.ok["command"] = self.hideDialog
		# Make a button box.
		self.buttons = tixButtonBox()
		# Add two buttons
		# Note that these are not packed.
		self.buttons.add('browse',{"text":"Pick a File...",
					   "command":self.showDialog})
		self.buttons.add('quit',{"text":"Quit","command":self.quit})
		# Pack the button box.
		
		self.buttons.pack()
	def showDialog(self):
		self.dialog.popup()
	def hideDialog(self):
		self.dialog.popdown()
	def __init__(self, master=None):
		Frame.__init__(self, master)
		Pack.config(self)
		self.createWidgets()

test = Dialog()
test.mainloop()

