#
#

import time
import whrandom

from Tkinter import *

class gArea:
	 # create the visual area
	 def __init__(self,height=300,width=400):
		 self.tk = tk = Tk()
		 self.canvas = c = Canvas(self.tk)
		 c['height'] = height
		 c['width'] = width
		 c.pack()
		 self.width, self.height = tk.getint(c['width']), tk.getint(c['height'])

# create one for everybody
area = gArea(500,500)

def debug(str):
	pass

def bals(val):
	if val == 0:
		return "(0)"
	elif val == -1:
		return "(-)"
	elif val == 1:
		return "(+)"
	else:
		return "(X%dX)" % (val)

def bindex(num):
	 rstr = "%4.4d " % num
	 str = " "
	 while num:
		 if num & 1:
			 str = "1" + str
		 else:
			 str = "0" + str
		 num = num >> 1
	 return rstr + str

class gNode:
	 # Create a graphic node, centered at x,y, on "drawable"
	 def __init__(self,drawable,x,y,color='red'):

		 self.area = drawable
		 self.x = x
		 self.y = y

		 delta = self.area.height/40

		 x1,x2 = x-delta,x+delta
		 y1,y2 = y-delta,y+delta

		 self.blob = self.area.canvas.create_oval(x1,y1,x2,y2,{'fill':color})
		 self.area.tk.update()

	 def __del__(self):
		 global area
		 self.area.canvas.delete(self.blob)
		 self.area.tk.update()

	 def up(self):
		 self.area.canvas.move(self.blob,0,-1)
		 self.area.tk.update()

	 def down(self):
		 self.area.canvas.move(self.blob,0,1)
		 self.area.tk.update()

	 def right(self):
		 self.area.canvas.move(self.blob,1,0)
		 self.area.tk.update()

	 def left(self):
		 self.area.canvas.move(self.blob,-1,0)
		 self.area.tk.update()

	 def moveto(self,x,y):
		 xdelta = x - self.x
		 ydelta = y - self.y
		 self.area.canvas.move(self.blob,xdelta,ydelta)
		 self.area.tk.update()

	 def setcolor(self,color):
		 self.area.canvas.itemconfig(self.blob,{'fill':color})
		 self.area.tk.update()

class Node:

	 def __init__(self,value):
		 self.key = value
		 self.llink = None
		 self.rlink = None
		 self.b = 0
		 self.blob = None
		 self.color = 'red'

	 def __del__(self):
		 if self.blob:
			 del(self.blob)

	 def __cmp__(self,other):
		 x = self.key - other.key

		 #o = other.get_color()
		 #time.sleep(.1)
		 #other.set_color('black')
		 #other.set_color(o)

		 if x < 0:
			 return -1
		 if x > 0:
			 return 1
		 return 0
	 
	 def __nonzero__(self):
		 if self.key:
			 return 1
		 else:
			 return 0

	 def set_color(self,color):
		 if self.color != color:
			 self.color = color
			 self.blob.setcolor(color)

	 def get_color(self):
		 return self.color

	 def makered(self):
		 self.set_color('red')

	 def makeblue(self):
		 self.set_color('blue')

	 def draw(self,index):
		 global area
		 x,y = self.mapAsBinaryNode(index)
		 self.blob = gNode(area,x*area.width,y*area.height,self.color)

	 def move(self,newindex):
		 global area
		 x,y = self.mapAsBinaryNode(newindex)
		 self.blob.moveto(x*area.width,y.are.height)

	 def mapAsBinaryNode(self,index):
		 #
		 # index defines the position in the binary tree in
		 # the obvious way:
		 #           1
		 #      10       11
		 #   100  101 110  111
		 #
		 # generate x,y from the index...
		 exp = 0
		 ix = index
		 while ix > 1:
			 exp = exp + 1
			 ix = ix >> 1
		 
		 m = index & ~(1<<exp)

		 # exp is the "depth" of this node
		 y =  (exp+1.0)/10

		 x = 1.0/(1<<(exp+1)) + m*1.0/(1<<exp)

		 debug("index: %d -> exp: %d m: %d -> (%g,%g)" % (index,exp,m,x,y))

		 # x,y are in 1.0 normalized form
		 return x,y


class Tree:
	 def __init__(self):
		 self.nodelist = []
		 self.visiting = None

		 self.head = Node(0)
		 # self.head.rlink points to the tree
		 # self.head.key is unused
		 # self.head.llink is depth of tree

		 self.head.llink = 0
		 self.head.key = 8888


	 # Algorithm A from Knuth V3
	 def insert(self,value):
		 #
		 # p will move down the tree, s will point to the place
		 # where rebalancing will may b necessary, and t always 
		 # points to the parent of s
		 #
		 # q is a variable used in the walk-down-the-tree loop
		 #

		 new = Node(value)

		 # the first item is special cased...
		 if self.head.rlink == None:
			 self.head.rlink = new
			 self.head.llink = 1
			 #new.draw(1)
			 debug("inserting %d" % (value))
			 return 0

		 index = 1
		 t = self.head
		 s = p = self.head.rlink

		 while 1:
			 if new == p: #A2
				 # value already in tree - success
				 # debug("value %d already in tree" % (value))
				 return 0
			 elif new < p:
				 if p.llink == None: #A3
					 # debug("inserting %d as llink of %d" % (value,p.key))
					 q = p.llink = new # A5
					 #new.draw(index)
					 break
				 else:
					 q = p.llink
					 index = (index <<1)
			 elif new > p:
				 if p.rlink == None: #A4
					 # debug("inserting %d as rlink of %d" % (value,p.key))
					 q = p.rlink = new # A5
					 #new.draw(index)
					 break
				 else:
					 q = p.rlink
					 index = (index <<1)+1

			 # see if this node might need balancing...
			 if q.b:
				 t = p
				 s = q
			 # go do it again...
			 p = q
			 # debug("index: %s" % (bindex(index)))

#		 debug("t: %d%s s: %d%s p: %d%s q: %d%s" % (t.key,bals(t.b),s.key,bals(s.b),p.key,bals(p.b),q.key,bals(q.b)))

		 # A6 adjust balance factors
		 # We've already inserted the new node - time to balance
		 if new < s:
			 r = p = s.llink
		 else:
			 r = p = s.rlink

		 while p != q:
			 if new < p:
				 p.b = -1
				 p = p.llink
			 if new > p:
				 p.b = 1
				 p = p.rlink

		 #A7 balancing act
		 if new < s:
			 a = -1
		 else:
			 a = 1

		 if s.b == 0:
			 # the tree has gotten deeper
			 # debug("deeper (s.key = %d)" % (s.key))
			 s.b = a
			 self.head.llink = self.head.llink + 1
			 return 1
		 elif s.b == -a:
			 # the tree has gotten *more* balanced
			 # debug("better (s.key = %d)" % (s.key))
			 s.b = 0
			 return 1
		 elif s.b == a:
			 # the tree is out of balance
			 if r.b == a:
				 p = self.rotate_single(r,s,a)
			 elif r.b == -a:
				 p = self.rotate_double(r,s,a)
			 else:
				 # debug("should not happen!")
				 return -1
		 else:
			 # debug("should not happen #2")
			 return -1


		 # A10
		 if s == t.rlink:
			 t.rlink = p
		 else:
			 t.llink = p

		 # finished ...
		 return 1

	 # A8
	 def rotate_single(self,r,s,a):
		 # debug("rotate_single(%d,%d,%d)" % (r.key,s.key,a))
		 p = r
		 if a == -1:
			 s.llink = r.rlink
			 r.rlink = s
		 else:
			 s.rlink = r.llink
			 r.llink = s
		 s.b = r.b = 0
		 return p

	 # A9
	 def rotate_double(self,r,s,a):
		 # debug("rotate_double(%d,%d,%d)" % (r.key,s.key,a))
		 if a == -1:
			 p = r.rlink
			 r.rlink = p.llink
			 p.llink = r
			 s.llink = p.rlink
			 p.rlink = s
		 else:
			 p = r.llink
			 r.llink = p.rlink
			 p.rlink = r
			 s.rlink = p.llink
			 p.llink = s

		 if p.b == a:
			 s.b,r.b = -a,0
		 elif p.b == 0:
			 s.b,r.b = 0,0
		 else:
			 s.b,r.b = 0,a

		 p.b = 0
		 return p
	 
	 def visit(self,node):
		 if self.visiting:
			 self.visiting.makered()
		 self.visiting = node # might be None
		 if self.visiting:
			 self.visiting.makeblue()

	 def traverse(self):
		 self.nodelist=[]
		 self.preorder(self.head.rlink,1)
		 
	 def inorder(self,node,index):
		 if node.llink:
			 self.inorder(node.llink,2*index)
		 self.nodelist.append((node,index))
		 if node.rlink:
			 self.inorder(node.rlink,2*index+1)

	 def preorder(self,node,index):
		 self.nodelist.append((node,index))
		 if node.llink:
			 self.preorder(node.llink,2*index)
		 if node.rlink:
			 self.preorder(node.rlink,2*index+1)

	 def postorder(self,node,index):
		 if node.llink:
			 self.postorder(node.llink,2*index)
		 if node.rlink:
			 self.postorder(node.rlink,2*index+1)
		 self.nodelist.append((node,index))

	 def draw(self):
		 self.traverse()
		 for node,index in self.nodelist:
			 node.draw(index)

def test_tree(count):

	 tree = Tree()

	 for x in range(count):
		 val = int(whrandom.random()*1000)%100
		 tree.insert(val)
		 tree.draw()

	 tree.draw()

	 for node,index in tree.nodelist:
		 tree.visit(node)
		 #time.sleep(.25)

def test_nodes(area,count):
	list = {}
	for ix in range(count):
		list[ix] = Node(ix)
		list[ix].drawAsBinaryNodeOn(ix,area)

	for ix in range(count):
		del(list[ix])


def random_init():
	import os
	seeda = (int(time.time()%10)*100)%256
	# something to take a little time
	x = os.system("dir > nul")
	seedb = (int(time.time()%10)*100)%256
	whrandom.seed(seeda,seedb,0)

if __name__ == '__main__':
	random_init()
	for i in range(1):
		test_tree(30)








