/* -*- C -*- ***********************************************
Copyright 1991, 1992, 1993, 1994 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/


#include <stdio.h>
#include <string.h>


#include "allobjects.h"


/* Table of built-in modules.
   These are initialized when first imported.
   Note: selection of optional extensions is now generally done by the
   makesetup script. */
extern void initarray();
extern void initmath();
extern void initparser();
extern void initnt();
extern void initregex();
/* extern void initsocket(); - sockets are in their own DLL */
extern void initstrop();
extern void initstruct();
extern void inittime();
extern void initthread();
extern void initfcntl();
extern void initmd5();
extern void initrotor();

/* -- ADDMODULE MARKER 1 -- */

extern void initmarshal();
extern void initimp();

struct {
	char *name;
	void (*initfunc)();
} inittab[] = {

	{"array", initarray},
	{"math", initmath},
	{"parser", initparser}, 
	{"nt", initnt},
	{"regex", initregex},
/*	{"socket", initsocket},	- in its own DLL! */
	{"strop", initstrop},
	{"struct", initstruct},
	{"time", inittime},
	{"thread",initthread},
	{"md5", initmd5},
	{"rotor", initrotor},

/* -- ADDMODULE MARKER 2 -- */

	/* This module "lives in" with marshal.c */
	{"marshal", initmarshal},

	/* from import.c */
	{"imp",initimp},

	/* These entries are here for sys.builtin_module_names */
	{"__main__", NULL},
	{"__builtin__", NULL},
	{"sys", NULL},

	/* Sentinel */
	{0, 0}
};


#ifdef USE_FROZEN
#include "frozen.c"
#else
struct frozen {
	char *name;
	char *code;
	int size;
} frozen_modules[] = {
	{0, 0, 0}
};
#endif


