#! /usr/local/bin/python

import rivet

import filedlg

class Application:
    def __init__(self, parent):
        self.__widget = rivet.frame(parent)

        self.button = rivet.button(self.__widget,
		{'text': 'Load File...', 'command': self.Press})
        self.button.pack({"side": "top"})
        self.__widget.pack()

    def Press(self):
        fileDlg = filedlg.LoadFileDialog(self.__widget, "Load", "*")
        if fileDlg.Show() != 1:
            fileDlg.DialogCleanup()
            return
        fname = fileDlg.GetFileName()
        self.button.configure({'text': 'File: ' + fname})
        fileDlg.DialogCleanup()
    
root = rivet.init()
app = Application (root)
rivet.mainloop ()


