####
#	Class Dialog
#
#	Purpose
#	Base class for many dialog box classes.
####

import rivet, rivetutil

class Dialog:
	def __init__(self, master):
		self.master = master
		self.top = rivet.toplevel(self.master)
		rivet.wm.title(self.top, self.__class__.__name__)
		rivet.wm.minsize(self.top, 1, 1)
		self.myWaitVar = rivetutil.intvar()
                self.myWaitVar.set(0)

	def Show(self):
		self.SetupDialog()
		self.CenterDialog()
		rivet.wm.deiconify(self.top)
		rivet.focus(self.top)

	def TerminateDialog(self, withValue):
		self.myWaitVar.set(withValue)
		rivet.wm.withdraw(self.top)
		
	def DialogCleanup(self):
		rivet.destroy(self.top)
		rivet.focus(self.master)

	def SetupDialog(self): 
		pass

	def CenterDialog(self):
		rivet.wm.withdraw(self.top)
		rivet.update("idletasks")
		w = rivet.winfo.screenwidth(self.top)
		h = rivet.winfo.screenheight(self.top)
		reqw = rivet.winfo.reqwidth(self.top)
		reqh = rivet.winfo.reqheight(self.top)
		centerx = `(w-reqw)/2`
		centery = `(h-reqh)/2 - 100`
		geomStr = "+" + centerx + "+" + centery
		#rivet.winfo.geometry(self.top, geomStr)

	def title(self, new_title):
		rivet.wm.title(self.top, new_title)

####
#	Class ModalDialog
#
#	Purpose
#	Base class for many modal dialog box classes.
####

class ModalDialog(Dialog):

	def __init__(self, master):
		Dialog.__init__(self, master)

	def Show(self):
		import string
		self.SetupDialog()
		self.CenterDialog()
		rivet.grab.set(self.top)
		rivet.focus(self.top)
		rivet.wm.deiconify(self.top)
		rivet.tkwait.variable(self.myWaitVar)
		return self.myWaitVar.get()




