//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: vmodule.cpp
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "vmodule.h"


//======================>>> pytCmdWindow::pytCmdWindow <<<====================
pytCmdWindow::pytCmdWindow(char* name, 
	int width, int height, 
	PyObject *objKeyIn, 
	PyObject *objMenuCommand, 
	PyObject *objWindowCommand

#ifdef V_VersionWindows
       ,PyObject *objWin_Msg_Process
#endif
	): vCmdWindow(name, height, width)
{

    ASSIGN_PTR_OF_OBJECT_OR_NULL(objKeyIn,         vCmdWindow_cb_KeyIn);
    ASSIGN_PTR_OF_OBJECT_OR_NULL(objMenuCommand,   vCmdWindow_cb_MenuCommand);
    ASSIGN_PTR_OF_OBJECT_OR_NULL(objWindowCommand, vCmdWindow_cb_WindowCommand);

#ifdef V_VersionWindows
    ASSIGN_PTR_OF_OBJECT_OR_NULL(objWin_Msg_Process, vCmdWindow_cb_PYV_Win_Msg_Process);
#endif

    Py_XINCREF(vCmdWindow_cb_KeyIn         );
    Py_XINCREF(vCmdWindow_cb_MenuCommand   );
    Py_XINCREF(vCmdWindow_cb_WindowCommand );

#ifdef V_VersionWindows
    Py_XINCREF(vCmdWindow_cb_PYV_Win_Msg_Process );
#endif
}

//=====================>>> pytCmdWindow::~pytCmdWindow <<<====================
pytCmdWindow::~pytCmdWindow()
{
    Py_XDECREF(vCmdWindow_cb_KeyIn         );
    Py_XDECREF(vCmdWindow_cb_MenuCommand   );
    Py_XDECREF(vCmdWindow_cb_WindowCommand );

#ifdef V_VersionWindows
    Py_XDECREF(vCmdWindow_cb_PYV_Win_Msg_Process );
#endif
}


//========================>>> pytCmdWindow::KeyIn <<<=======================
  void pytCmdWindow::KeyIn(vKey keysym, unsigned int shift)
{
    PyObject *arglist;
    PyObject *result;

    if(vCmdWindow_cb_KeyIn != NULL)
    {
	arglist = Py_BuildValue("(ii)", keysym, shift);
	result  = PyEval_CallObject(vCmdWindow_cb_KeyIn, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
    }
}



#ifdef V_VersionWindows
#ifndef DONT_WANT_PYV_Win_Msg_Process
//====================>>> pytCmdWindow::PYV_Win_Msg_Process <<<===================
  int pytCmdWindow::PYV_Win_Msg_Process(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
  {
    PyObject *arglist;
    PyObject *result;
    int stat;

    if(vCmdWindow_cb_PYV_Win_Msg_Process!= NULL)
    {
	PyObject *objType;
	char *st;
	arglist = Py_BuildValue("(iiii)", hWnd, message, wParam, lParam);
	result  = PyEval_CallObject(vCmdWindow_cb_PYV_Win_Msg_Process, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);

	objType=PyObject_Type(result);
	st=(char *)PyObject_Str(objType);

	PyArg_Parse(result, "i", &stat);
	if(stat==1)
	{
	    // Message has been processed by Python call-back func.
	    return 1;
	}
	else 
	{
	    // Message is not for us.
	    return 0;
	}
    }

    // We are out of business
    return 0;    // Yes, Yes !!! 0 - we skip this message.
}
#endif
#endif


//====================>>> pytCmdWindow::WindowCommand <<<===================
  void pytCmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)
  {
    PyObject *arglist;
    PyObject *result;

    if(vCmdWindow_cb_WindowCommand!= NULL)
    {
	arglist = Py_BuildValue("(iii)", id, val, cType);
	result  = PyEval_CallObject(vCmdWindow_cb_WindowCommand, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
    }
}




//====================>>> pytCmdWindow::MenuCommand <<<===================
  void pytCmdWindow::MenuCommand(ItemVal itemId )
  {
    PyObject *arglist;
    PyObject *result;

    if(vCmdWindow_cb_MenuCommand!= NULL)
    {
	arglist = Py_BuildValue("(i)", itemId);
	result  = PyEval_CallObject(vCmdWindow_cb_MenuCommand, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
    }
}






//  -------------------------- vWindow ----------------------------

typedef unsigned long *Py_vWindowObject;


 PyObject * 
Py_vApp_AppCommand(PyObject* self, PyObject* args)
{
	vWindow *pWin;	
	ItemVal id, val;
	CmdType cType;
        if (!PyArg_ParseTuple(args, "liii",&pWin, &id, &val, &cType))
	   return NULL;
	theApp->AppCommand(pWin, id, val, cType);
        return Py_BuildValue("l", (PyObject *) pWin);
}


PyObject * 
Py_vApp_NewAppWin(PyObject* self, PyObject* args)
{
	vWindow  *pNewWin, *pWin;	
	int h, w;
	char *pName;
	vAppWinInfo* winInfo;
        if (!PyArg_ParseTuple(args, "lsiil",&pWin, &pName, &w, &h, &winInfo))
	   return NULL;
	pNewWin=theApp->NewAppWin(pWin, pName, w, h, winInfo);
        return Py_BuildValue("l", (PyObject *) pNewWin);
}

PyObject * 
Py_vApp_CloseAppWin(PyObject* self, PyObject* args)
{
	vWindow *pWin;

	if (!PyArg_Parse(args, "l", &pWin))
	   return NULL;
	theApp->CloseAppWin(pWin);

 	Py_INCREF (Py_None);
        return Py_BuildValue("l", (PyObject *) Py_None);
}

PyObject * 
Py_vApp_Exit(PyObject* self, PyObject* args)
{
    theApp->Exit();
    
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vApp_KeyIn(PyObject* self, PyObject* args)
{
    vWindow *pWin;
    vKey    key;
    unsigned int shift;
    
    if (!PyArg_ParseTuple(args, "lii",&pWin, &key, &shift))
	return NULL;
    theApp->KeyIn(pWin, key, shift);
    
    Py_INCREF (Py_None);
    return Py_None;
}


static PyObject *vApp_cb_AppCommand =NULL;
static PyObject *vApp_cb_CloseAppWin=NULL;
static PyObject *vApp_cb_Exit       =NULL;
static PyObject *vApp_cb_KeyIn      =NULL;





PyObject * 
Py_vApp_Constructor(PyObject* self, PyObject* args)
{
PyObject *objAppCommand, *objCloseAppWin, *objExit, *objKeyIn;


   if (!PyArg_ParseTuple(args, "OOOO",
			 &objAppCommand,
			 &objCloseAppWin,
			 &objExit,
			 &objKeyIn))
       return NULL;

   ASSIGN_PTR_OF_OBJECT_OR_NULL(objAppCommand,  vApp_cb_AppCommand  );
   ASSIGN_PTR_OF_OBJECT_OR_NULL(objCloseAppWin, vApp_cb_CloseAppWin );
   ASSIGN_PTR_OF_OBJECT_OR_NULL(objExit,        vApp_cb_Exit        );
   ASSIGN_PTR_OF_OBJECT_OR_NULL(objKeyIn,       vApp_cb_KeyIn       );

   Py_XINCREF(vApp_cb_AppCommand  );
   Py_XINCREF(vApp_cb_CloseAppWin );
   Py_XINCREF(vApp_cb_Exit        );
   Py_XINCREF(vApp_cb_KeyIn       );

   return Py_BuildValue("l", (PyObject *) theApp);
}



PyObject * 
Py_vApp_CheckEvents(PyObject* self, PyObject* args)
{
    theApp->CheckEvents();
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vApp_DefaultHeight(PyObject* self, PyObject* args)
{
    return Py_BuildValue("l", (PyObject *) theApp->DefaultHeight());
}

PyObject * 
Py_vApp_DefaultWidth(PyObject* self, PyObject* args)
{
    return Py_BuildValue("l", (PyObject *) theApp->DefaultWidth());
}


PyObject * 
Py_vApp_GetDefaultFont(PyObject* self, PyObject* args)
{
    vFont *pFont;
    pFont=new vFont();
    *pFont=theApp->GetDefaultFont();
    return Py_BuildValue("l", (PyObject *) pFont);
}

PyObject * 
Py_vApp_GetVVersion(PyObject* self, PyObject* args)
{
    int Major, Minor;
    theApp->GetVVersion(Major, Minor);
    return Py_BuildValue("(ii)",  Major, Minor);
}

PyObject * 
Py_vApp_SendWindowCommandAll(PyObject* self, PyObject* args)
{
    int id, val;
    CmdType ctype;
    if (!PyArg_Parse(args, "(iii)",&id, &val, &ctype))
	return NULL;
    theApp->SendWindowCommandAll(id, val, ctype);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vApp_IsRunning(PyObject* self, PyObject* args)
{
    return Py_BuildValue("i", theApp->IsRunning());
}

PyObject * 
Py_vApp_ScreenHeight(PyObject* self, PyObject* args)
{
#ifdef V_VersionX
    return Py_BuildValue("i", theApp->ScreenHeight());
#else
    Py_INCREF (Py_None);
    return Py_None;
#endif
}

PyObject * 
Py_vApp_ScreenWidth(PyObject* self, PyObject* args)
{
#ifdef V_VersionX
    return Py_BuildValue("i", theApp->ScreenWidth());
#else
    Py_INCREF (Py_None);
    return Py_None;
#endif
}


PyObject * 
Py_vApp_SetAppTitle(PyObject* self, PyObject* args)
{
    char *str, *title;
    
    if (!PyArg_Parse(args, "s",
		     &str
		     ))
	return NULL;
    
    title = new char[strlen(str)+1];
    strcpy(title,str);
    theApp->SetAppTitle(title);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vApp_SetValueAll(PyObject* self, PyObject* args)
{
    ItemVal Id, Val;
    ItemSetType type;
    
    if (!PyArg_ParseTuple(args, "iii",
			  &Id,
			  &Val,
			  &type
			  ))
	return NULL;
    theApp->SetValueAll(Id, Val, type);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vApp_SetStringAll(PyObject* self, PyObject* args)
{
    ItemVal Id;
    char *str;

    if (!PyArg_ParseTuple(args, "is",
			  &Id,
			  &str
			  ))
	return NULL;
    theApp->SetStringAll(Id, str);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vApp_ShowList(PyObject* self, PyObject* args)
{
	return Py_BuildValue("i", theApp->ShowList());
}




static PyObject *vCmdWindow_cb_KeyIn         =NULL;
static PyObject *vCmdWindow_cb_MenuCommand   =NULL;
static PyObject *vCmdWindow_cb_WindowCommand =NULL;


PyObject * 
Py_vCmdWindow_Constructor(PyObject* self, PyObject* args)
{
    PyObject *objKeyIn, *objMenuCommand, *objWindowCommand;
    char *pName;
    int height,width;
    vWindow* thisWin;
    PyObject *objWin_Msg_Process;

    if (!PyArg_ParseTuple(args,
 			  "OOOOsii",
			  &objWin_Msg_Process,
			  &objKeyIn,
			  &objMenuCommand,
			  &objWindowCommand,
			  &pName,
			  &width,
			  &height))
	return NULL;
    thisWin = new pytCmdWindow(pName, 
				width, 
				height, 
				objKeyIn, 
				objMenuCommand, 
				objWindowCommand 
#ifdef V_VersionWindows
       				,objWin_Msg_Process
#endif
				);

    return Py_BuildValue("l", thisWin);
}

PyObject * 
Py_vCmdWindow_Destructor(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    if (!PyArg_Parse(args, "l",
			  &thisWin
			  ))
	return NULL;
    delete thisWin;
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vCmdWindow_AddPane(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    vPane *pane;

    if (!PyArg_Parse(args, "(ll)", &thisWin, &pane))
	return NULL;
    thisWin->AddPane(pane);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vCmdWindow_GetPosition(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    int left, top, width, height;
    if (!PyArg_Parse(args, "l", &thisWin))
	return NULL;
    thisWin->GetPosition(left, top, width, height);
    return Py_BuildValue("(iiii)", left, top, width, height);
}

PyObject * 
Py_vCmdWindow_GetValue(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    int itemId, val;
    if (!PyArg_Parse(args, "(li)", &thisWin, &itemId))
	return NULL;
    val=thisWin->GetValue(itemId);
    return Py_BuildValue("i", val);
}

PyObject * 
Py_vCmdWindow_RaiseWindow(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    if (!PyArg_Parse(args, "l", &thisWin))
	return NULL;
    thisWin->RaiseWindow();
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vCmdWindow_SetValue(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    ItemVal Id, Val;
    ItemSetType type;
    
    if (!PyArg_ParseTuple(args, "liii",
			  &thisWin,
			  &Id,
			  &Val,
			  &type
			  ))
	return NULL;
    thisWin->SetValue(Id, Val, type);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vCmdWindow_SetValueAll(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    ItemVal Id, Val;
    ItemSetType type;
    
    if (!PyArg_ParseTuple(args, "liii",
			  &thisWin,
			  &Id,
			  &Val,
			  &type
			  ))
	return NULL;
    thisWin->SetValueAll(Id, Val, type);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vCmdWindow_SetPosition(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    int left, top;

    if (!PyArg_ParseTuple(args, "lii",
			  &thisWin,
			  &left,
			  &top
			  ))
	return NULL;
    thisWin->SetPosition(left, top);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vCmdWindow_SetString(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    ItemVal Id;
    char *pTitle;
    
    if (!PyArg_ParseTuple(args, "lis",
			  &thisWin,
			  &Id,
			  &pTitle
			  ))
	return NULL;
    thisWin->SetString(Id, pTitle);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vCmdWindow_SetStringAll(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    ItemVal Id;
    char *pStrng;
    
    if (!PyArg_ParseTuple(args, "lis",
			  &thisWin,
			  &Id,
			  &pStrng
			  ))
	return NULL;
    thisWin->SetString(Id, pStrng);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vCmdWindow_SetTitle(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    char *pTitle;
    
    if (!PyArg_ParseTuple(args, "ls",
			  &thisWin,
			  &pTitle
			  ))
	return NULL;
    thisWin->SetTitle(pTitle);
    Py_INCREF (Py_None);
    return Py_None;
}





PyObject * 
Py_vCmdWindow_ShowPane(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    vPane *wpane;
    int OnOrOff;
    if (!PyArg_Parse(args, "lli", &thisWin, &wpane, &OnOrOff))
	return NULL;
    thisWin->ShowPane(wpane, OnOrOff);
    Py_INCREF (Py_None);
    return Py_None;
}





PyObject * 
Py_vCmdWindow_ShowWindow(PyObject* self, PyObject* args)
{
    vWindow* thisWin;
    if (!PyArg_Parse(args, "l", &thisWin))
	return NULL;
    thisWin->ShowWindow();
    Py_INCREF (Py_None);
    return Py_None;
}





// #define Sofin_Debug
#ifdef Sofin_Debug
void PrtTree(int ident, vMenu *pMenu)
{
    vMenu *ptr;
    char buf[80];
    int i;
    for(i=0;i<ident;i++) { buf[i]=' '; buf[i+1]=0; }
    for (ptr=pMenu;ptr->label != NULL;ptr++)
    {
	if(ptr->label == NULL) break;
	printf("%s 0x%08x 0x%08x  %15s %05d %05d %05d %05d %05d %05d \n",buf,
	       ptr,
	       ptr->SubMenu,
	       ptr->label,
	       ptr->menuId,
	       ptr->sensitive, 
	       ptr->checked, 
	       ptr->keyLabel,
	       ptr->accel, 
	       ptr->kShift); 
	if(ptr->SubMenu!=NULL)
	    PrtTree(ident+8, (vMenu *) ptr->SubMenu);
   }
}
#endif


static char *MenuListProc(vMenu* pMenu, PyObject* objList)
{
    PyObject *objTmp, *objType, *objStr;
    int sizeOfList, i;
    char *pType, *pStr, *pBuf;
    int szBytes;
    vMenu *pMem;


#define PROCESS_ITEM( vMenu_item, Casting_Type, nmbr )      \
                                                            \
	objTmp=PyList_GetItem(objList,nmbr);                \
	Py_INCREF(objTmp);                                  \
	objType=PyObject_Type ( objTmp  );                  \
	objStr=PyObject_Str( objType  );                    \
	pType=PyString_AsString(objStr);                    \
	if(strcmp(pType,"<type 'int'>")!=0)                 \
	    Py_v_FATAL_ERR(                         \
             "\nMenuListProc: <type 'int'> -- missing\n");  \
        vMenu_item= Casting_Type PyInt_AsLong(objTmp);      \
	Py_DECREF(objTmp);                                  \
	Py_DECREF(objType);                                 \
	Py_DECREF(objStr);



    sizeOfList=PyList_Size(objList);
    if(pMenu==NULL)
    {
	szBytes=sizeof(vMenu)*(sizeOfList+1);
	pMem=(vMenu *)malloc(szBytes);
	if(pMem==NULL)  
	    Py_v_FATAL_ERR("\nMenuListProc: malloc error.\n");

	for(i=0; i< sizeOfList; i++)
	{
	    objTmp=PyList_GetItem(objList,i);
	    Py_INCREF(objTmp);
	    objType=PyObject_Type ( objTmp  );
	    objStr=PyObject_Str( objType  );

	    pType=PyString_AsString(objStr);

	    if(strcmp(pType,"<type 'list'>")!=0)
		Py_v_FATAL_ERR("\nMenuListProc: should to be the list type\n");

	    MenuListProc((pMem+i), objTmp);

	    Py_DECREF(objTmp); 
	    Py_DECREF(objType); 
	    Py_DECREF(objStr);

	}
	(pMem+sizeOfList)->label=NULL;
	return( (char *) pMem);
    }
    else 
    {
	objTmp=PyList_GetItem(objList,0);
	Py_INCREF(objTmp);
	objType=PyObject_Type ( objTmp  );
	objStr=PyObject_Str( objType  );
	pType=PyString_AsString(objStr);
	if(strcmp(pType,"<type 'string'>")!=0)
	    Py_v_FATAL_ERR("\nMenuListProc: <type 'string'> -- missing\n");
	pStr=PyString_AsString(objTmp);
	pBuf=(char *)malloc(strlen(pStr)+4);
	if(pBuf==NULL)
	    Py_v_FATAL_ERR("\nMenuListProc: pStrmalloc error.\n");
	
	strcpy(pBuf,pStr);
	pMenu->label = pBuf;

	Py_DECREF(objTmp); 
	Py_DECREF(objType); 
	Py_DECREF(objStr);



	PROCESS_ITEM( pMenu->menuId,         (ItemVal),       1  );
	PROCESS_ITEM( pMenu->sensitive,      (unsigned),      2  );
	PROCESS_ITEM( pMenu->checked,        (unsigned),      3  );
	PROCESS_ITEM( pMenu->keyLabel,       (char *),        4  );
	PROCESS_ITEM( pMenu->accel,          (vKey),          5  );

	objTmp=PyList_GetItem(objList,6);
	Py_INCREF(objTmp);    
	objType=PyObject_Type ( objTmp  ); 
	objStr=PyObject_Str( objType  );   
	pType=PyString_AsString(objStr);
	if(strcmp(pType,"<type 'int'>")==0)
	{
	    pMenu->SubMenu=(vMenu*)PyInt_AsLong(objTmp);
	}
	else 
	{
	    if(strcmp(pType,"<type 'list'>")!=0)
		Py_v_FATAL_ERR("\nMenuListProc: type not list of int\n");

	    pMenu->SubMenu=(vMenu*)MenuListProc( NULL, objTmp);
	}
	Py_DECREF(objTmp);
	Py_DECREF(objType);
	Py_DECREF(objStr);

	pMenu->kShift=0;   // I didn't invest time to understand how to use it.

	return(NULL);
    }
}

PyObject * 
Py_vCommandPane_Constructor(PyObject* self, PyObject* args)
{
    PyObject *objList;
    vCommandPane* pCommandPane;
    CommandObject *pCmdObject;
    if (!PyArg_Parse(args, "O", &objList))
	return NULL;
    pCmdObject=ProcessCommandObject(objList);
    pCommandPane = new vCommandPane(pCmdObject);
    return Py_BuildValue("l", pCommandPane);
}



PyObject * 
Py_vCommandPane_GetTextIn(PyObject* self, PyObject* args)
{
    vCommandPane* pCommandPane;
    ItemVal Id;
    char Str[255];
    if (!PyArg_ParseTuple(args, "li", &pCommandPane, &Id ))
	return NULL;
    pCommandPane->GetTextIn(Id, &Str[0], 255);
    return Py_BuildValue("s", Str);
}





PyObject * 
Py_vMenuPane_Constructor(PyObject* self, PyObject* args)
{
	PyObject *objMenu;
	vMenuPane* pMenuPane;
	vMenu *pMenu;
	if (!PyArg_Parse(args, "O", &objMenu))
	   return NULL;
	pMenu=(vMenu*)MenuListProc(0,objMenu);

#ifdef Sofin_Debug
	PrtTree(10, pMenu);
#endif

	pMenuPane = new vMenuPane(pMenu);
	return Py_BuildValue("i", pMenuPane);
}


PyObject * 
Py_vStatus_Constructor(PyObject* self, PyObject* args)
{
    PyObject *objStatus, *objTmp, *objType, *objList, *objStr;
    vStatusPane* pStatusPane;
    vStatus *pStatus;
    char *pType, *pStr,  *pBuf;
    int szBytes, i, sizeOfList;
    vStatus  *ptr;


#define PROCESS_STATUS_ITEM( v_item, Casting_Type, nmbr )     \
                                                              \
    objTmp=PyList_GetItem(objStatus,nmbr);                    \
    Py_INCREF(objTmp);                                        \
    objType=PyObject_Type ( objTmp  );                        \
    objStr=PyObject_Str( objType  );                          \
    pType=PyString_AsString(objStr);                          \
    if(strcmp(pType,"<type 'int'>")!=0)                       \
    Py_v_FATAL_ERR(                                   \
    "\nPy_vStatus_Constructor: <type 'int'> -- missing\n");      \
    v_item= Casting_Type PyInt_AsLong(objTmp);                \
    Py_DECREF(objTmp);                                        \
    Py_DECREF(objType);                                       \
    Py_DECREF(objStr);

    if (!PyArg_Parse(args, "O", &objList))
	return NULL;

    sizeOfList=PyList_Size(objList);
    szBytes=sizeof(vStatus)*(sizeOfList+1);
    pStatus=(vStatus *)malloc(szBytes);
    if(pStatus == NULL)
	Py_v_FATAL_ERR("\nPy_vStatus_Constructor: malloc error\n");
    
    for(i=0; i<sizeOfList; i++)
    {
	objStatus=PyList_GetItem(objList,i);
	Py_INCREF(objStatus);

	ptr=pStatus+i;
	objTmp=PyList_GetItem(objStatus,0);
	Py_INCREF(objTmp);
	objType=PyObject_Type ( objTmp  );
	objStr=PyObject_Str( objType  );
	pType=PyString_AsString(objStr);
	if(strcmp(pType,"<type 'string'>")!=0)
	    Py_v_FATAL_ERR("\nvStatus_Constructor: <type 'string'> -- missing\n");
	pStr=PyString_AsString(objTmp);
	pBuf=(char *)malloc(strlen(pStr)+2);
	if(pBuf==NULL)
	    Py_v_FATAL_ERR("\nvStatus_Constructor: pStrmalloc error.\n");
	
	strcpy(pBuf,pStr);
	Py_DECREF(objTmp);
	Py_DECREF(objType);
	Py_DECREF(objStr);

	ptr->label = pBuf;
	
	PROCESS_STATUS_ITEM(ptr->statId,     (ItemVal),       1  ); 
	PROCESS_STATUS_ITEM(ptr->attrs,      (CmdAttribute),  2  ); 
	PROCESS_STATUS_ITEM(ptr->sensitive,  (unsigned),      3  );
	PROCESS_STATUS_ITEM(ptr->width,      (int),           4  );
	
	Py_DECREF(objStatus);
    }

    (pStatus+sizeOfList)->label    = NULL;
    (pStatus+sizeOfList)->statId   = 0;
    (pStatus+sizeOfList)->attrs    = 0;
    (pStatus+sizeOfList)->sensitive= 0;
    (pStatus+sizeOfList)->width    = 0;


    pStatusPane = new vStatusPane(pStatus);
    return Py_BuildValue("l", pStatusPane);
}



//===========================>>> pytApp::Exit <<<=========================
void pytApp::Exit(void)
{
PyObject *arglist;
PyObject *result;

     if(vApp_cb_Exit != NULL)
     {
//	arglist = Py_BuildValue("(O)", (PyObject *) Py_None);
	arglist=Py_None;
	result= PyEval_CallObject(vApp_cb_Exit, (PyObject *) NULL);
	CHECK_RETURN_RESULT ( result );

     }
	
 vApp::Exit();       // easy default behavior
}

//======================>>> pytApp::CloseAppWin <<<=======================
void pytApp::CloseAppWin(vWindow* win)
{
    PyObject *arglist;
    PyObject *result;

    if(vApp_cb_CloseAppWin != NULL)
    {
	arglist = Py_BuildValue("(l)", win);
	result  = PyEval_CallObject(vApp_cb_CloseAppWin, arglist);
	CHECK_RETURN_RESULT ( result );

    	vApp::CloseAppWin(win);   // Unregister and close the window.
	Py_DECREF(arglist);
    }
	
    vApp::CloseAppWin(win);   // Unregister and close the window.
}
//=====================>>> pytApp::AppCommand <<<=========================
  void pytApp::AppCommand(vWindow* win, ItemVal id, ItemVal val,
    CmdType cType)
  {
    PyObject *arglist;
    PyObject *result;
    if(vApp_cb_AppCommand != NULL)
    {
	arglist = Py_BuildValue("(liii)", win, id, val, cType);
	result  = PyEval_CallObject(vApp_cb_AppCommand, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
    }
    else
	vApp::AppCommand(win, id, val, cType);
  }
//=======================>>> pytApp::KeyIn <<<============================
  void pytApp::KeyIn(vWindow* win, vKey key, unsigned int shift)
  {
    PyObject *arglist;
    PyObject *result;
    if(vApp_cb_KeyIn != NULL)
    {
	arglist = Py_BuildValue("(lii)", win, key, shift);
	result  = PyEval_CallObject(vApp_cb_KeyIn, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
    }
    else
    	vApp::KeyIn(win, key, shift);
  }

//=========================>>> pytApp::NewAppWin <<<======================
vWindow* pytApp::NewAppWin(vWindow* win, char* name, int w, int h, 
			   vAppWinInfo* winInfo)
{
    vWindow* thisWin = win;             // local copy to use
    vAppWinInfo* awinfo = winInfo;

    
//    if (!awinfo)        // Did caller provide an appinfo?
//        awinfo = new vAppWinInfo(myname);
    
    
    return vApp::NewAppWin(thisWin,name,w,h,awinfo);
}



//=========================>>> Py_vApp_doEventLoop <<<======================

PyObject * 
Py_vApp_doEventLoop(PyObject* self, PyObject* args)
{
    theApp->doEventLoop();

    Py_INCREF (Py_None);
    return Py_None;
}

