//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvw95.cpp
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvw95.h"



PyObject * 
Py_v_W95_WSAAsyncSelect(PyObject* self, PyObject* args)
{
   vWindow *pWin;
   SOCKET  s;
   HWND hWnd;
   u_int wMsg;
   long lEvent;
   int stat;


   if (!PyArg_ParseTuple(args, "llll", 
				&s, 
				&pWin,
				&wMsg,
				&lEvent
				))
       return NULL;

   hWnd=pWin->winHwnd();

// Levent== FD_READ | FD_WRITE | FD_OOB | FD_ACCEPT | FD_CONNECT | FD_CLOSE
//   FD_READ	Want to receive notification of readiness for reading
//   FD_WRITE	Want to receive notification of readiness for writing
//   FD_OOB	Want to receive notification of the arrival of out-of-band data
//   FD_ACCEPT	Want to receive notification of incoming connections
//   FD_CONNECT	Want to receive notification of completed connection
//   FD_CLOSE	Want to receive notification of socket closure
   lEvent= FD_READ | FD_WRITE | FD_OOB | FD_ACCEPT | FD_CONNECT | FD_CLOSE;

   stat=WSAAsyncSelect(s, hWnd, wMsg, lEvent);

   if(stat!=0)
	stat=WSAGetLastError();

   return Py_BuildValue("i", (PyObject *) stat);
}


PyObject * 
Py_v_W95_WSAGetLastError(PyObject* self, PyObject* args)
{
   return Py_BuildValue("i", (PyObject *) WSAGetLastError());
}

PyObject * 
Py_v_W95_GetLastError(PyObject* self, PyObject* args)
{
   return Py_BuildValue("i", (PyObject *) GetLastError());
}





PyObject * 
Py_v_W95_MoveWindow(PyObject* self, PyObject* args)
{
   vWindow *pWin;
   HWND hWnd;
   int X, Y, nWidth, nHeight, bRepaint, stat;


   if (!PyArg_ParseTuple(args, "liiiii",
				&pWin,
				&X,
				&Y,
				&nWidth,
				&nHeight,
				&bRepaint
				))
       return NULL;

   hWnd=pWin->winHwnd();

   stat=MoveWindow(hWnd, X, Y, nWidth, nHeight, bRepaint);

   return Py_BuildValue("i", (PyObject *) stat);
}


PyObject * 
Py_v_W95_SendMessage(PyObject* self, PyObject* args)
{
   vWindow *pWin;
   HWND hWnd;
   UINT Msg;
   WPARAM wParam;
   LPARAM lParam;
   LRESULT res;


   if (!PyArg_ParseTuple(args, "liii",
				&pWin,
				&Msg,
				&wParam,
				&lParam
				))
       return NULL;

   hWnd=pWin->winHwnd();

   res=SendMessage(hWnd, Msg, wParam, lParam);

   return Py_BuildValue("i", (PyObject *) res);
}
