//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvpen.cc 
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================


#include "pyvpen.h"

PyObject *
Py_vPen_Constructor(PyObject* self, PyObject* args)
{
    vPen *pPen;
    unsigned int r, g, b;
    int width, style;

    if (!PyArg_ParseTuple(args, "iiiii",
			  &r,
			  &g,
			  &b,
			  &width,
			  &style
			  ))
	return NULL;

    pPen= new vPen(r, g, b, width, style);

    return Py_BuildValue("l", (PyObject *) pPen);
}
    

PyObject *
Py_vPen_Destructor(PyObject* self, PyObject* args)
{
    vPen *pPen;
    if (!PyArg_Parse(args, "l",
		     &pPen
		     ))
	return NULL;
    delete pPen;
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject *
Py_vPen_GetColor(PyObject* self, PyObject* args)
{
    vPen *pPen;
    vColor *pColor;
    if (!PyArg_Parse(args, "l",
		     &pPen
		     ))
	return NULL;
    pColor=new vColor();
    *pColor=pPen->GetColor();
    return Py_BuildValue("l", (PyObject *) pColor);
}

PyObject *
Py_vPen_GetStyle(PyObject* self, PyObject* args)
{
    vPen *pPen;
    if (!PyArg_Parse(args, "l",
		     &pPen
		     ))
	return NULL;
    return Py_BuildValue("i", pPen->GetStyle());
}

PyObject *
Py_vPen_GetWidth(PyObject* self, PyObject* args)
{
    vPen *pPen;
    if (!PyArg_Parse(args, "l",
		     &pPen
		     ))
	return NULL;
    return Py_BuildValue("i", pPen->GetWidth());
}



PyObject *
Py_vPen_SetColor(PyObject* self, PyObject* args)
{
    vPen *pPen;
    vColor *pColor;
    if (!PyArg_ParseTuple(args, "ll",
			  &pPen,
			  &pColor
			  ))
	return NULL;
    pPen->SetColor(*pColor);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject *
Py_vPen_SetStyle(PyObject* self, PyObject* args)
{
    vPen *pPen;
    int style;
    if (!PyArg_ParseTuple(args, "li",
			  &pPen,
			  &style
			  ))
	return NULL;
    pPen->SetStyle(style);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject *
Py_vPen_SetWidth(PyObject* self, PyObject* args)
{
    vPen *pPen;
    int width;
    if (!PyArg_ParseTuple(args, "li",
			  &pPen,
			  &width
			  ))
	return NULL;
    pPen->SetWidth(width);
    Py_INCREF (Py_None);
    return Py_None;
}

