//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvmodlg.cpp
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================


#include "pyvmodlg.h"

//=========================>>> pytModal::~pytModal <<<======================
  pytModal::~pytModal()
  {
    Py_XDECREF( vModal_cb_DialogCommand );
  }


//==========================>>> pytModal::pytModal <<<======================
  pytModal::pytModal(vBaseWindow* bw, PyObject *cb_DialogCommand) :
    vModalDialog(bw)
  {
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_DialogCommand, vModal_cb_DialogCommand  );
    Py_XINCREF( vModal_cb_DialogCommand );
  }


//====================>>> pytModal::DialogCommand <<<======================
void pytModal::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
{
    PyObject *arglist;
    PyObject *result;


    if(vModal_cb_DialogCommand==NULL)
	return;

	arglist = Py_BuildValue("(iii)", id, retval, ctype);
	result  = PyEval_CallObject(vModal_cb_DialogCommand, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
}

//======================================================================
//======================================================================
//======================================================================


PyObject * 
Py_vModal_Constructor(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    vBaseWindow* win;
    PyObject *cb_DialogCommand;
    if (!PyArg_ParseTuple(args, "iO",
			  &win,
			  &cb_DialogCommand
			  ))
	return NULL;
    thisModal = new pytModal(win, cb_DialogCommand);
    return Py_BuildValue("l", thisModal);
}


PyObject * 
Py_vModal_Destructor(PyObject* self, PyObject* args)
{
    pytModal* thisModal;

    if (!PyArg_Parse(args, "l",
			  &thisModal
			  ))
	return NULL;
    delete thisModal;
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vModal_AddDialogCmds(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    PyObject *objList;
    CommandObject *pCmdObject;

    if (!PyArg_ParseTuple(args, "lO",
			  &thisModal,
			  &objList
			  ))
	return NULL;

    pCmdObject=ProcessCommandObject(objList);

    thisModal->AddDialogCmds(pCmdObject);

    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vModal_SetDialogTitle(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    char *pTitle;
    if (!PyArg_ParseTuple(args, "ls",
			  &thisModal,
			  &pTitle
			  ))
	return NULL;
    thisModal->SetDialogTitle(pTitle);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vModal_CancelDialog(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    if (!PyArg_Parse(args, "l",
			  &thisModal
			  ))
	return NULL;
    thisModal->CancelDialog();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vModal_CloseDialog(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    if (!PyArg_Parse(args, "l",
			  &thisModal
			  ))
	return NULL;
    thisModal->CloseDialog();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vModal_GetDialogPosition(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    ItemVal Id;
    int left, top, width, height;

    if (!PyArg_Parse(args, "l",
			  &thisModal
			  ))
	return NULL;
    thisModal->GetDialogPosition(left, top, width, height);
    return Py_BuildValue("(iiii)", left, top, width, height);
}



PyObject * 
Py_vModal_GetTextIn(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    ItemVal Id;
    char *pBuf;
    PyObject *arglist;

#define MAX_BUFFER_LEN_GetTextIn    100

    if (!PyArg_ParseTuple(args, "li",
			  &thisModal,
			  &Id
			  ))
	return NULL;
    pBuf=(char *)malloc(MAX_BUFFER_LEN_GetTextIn);

    if(pBuf==NULL)
	        Py_v_FATAL_ERR("\nPy_vModal_GetTextIn: pCmdObject malloc error.\n");

    thisModal->GetTextIn(Id, pBuf, MAX_BUFFER_LEN_GetTextIn);
    arglist = Py_BuildValue("s", pBuf);
    free(pBuf);
    return arglist;
}



PyObject * 
Py_vModal_GetValue(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    ItemVal Id;
    int res;

    if (!PyArg_ParseTuple(args, "li",
			  &thisModal,
			  &Id
			  ))
	return NULL;
    res=thisModal->GetValue(Id);
    return Py_BuildValue("l", res);
}



PyObject * 
Py_vModal_IsDisplayed(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    ItemVal Id;
    int res;

    if (!PyArg_Parse(args, "l",
			  &thisModal
			  ))
	return NULL;
    res=thisModal->IsDisplayed();
    return Py_BuildValue("i", res);
}


PyObject * 
Py_vModal_SetDialogPosition(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    ItemVal Id;
    int left, top;

    if (!PyArg_ParseTuple(args, "lii",
			  &thisModal,
			  &left, 
			  &top
			  ))
	return NULL;
    thisModal->SetDialogPosition(left, top);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vModal_SetValue(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    ItemVal Id, Val;
    ItemSetType type;

    if (!PyArg_ParseTuple(args, "liii",
			  &thisModal,
			  &Id,
			  &Val,
			  &type
			  ))
	return NULL;
    thisModal->SetValue(Id, Val, type);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vModal_SetString(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    ItemVal Id;
    char *str;

    if (!PyArg_ParseTuple(args, "lis",
			  &thisModal,
			  &Id,
			  &str
			  ))
	return NULL;
    thisModal->SetString(Id, str);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vModal_ShowDialog(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    char *msg;

    if (!PyArg_ParseTuple(args, "ls",
			  &thisModal,
			  &msg
			  ))
	return NULL;
    thisModal->ShowDialog(msg);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vModal_ShowModalDialog(PyObject* self, PyObject* args)
{
    pytModal* thisModal;
    char *msg;
    ItemVal id, retval;

    if (!PyArg_ParseTuple(args, "ls",
			  &thisModal,
			  &msg
			  ))
	return NULL;
    id=thisModal->ShowModalDialog(msg, retval);

    return Py_BuildValue("iiii", id, retval);
}



