//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvmisc.cc
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvmisc.h"

static char pyv_version_date[]=PYV_VERSION_DATE;

PyObject * 
Py_v_Version(PyObject* self, PyObject* args)
{
    
    return Py_BuildValue("(iiss)", 
			 PYV_VERSION_BASE, 
			 PYV_VERSION_OFFSET,
			 PYV_VERSION_DATE,
			 PYV_COMPILED_BY
			);
}


void FatalErrorProcessing(char *str, char *FileName, int Line)
{
    printf(
	   "\n Filename         : %s\n Line             : %d\n Version          : %d.%d\n Compilation Date : %s\n Message          : %s",
	    FileName,
	    Line,
	    PYV_VERSION_BASE, 
	    PYV_VERSION_OFFSET, 
	    PYV_VERSION_DATE,
	    str);

    theApp->Exit();
}


void AssignPtrOfObjectOrNull(PyObject* obj, PyObject*& ptr)
{
    PyObject *objType, *objStr;
    char *pType;

    objType=PyObject_Type ( obj );
    objStr=PyObject_Str( objType  );

    pType=PyString_AsString(objStr);
    if(strcmp(pType,"<type 'None'>")==0)
	ptr = (PyObject *)NULL;
    else 
        ptr = (PyObject *) obj;
    Py_DECREF(objType);
    Py_DECREF(objStr);

}



static PyMethodDef Py_vApp_Methods[] = {
        {"v_Version",                      (PyCFunction) Py_v_Version},
	{"vApp_Constructor",               (PyCFunction) Py_vApp_Constructor},

	{"vApp_doEventLoop",               (PyCFunction) Py_vApp_doEventLoop},
	{"vApp_AppCommand",                (PyCFunction) Py_vApp_AppCommand},
	{"vApp_CloseAppWin",               (PyCFunction) Py_vApp_CloseAppWin},
	{"vApp_Exit",                      (PyCFunction) Py_vApp_Exit},
	{"vApp_KeyIn",                     (PyCFunction) Py_vApp_KeyIn},
	{"vApp_NewAppWin",                 (PyCFunction) Py_vApp_NewAppWin},

	{"vApp_CheckEvents",               (PyCFunction) Py_vApp_CheckEvents},
	{"vApp_DefaultHeight",             (PyCFunction) Py_vApp_DefaultHeight},
	{"vApp_DefaultWidth",              (PyCFunction) Py_vApp_DefaultWidth},
	{"vApp_GetDefaultFont",            (PyCFunction) Py_vApp_GetDefaultFont},
	{"vApp_GetVVersion",               (PyCFunction) Py_vApp_GetVVersion},
	{"vApp_IsRunning",                 (PyCFunction) Py_vApp_IsRunning},
	{"vApp_ScreenHeight",              (PyCFunction) Py_vApp_ScreenHeight},
	{"vApp_ScreenWidth",               (PyCFunction) Py_vApp_ScreenWidth},
	{"vApp_SendWindowCommandAll",      (PyCFunction) Py_vApp_SendWindowCommandAll},
	{"vApp_SetAppTitle",               (PyCFunction) Py_vApp_SetAppTitle},
	{"vApp_SetValueAll",               (PyCFunction) Py_vApp_SetValueAll},
	{"vApp_SetStringAll",              (PyCFunction) Py_vApp_SetStringAll},
	{"vApp_ShowList",                  (PyCFunction) Py_vApp_ShowList},


	{"vCmdWindow_Constructor",         (PyCFunction) Py_vCmdWindow_Constructor},
	{"vCmdWindow_Destructor",          (PyCFunction) Py_vCmdWindow_Destructor},
	{"vCmdWindow_GetPosition",         (PyCFunction) Py_vCmdWindow_GetPosition},
	{"vCmdWindow_GetValue",            (PyCFunction) Py_vCmdWindow_GetValue},
	{"vCmdWindow_RaiseWindow",         (PyCFunction) Py_vCmdWindow_RaiseWindow},
	{"vCmdWindow_AddPane",             (PyCFunction) Py_vCmdWindow_AddPane},
	{"vCmdWindow_GetPosition",         (PyCFunction) Py_vCmdWindow_GetPosition},
	{"vCmdWindow_GetValue",            (PyCFunction) Py_vCmdWindow_GetValue},
	{"vCmdWindow_RaiseWindow",         (PyCFunction) Py_vCmdWindow_RaiseWindow},
	{"vCmdWindow_SetValue",            (PyCFunction) Py_vCmdWindow_SetValue},
	{"vCmdWindow_SetValueAll",         (PyCFunction) Py_vCmdWindow_SetValueAll},
	{"vCmdWindow_SetPosition",         (PyCFunction) Py_vCmdWindow_SetPosition},
	{"vCmdWindow_SetString",           (PyCFunction) Py_vCmdWindow_SetString},
	{"vCmdWindow_SetStringAll",        (PyCFunction) Py_vCmdWindow_SetStringAll},
	{"vCmdWindow_SetTitle",            (PyCFunction) Py_vCmdWindow_SetTitle},
	{"vCmdWindow_ShowPane",            (PyCFunction) Py_vCmdWindow_ShowPane},
	{"vCmdWindow_ShowWindow",          (PyCFunction) Py_vCmdWindow_ShowWindow},


	{"vCommandPane_Constructor",       (PyCFunction) Py_vCommandPane_Constructor },
	{"vCommandPane_GetTextIn",         (PyCFunction) Py_vCommandPane_GetTextIn },


	{"vMenuPane_Constructor",          (PyCFunction) Py_vMenuPane_Constructor },
	{"vStatusPane_Constructor",        (PyCFunction) Py_vStatus_Constructor},


	{"vTextCanvasPane_Constructor",    (PyCFunction) Py_vTextCanvasPane_Constructor},
	{"vTextCanvasPane_ShowHScroll",    (PyCFunction) Py_vTextCanvasPane_ShowHScroll},
	{"vTextCanvasPane_ShowVScroll",    (PyCFunction) Py_vTextCanvasPane_ShowVScroll},
	{"vTextCanvasPane_Clear",          (PyCFunction) Py_vTextCanvasPane_Clear},
	{"vTextCanvasPane_ClearRow",       (PyCFunction) Py_vTextCanvasPane_ClearRow},
	{"vTextCanvasPane_ClearToEnd",     (PyCFunction) Py_vTextCanvasPane_ClearToEnd},
	{"vTextCanvasPane_GetCols",        (PyCFunction) Py_vTextCanvasPane_GetCols},
	{"vTextCanvasPane_GetRows",        (PyCFunction) Py_vTextCanvasPane_GetRows},
	{"vTextCanvasPane_GetRC",          (PyCFunction) Py_vTextCanvasPane_GetRC},
	{"vTextCanvasPane_GotoRC",         (PyCFunction) Py_vTextCanvasPane_GotoRC},
	{"vTextCanvasPane_DrawAttrText",   (PyCFunction) Py_vTextCanvasPane_DrawAttrText},
	{"vTextCanvasPane_DrawChar",       (PyCFunction) Py_vTextCanvasPane_DrawChar},
	{"vTextCanvasPane_DrawText",       (PyCFunction) Py_vTextCanvasPane_DrawText},
	{"vTextCanvasPane_HideTextCursor", (PyCFunction) Py_vTextCanvasPane_HideTextCursor},
	{"vTextCanvasPane_ShowTextCursor", (PyCFunction) Py_vTextCanvasPane_ShowTextCursor},
	{"vTextCanvasPane_ScrollText",     (PyCFunction) Py_vTextCanvasPane_ScrollText},
	{"vTextCanvasPane_ResizeText",     (PyCFunction) Py_vTextCanvasPane_ResizeText},
	{"vTextCanvasPane_SetHScroll",     (PyCFunction) Py_vTextCanvasPane_SetHScroll},
	{"vTextCanvasPane_SetVScroll",     (PyCFunction) Py_vTextCanvasPane_SetVScroll},
	{"vTextCanvasPane_Redraw",         (PyCFunction) Py_vTextCanvasPane_Redraw},

	{"vTimer_Constructor",             (PyCFunction) Py_vTimer_Constructor},
	{"vTimer_Destructor",              (PyCFunction) Py_vTimer_Destructor},
	{"vTimer_TimerSet",                (PyCFunction) Py_vTimer_TimerSet},
	{"vTimer_TimerStop",               (PyCFunction) Py_vTimer_TimerStop},

	{"vFileSelect",                    (PyCFunction) Py_vFileSelect},
	{"vFileSelectSave",                (PyCFunction) Py_vFileSelectSave},
	{"vFontSelect",                    (PyCFunction) Py_vFontSelect},
	{"vNoticeDialog",                  (PyCFunction) Py_vNoticeDialog},
	{"vReplyDialog",                   (PyCFunction) Py_vReplyDialog},
	{"vYNReplyDialog",                 (PyCFunction) Py_vYNReplyDialog},

	{"vDialog_Constructor",            (PyCFunction) Py_vDialog_Constructor},
	{"vDialog_Destructor",             (PyCFunction) Py_vDialog_Destructor},
	{"vDialog_AddDialogCmds",          (PyCFunction) Py_vDialog_AddDialogCmds},
	{"vDialog_SetDialogTitle",         (PyCFunction) Py_vDialog_SetDialogTitle},
	{"vDialog_CancelDialog",           (PyCFunction) Py_vDialog_CancelDialog},
	{"vDialog_CloseDialog",            (PyCFunction) Py_vDialog_CloseDialog},
	{"vDialog_GetDialogPosition",      (PyCFunction) Py_vDialog_GetDialogPosition},
	{"vDialog_GetTextIn",              (PyCFunction) Py_vDialog_GetTextIn},
	{"vDialog_GetValue",               (PyCFunction) Py_vDialog_GetValue},
	{"vDialog_IsDisplayed",            (PyCFunction) Py_vDialog_IsDisplayed},
	{"vDialog_SetDialogPosition",      (PyCFunction) Py_vDialog_SetDialogPosition},
	{"vDialog_SetValue",               (PyCFunction) Py_vDialog_SetValue},
	{"vDialog_SetString",              (PyCFunction) Py_vDialog_SetString},
	{"vDialog_ShowDialog",             (PyCFunction) Py_vDialog_ShowDialog},

	{"vModal_Constructor",             (PyCFunction) Py_vModal_Constructor},
	{"vModal_Destructor",              (PyCFunction) Py_vModal_Destructor},
	{"vModal_AddDialogCmds",           (PyCFunction) Py_vModal_AddDialogCmds},
	{"vModal_SetDialogTitle",          (PyCFunction) Py_vModal_SetDialogTitle},
	{"vModal_CancelDialog",            (PyCFunction) Py_vModal_CancelDialog},
	{"vModal_CloseDialog",             (PyCFunction) Py_vModal_CloseDialog},
	{"vModal_GetDialogPosition",       (PyCFunction) Py_vModal_GetDialogPosition},
	{"vModal_GetTextIn",               (PyCFunction) Py_vModal_GetTextIn},
	{"vModal_GetValue",                (PyCFunction) Py_vModal_GetValue},
	{"vModal_IsDisplayed",             (PyCFunction) Py_vModal_IsDisplayed},
	{"vModal_SetDialogPosition",       (PyCFunction) Py_vModal_SetDialogPosition},
	{"vModal_SetValue",                (PyCFunction) Py_vModal_SetValue},
	{"vModal_SetString",               (PyCFunction) Py_vModal_SetString},
	{"vModal_ShowDialog",              (PyCFunction) Py_vModal_ShowDialog},
	{"vModal_ShowModalDialog",         (PyCFunction) Py_vModal_ShowModalDialog},

	{"vIcon_Constructor",              (PyCFunction) Py_vIcon_Constructor},
	{"vIcon_Destructor",               (PyCFunction) Py_vIcon_Destructor},

	{"vFont_Constructor",              (PyCFunction) Py_vFont_Constructor},
	{"vFont_Destructor",               (PyCFunction) Py_vFont_Destructor},
	{"vFont_GetFamily",                (PyCFunction) Py_vFont_GetFamily},
	{"vFont_GetPointSize",             (PyCFunction) Py_vFont_GetPointSize},
	{"vFont_GetStyle",                 (PyCFunction) Py_vFont_GetStyle},
	{"vFont_GetWeight",                (PyCFunction) Py_vFont_GetWeight},
	{"vFont_GetUnderlined",            (PyCFunction) Py_vFont_GetUnderlined},
	{"vFont_SetFontValues",            (PyCFunction) Py_vFont_SetFontValues},


	{"vCanvasPane_Constructor",        (PyCFunction) Py_vCanvasPane_Constructor},
	{"vCanvasPane_ShowPane",           (PyCFunction) Py_vCanvasPane_ShowPane},
	{"vCanvasPane_SetWidthHeight",     (PyCFunction) Py_vCanvasPane_SetWidthHeight},
	{"vCanvasPane_SetCursor",          (PyCFunction) Py_vCanvasPane_SetCursor},
	{"vCanvasPane_GetCursor",          (PyCFunction) Py_vCanvasPane_GetCursor},
	{"vCanvasPane_UnSetCursor",        (PyCFunction) Py_vCanvasPane_UnSetCursor},
	{"vCanvasPane_SetHScroll",         (PyCFunction) Py_vCanvasPane_SetHScroll},
	{"vCanvasPane_SetVScroll",         (PyCFunction) Py_vCanvasPane_SetVScroll},
	{"vCanvasPane_GetHScroll",         (PyCFunction) Py_vCanvasPane_GetHScroll},
	{"vCanvasPane_GetVScroll",         (PyCFunction) Py_vCanvasPane_GetVScroll},
	{"vCanvasPane_ShowHScroll",        (PyCFunction) Py_vCanvasPane_ShowHScroll},
	{"vCanvasPane_ShowVScroll",        (PyCFunction) Py_vCanvasPane_ShowVScroll},
	{"vCanvasPane_GetWidth",           (PyCFunction) Py_vCanvasPane_GetWidth},
	{"vCanvasPane_GetHeight",          (PyCFunction) Py_vCanvasPane_GetHeight},
	{"vCanvasPane_GetDC",              (PyCFunction) Py_vCanvasPane_GetDC},

//
// ----------------------- DRAWING -----------------------
//

	{"vDC_Clear",                      (PyCFunction) Py_vDC_Clear},
	{"vDC_ClearRect",                  (PyCFunction) Py_vDC_ClearRect},
	{"vDC_CopyFromMemoryDC",           (PyCFunction) Py_vDC_CopyFromMemoryDC},

#ifdef DRAWARC   // This ifdef I found in vcanvas.h.   
//                 What is this ???
	{"vDC_DrawArc",                    (PyCFunction) Py_vDC_DrawArc},
#endif

        {"vDC_DrawAttrText",               (PyCFunction) Py_vDC_DrawAttrText},
	{"vDC_DrawText",                   (PyCFunction) Py_vDC_DrawText},
	{"vDC_DrawEllipse",                (PyCFunction) Py_vDC_DrawEllipse},
	{"vDC_DrawIcon",                   (PyCFunction) Py_vDC_DrawIcon},
	{"vDC_DrawLine",                   (PyCFunction) Py_vDC_DrawLine},
	{"vDC_DrawLines",                  (PyCFunction) Py_vDC_DrawLines},

	{"vDC_DrawPoint",                  (PyCFunction) Py_vDC_DrawPoint},
	{"vDC_DrawPoints",                 (PyCFunction) Py_vDC_DrawPoints},
	{"vDC_DrawPolygon",                (PyCFunction) Py_vDC_DrawPolygon},
	{"vDC_DrawRoundedRectangle",       (PyCFunction) Py_vDC_DrawRoundedRectangle},
	{"vDC_DrawRectangle",              (PyCFunction) Py_vDC_DrawRectangle},
	{"vDC_DrawRectangles",             (PyCFunction) Py_vDC_DrawRectangles},
	{"vDC_DrawRubberLine",             (PyCFunction) Py_vDC_DrawRubberLine},
	{"vDC_DrawRubberEllipse",          (PyCFunction) Py_vDC_DrawRubberEllipse},
	{"vDC_DrawRubberPoint",            (PyCFunction) Py_vDC_DrawRubberPoint},
	{"vDC_DrawRubberRectangle",        (PyCFunction) Py_vDC_DrawRubberRectangle},
	{"vDC_BeginPrinting",              (PyCFunction) Py_vDC_BeginPrinting},
	{"vDC_EndPrinting",                (PyCFunction) Py_vDC_EndPrinting},
	{"vDC_BeginPage",                  (PyCFunction) Py_vDC_BeginPage},
	{"vDC_EndPage",                    (PyCFunction) Py_vDC_EndPage},
	{"vDC_GetPhysHeight",              (PyCFunction) Py_vDC_GetPhysHeight},
	{"vDC_GetPhysWidth",               (PyCFunction) Py_vDC_GetPhysWidth},
	{"vDC_SetBackground",              (PyCFunction) Py_vDC_SetBackground},
	{"vDC_SetScale",                   (PyCFunction) Py_vDC_SetScale},
	{"vDC_GetScale",                   (PyCFunction) Py_vDC_GetScale},
	{"vDC_SetTranslate",               (PyCFunction) Py_vDC_SetTranslate},
	{"vDC_SetTransX",                  (PyCFunction) Py_vDC_SetTransX},
	{"vDC_SetTransY",                  (PyCFunction) Py_vDC_SetTransY},
	{"vDC_GetTranslate",               (PyCFunction) Py_vDC_GetTranslate},
	{"vDC_GetTransX",                  (PyCFunction) Py_vDC_GetTransX},
	{"vDC_GetTransY",                  (PyCFunction) Py_vDC_GetTransY},
	{"vDC_SetBrush",                   (PyCFunction) Py_vDC_SetBrush},
	{"vDC_GetBrush",                   (PyCFunction) Py_vDC_GetBrush},
	{"vDC_SetFont",                    (PyCFunction) Py_vDC_SetFont},
	{"vDC_GetFont",                    (PyCFunction) Py_vDC_GetFont},
	{"vDC_SetPen",                     (PyCFunction) Py_vDC_SetPen},
	{"vDC_GetPen",                     (PyCFunction) Py_vDC_GetPen},
	{"vDC_SetPrinter",                 (PyCFunction) Py_vDC_SetPrinter},
	{"vDC_TextHeight",                 (PyCFunction) Py_vDC_TextHeight},
	{"vDC_TextWidth",                  (PyCFunction) Py_vDC_TextWidth},

	{"vMemoryDC_Constructor",          (PyCFunction) Py_vMemoryDC_Constructor},
	{"vMemoryDC_Destructor",           (PyCFunction) Py_vMemoryDC_Destructor},

	{"vPrintDC_Constructor",          (PyCFunction) Py_vPrintDC_Constructor},
	{"vPrintDC_Destructor",           (PyCFunction) Py_vPrintDC_Destructor},

	{"vPrinter_Constructor",          (PyCFunction) Py_vPrinter_Constructor},
	{"vPrinter_Destructor",           (PyCFunction) Py_vPrinter_Destructor},
	{"vPrinter_Setup",                (PyCFunction) Py_vPrinter_Setup},


	{"vBrush_Constructor",             (PyCFunction) Py_vBrush_Constructor},
	{"vBrush_Destructor",              (PyCFunction) Py_vBrush_Destructor},
	{"vBrush_GetColor",                (PyCFunction) Py_vBrush_GetColor},
	{"vBrush_GetFillMode",             (PyCFunction) Py_vBrush_GetFillMode},
	{"vBrush_GetStyle",                (PyCFunction) Py_vBrush_GetStyle},
	{"vBrush_SetColor",                (PyCFunction) Py_vBrush_SetColor},
	{"vBrush_SetFillMode",             (PyCFunction) Py_vBrush_SetFillMode},
	{"vBrush_SetStyle",                (PyCFunction) Py_vBrush_SetStyle},

	{"vColor_Constructor",             (PyCFunction) Py_vColor_Constructor},
	{"vColor_Destructor",              (PyCFunction) Py_vColor_Destructor},
	{"vColor_BitsOfColor",             (PyCFunction) Py_vColor_BitsOfColor},
	{"vColor_ResetColor",              (PyCFunction) Py_vColor_ResetColor},
	{"vColor_Set",                     (PyCFunction) Py_vColor_Set},
	{"vColor_SetR",                    (PyCFunction) Py_vColor_SetR},
	{"vColor_SetG",                    (PyCFunction) Py_vColor_SetG},
	{"vColor_SetB",                    (PyCFunction) Py_vColor_SetB},
	{"vColor_r",                       (PyCFunction) Py_vColor_r},
	{"vColor_g",                       (PyCFunction) Py_vColor_g},
	{"vColor_b",                       (PyCFunction) Py_vColor_b},

	{"vPen_Constructor",               (PyCFunction) Py_vPen_Constructor},
	{"vPen_Destructor",                (PyCFunction) Py_vPen_Destructor},
	{"vPen_GetColor",                  (PyCFunction) Py_vPen_GetColor},
	{"vPen_GetStyle",                  (PyCFunction) Py_vPen_GetStyle},
	{"vPen_GetWidth",                  (PyCFunction) Py_vPen_GetWidth},
	{"vPen_SetColor",                  (PyCFunction) Py_vPen_SetColor},
	{"vPen_SetStyle",                  (PyCFunction) Py_vPen_SetStyle},
	{"vPen_SetWidth",                  (PyCFunction) Py_vPen_SetWidth},

	{"vTextEditor_Constructor",        (PyCFunction) Py_vTextEditor_Constructor },
	{"vTextEditor_Destructor",         (PyCFunction) Py_vTextEditor_Destructor },
	{"vTextEditor_resetBuff",          (PyCFunction) Py_vTextEditor_resetBuff },
	{"vTextEditor_addLine",            (PyCFunction) Py_vTextEditor_addLine },
	{"vTextEditor_getFirstLine",       (PyCFunction) Py_vTextEditor_getFirstLine },
	{"vTextEditor_getNextLine",        (PyCFunction) Py_vTextEditor_getNextLine },
	{"vTextEditor_getLine",            (PyCFunction) Py_vTextEditor_getLine },
	{"vTextEditor_displayBuff",        (PyCFunction) Py_vTextEditor_displayBuff },
	{"vTextEditor_EditCommand",        (PyCFunction) Py_vTextEditor_EditCommand },
	{"vTextEditor_EditKeyIn",          (PyCFunction) Py_vTextEditor_EditKeyIn },


	{"vDebugDialog_Constructor",       (PyCFunction) Py_vDebugDialog_Constructor },
	{"vDebugDialog_Destructor",        (PyCFunction) Py_vDebugDialog_Destructor },
	{"vDebugDialog_SetDebug",          (PyCFunction) Py_vDebugDialog_SetDebug },
	{"vDebugDialog_DialogCommand",     (PyCFunction) Py_vDebugDialog_DialogCommand },



	{"pyvTraceFileOpen",               (PyCFunction) Py_pyvTraceFileOpen  },
	{"pyvTraceFileClose",              (PyCFunction) Py_pyvTraceFileClose },
	{"pyvTraceFileFlush",              (PyCFunction) Py_pyvTraceFileFlush },
	{"pyvTraceFileFlushMode",          (PyCFunction) Py_pyvTraceFileFlushMode },

	{"pyvTrace_Display",               (PyCFunction) Py_pyvTrace_Display},


#ifdef V_VersionX
	{"vApp_appContext",                (PyCFunction) Py_vApp_appContext},
	{"vApp_display",                   (PyCFunction) Py_vApp_display},

	{"pyv_X11_XtAppAddInput",          (PyCFunction) Py_v_XtAppAddInput},
	{"pyv_X11_XtRemoveInput",          (PyCFunction) Py_v_XtRemoveInput},
#endif


#ifdef V_VersionWindows
	{"pyv_W95_WSAAsyncSelect",         (PyCFunction) Py_v_W95_WSAAsyncSelect},
	{"pyv_W95_WSAGetLastError",        (PyCFunction) Py_v_W95_WSAGetLastError},

	{"pyv_W95_GetLastError",           (PyCFunction) Py_v_W95_GetLastError},
	{"pyv_W95_MoveWindow",             (PyCFunction) Py_v_W95_MoveWindow},
	{"pyv_W95_SendMessage",            (PyCFunction) Py_v_W95_SendMessage},

#endif


        {NULL,                  NULL}           /* sentinel */
};




extern "C" void
initv()
{
    PyObject *m, *d, *x;

#define AddConst2Dict( Const )               \
  x = Py_BuildValue ("i", Const);            \
  PyDict_SetItemString (d, #Const, x)
   
    /* Create the module and add the functions */
    m = Py_InitModule("v", Py_vApp_Methods);

    /* Add some symbolic constants to the module */
    d = PyModule_GetDict(m);

	AddConst2Dict( C_EndOfList      );
	AddConst2Dict( C_ArrowButton    );
	AddConst2Dict( C_Blank          );
	AddConst2Dict( C_BoxedLabel     );
	AddConst2Dict( C_Button         );
	AddConst2Dict( C_CheckBox       );
	AddConst2Dict( C_ColorButton    );
	AddConst2Dict( C_ColorLabel     );
	AddConst2Dict( C_Custom         );
	AddConst2Dict( C_ComboBox       );
	AddConst2Dict( C_Frame          );
	AddConst2Dict( C_Icon           );
	AddConst2Dict( C_IconButton     );
	AddConst2Dict( C_Label          );
	AddConst2Dict( C_List           );
	AddConst2Dict( C_Menu           );
	AddConst2Dict( C_ProgressBar    );
	AddConst2Dict( C_RadioButton    );
	AddConst2Dict( C_Slider         );
	AddConst2Dict( C_Spinner        );
	AddConst2Dict( C_TextIn         );
	AddConst2Dict( C_Text           );
	AddConst2Dict( C_ToggleButton   );
	AddConst2Dict( C_ToggleFrame    );
	AddConst2Dict( C_ToggleIconButton );
	AddConst2Dict( C_ZZZ            );

    // How Items can be set
	AddConst2Dict( WINDOW           );
	AddConst2Dict( CMDWINDOW        );
	AddConst2Dict( DIALOG           );

    // How Items can be set
	AddConst2Dict( Checked          );
	AddConst2Dict( Sensitive        );
	AddConst2Dict( Value            );
	AddConst2Dict( Hidden           );
	AddConst2Dict( ChangeList       );
	AddConst2Dict( ChangeListPtr    );
	AddConst2Dict( Red              );
	AddConst2Dict( Green            );
	AddConst2Dict( Blue             );
	AddConst2Dict( ChangeColor      );
#ifdef V_VersionX
	AddConst2Dict( SetToFirst       );   // BUG --- ???
#endif


    // Kinds of Panes
	AddConst2Dict( P_Canvas         );
	AddConst2Dict( P_TextCanvas     );
	AddConst2Dict( P_Menu           );
	AddConst2Dict( P_Commands       );
	AddConst2Dict( P_Icons          );
	AddConst2Dict( P_Buttons        );
	AddConst2Dict( P_Status         );

	AddConst2Dict( CA_None          );
	AddConst2Dict( CA_MainMsg       );
	AddConst2Dict( CA_DefaultButton );
	AddConst2Dict( CA_Large         );
	AddConst2Dict( CA_Small         );
	AddConst2Dict( CA_Hidden        );
	AddConst2Dict( CA_Horizontal    );
	AddConst2Dict( CA_Vertical      );
	AddConst2Dict( CA_NoNotify      );
	AddConst2Dict( CA_NoLabel       );
	AddConst2Dict( CA_Simple        );
	AddConst2Dict( CA_Text          );
	AddConst2Dict( CA_NoBorder      );
	AddConst2Dict( CA_NoSpace       );
#ifdef V_VersionX
	AddConst2Dict( CA_Multi         );  // BUG -- ??
#endif
	AddConst2Dict( CA_PerControl    );
	AddConst2Dict( CA_Percent       );



    // symbols for defining menus
	AddConst2Dict( noKey           );
	AddConst2Dict( noKeyLbl        );
	AddConst2Dict( isSens          );
	AddConst2Dict( notSens         );
	AddConst2Dict( isChk           );
	AddConst2Dict( notChk          );
	AddConst2Dict( noSub           );
	AddConst2Dict( notUsed         );
	AddConst2Dict( noIcon          );

    // standard menu definitions
	AddConst2Dict( M_File    );
	AddConst2Dict( M_Edit    );
	AddConst2Dict( M_Search  );
	AddConst2Dict( M_Help    );
	AddConst2Dict( M_Window  );
	AddConst2Dict( M_Options );
	AddConst2Dict( M_Tools   );
	AddConst2Dict( M_Font    );
	AddConst2Dict( M_View    );
	AddConst2Dict( M_Format  );
	AddConst2Dict( M_Insert  );
	AddConst2Dict( M_Test    );

	AddConst2Dict( M_Line    );

	AddConst2Dict( M_New     );
	AddConst2Dict( M_Open    );
	AddConst2Dict( M_Close   );
	AddConst2Dict( M_Save    );
	AddConst2Dict( M_SaveAs  );
	AddConst2Dict( M_Print   );
	AddConst2Dict( M_PrintPreview );
	AddConst2Dict( M_About   );
	AddConst2Dict( M_Exit    );

	AddConst2Dict( M_Cut     );
	AddConst2Dict( M_Copy    );
	AddConst2Dict( M_Paste   );
	AddConst2Dict( M_Delete  );
	AddConst2Dict( M_Clear   );

	AddConst2Dict( M_UnDo    );
	AddConst2Dict( M_SetDebug );

	AddConst2Dict( M_Find    );
	AddConst2Dict( M_FindAgain );
	AddConst2Dict( M_Replace );

	AddConst2Dict( M_Preferences );
	AddConst2Dict( M_FontSelect );

	AddConst2Dict( M_Cancel  );
	AddConst2Dict( M_Done    );
	AddConst2Dict( M_OK      );
	AddConst2Dict( M_Yes     );
	AddConst2Dict( M_No      );
	AddConst2Dict( M_All     );
	AddConst2Dict( M_None    );

// Definitions for drawing

	AddConst2Dict( vSolid             );
	AddConst2Dict( vTransparent       );
	AddConst2Dict( vHorizontalHatch   );
	AddConst2Dict( vVerticleHatch     );
	AddConst2Dict( vVerticalHatch     );
	AddConst2Dict( vLeftDiagonalHatch );
	AddConst2Dict( vRightDiagonalHatch);
	AddConst2Dict( vCrossHatch        );
	AddConst2Dict( vDiagonalCrossHatch);
	AddConst2Dict( vDash              );
	AddConst2Dict( vDot               );
	AddConst2Dict( vDashDot           );
	AddConst2Dict( vAlternate         );
	AddConst2Dict( vWinding           );



//  From file vdc.h
	AddConst2Dict( ChNormal  );
	AddConst2Dict( ChReverse );
	AddConst2Dict( ChDimColor);
	AddConst2Dict( ChRed     );
	AddConst2Dict( ChGreen   );
	AddConst2Dict( ChBlue    );
	AddConst2Dict( ChYellow  );
	AddConst2Dict( ChMagenta );
	AddConst2Dict( ChCyan    );
	AddConst2Dict( ChGray    );
	AddConst2Dict( ChWhite   );


// From file vkeys.h
#include "pyvkeys.h"


// Fonts Definitions. From file vfont.h

	AddConst2Dict( vfDefaultSystem   );
	AddConst2Dict( vfDefaultFixed  );
	AddConst2Dict( vfDefaultVariable  );
	AddConst2Dict( vfSerif  );
	AddConst2Dict( vfSansSerif  );
	AddConst2Dict( vfFixed  );
	AddConst2Dict( vfDecorative  );
	AddConst2Dict( vfOtherFont  );
	AddConst2Dict( vfNormal  );
	AddConst2Dict( vfBold  );
	AddConst2Dict( vfItalic  );


// Corsors definitions

    	AddConst2Dict( VC_None             );
  	AddConst2Dict( VC_Arrow            );
   	AddConst2Dict( VC_CenterArrow      );
   	AddConst2Dict( VC_CrossHair        );
  	AddConst2Dict( VC_EWArrows         );
  	AddConst2Dict( VC_Hand             );
  	AddConst2Dict( VC_IBar             );
  	AddConst2Dict( VC_Icon             );
  	AddConst2Dict( VC_NSArrows         );
  	AddConst2Dict( VC_Pencil           );
  	AddConst2Dict( VC_Question         );
  	AddConst2Dict( VC_Sizer            );
   	AddConst2Dict( VC_Wait             );
   	AddConst2Dict( VC_X                );



// Editor command definitions
   	AddConst2Dict( edVerify              );
   	AddConst2Dict( edFind                );
   	AddConst2Dict( edFindNext            );
   	AddConst2Dict( edBufferBottom        );
   	AddConst2Dict( edCharDelete          );
   	AddConst2Dict( edCharFoldCase        );
   	AddConst2Dict( edCharInsert          );
   	AddConst2Dict( edCharRight           );
   	AddConst2Dict( edLineBeginning       );
   	AddConst2Dict( edLineDown            );
   	AddConst2Dict( edLineDownBeg         );
   	AddConst2Dict( edLineDelete          );
   	AddConst2Dict( edLineDeleteFront     );
   	AddConst2Dict( edLineDeleteToEnd     );
   	AddConst2Dict( edLineEnd             );
   	AddConst2Dict( edLineGoto            );
   	AddConst2Dict( edLineOpen            );
   	AddConst2Dict( edWordRight           );
   	AddConst2Dict( edBalMatch            );
   	AddConst2Dict( edScrollDown          );
   	AddConst2Dict( edNoOp                );

#ifdef V_VersionWindows

// Definitions for WSAAsyncSelect Win95   File: winsock.h
//
   	AddConst2Dict(  FD_READ      );
   	AddConst2Dict(  FD_WRITE     );
   	AddConst2Dict(  FD_OOB       );
   	AddConst2Dict(  FD_ACCEPT    );
   	AddConst2Dict(  FD_CONNECT   );
   	AddConst2Dict(  FD_CLOSE     );

// from winuser.h    Win95
   	AddConst2Dict(  WM_USER      );
   	AddConst2Dict(  WSABASEERR    );
   	AddConst2Dict(  WSAEINTR     );
   	AddConst2Dict(  WSAEBADF     );
   	AddConst2Dict(  WSAEACCES    );
   	AddConst2Dict(  WSAEFAULT    );
   	AddConst2Dict(  WSAEINVAL    );
   	AddConst2Dict(  WSAEMFILE    );
   	AddConst2Dict(  WSAEWOULDBLOCK         );
   	AddConst2Dict(  WSAEINPROGRESS         );
   	AddConst2Dict(  WSAEALREADY            );
   	AddConst2Dict(  WSAENOTSOCK            );
   	AddConst2Dict(  WSAEDESTADDRREQ        );
   	AddConst2Dict(  WSAEMSGSIZE            );
   	AddConst2Dict(  WSAEPROTOTYPE          );
   	AddConst2Dict(  WSAENOPROTOOPT         );
   	AddConst2Dict(  WSAEPROTONOSUPPORT     );
   	AddConst2Dict(  WSAESOCKTNOSUPPORT     );
   	AddConst2Dict(  WSAEOPNOTSUPP          );
   	AddConst2Dict(  WSAEPFNOSUPPORT        );
   	AddConst2Dict(  WSAEAFNOSUPPORT        );
   	AddConst2Dict(  WSAEADDRINUSE          );
   	AddConst2Dict(  WSAEADDRNOTAVAIL       );
   	AddConst2Dict(  WSAENETDOWN            );
   	AddConst2Dict(  WSAENETUNREACH         );
   	AddConst2Dict(  WSAENETRESET           );
   	AddConst2Dict(  WSAECONNABORTED        );
   	AddConst2Dict(  WSAECONNRESET          );
   	AddConst2Dict(  WSAENOBUFS             );
   	AddConst2Dict(  WSAEISCONN             );
   	AddConst2Dict(  WSAENOTCONN            );
   	AddConst2Dict(  WSAESHUTDOWN           );
   	AddConst2Dict(  WSAETOOMANYREFS        );
   	AddConst2Dict(  WSAETIMEDOUT           );
   	AddConst2Dict(  WSAECONNREFUSED        );
   	AddConst2Dict(  WSAELOOP               );
   	AddConst2Dict(  WSAENAMETOOLONG        );
   	AddConst2Dict(  WSAEHOSTDOWN           );
   	AddConst2Dict(  WSAEHOSTUNREACH        );
   	AddConst2Dict(  WSAENOTEMPTY           );
   	AddConst2Dict(  WSAEPROCLIM            );
   	AddConst2Dict(  WSAEUSERS              );
   	AddConst2Dict(  WSAEDQUOT              );
   	AddConst2Dict(  WSAESTALE              );
   	AddConst2Dict(  WSAEREMOTE             );

   	AddConst2Dict(  WSAEDISCON             );

   	AddConst2Dict(  WSASYSNOTREADY         );
   	AddConst2Dict(  WSAVERNOTSUPPORTED     );
   	AddConst2Dict(  WSANOTINITIALISED      );
   	AddConst2Dict(  WSAHOST_NOT_FOUND      );
   	AddConst2Dict(  HOST_NOT_FOUND    );
   	AddConst2Dict(  WSATRY_AGAIN    );
   	AddConst2Dict(  TRY_AGAIN    );
   	AddConst2Dict(  WSANO_RECOVERY    );
   	AddConst2Dict(  NO_RECOVERY    );
   	AddConst2Dict(  WSANO_DATA    );
   	AddConst2Dict(  NO_DATA    );
   	AddConst2Dict(  NO_ADDRESS   );
   	AddConst2Dict(  WSANO_ADDRESS     );

#endif



#define AddConst2Dict_true( Const )          \
  x = Py_BuildValue ("i", 1);                \
  PyDict_SetItemString (d, #Const, x)

#define AddConst2Dict_false( Const )          \
  x = Py_BuildValue ("i", 0);                 \
  PyDict_SetItemString (d, #Const, x)

// Version Values

#ifdef V_VersionX
	AddConst2Dict_true(V_VersionX);
#else
	AddConst2Dict_false(V_VersionX);
#endif

#ifdef V_VersionWindows
	AddConst2Dict_true(V_VersionWindows);
#else
	AddConst2Dict_false(V_VersionWindows);
#endif


}
