//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvmem.cc
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvmem.h"

PyObject * 
Py_vMemoryDC_Constructor(PyObject* self, PyObject* args)
{
    int width, height;
    vMemoryDC* thisDC;
    if (!PyArg_ParseTuple(args, "ii",
	&width ,
	&height
	))
	return NULL;
    thisDC = new vMemoryDC(width, height);
    return Py_BuildValue("l", thisDC);
}


PyObject * 
Py_vMemoryDC_Destructor(PyObject* self, PyObject* args)
{
    vMemoryDC* thisDC;
    if (!PyArg_Parse(args, "l",	&thisDC))
	return NULL;
    delete thisDC;
    Py_INCREF (Py_None);
    return Py_None;
}

