//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvfont.cc
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvfont.h"


PyObject *
Py_vFont_Constructor(PyObject* self, PyObject* args)
{
    vFont *pFont;
    vFontID fam, sty, wt;

    unsigned char *pBuf;
    int size, und;
    
    if (!PyArg_ParseTuple(args, "iiiii",
		     &fam,
		     &size,
		     &sty,
		     &wt,
		     &und))
	return NULL;

    pFont = new vFont(fam, size, sty, wt, und);

    return Py_BuildValue("l", (PyObject *) pFont);
}
    

PyObject *
Py_vFont_Destructor(PyObject* self, PyObject* args)
{
    vFont *pFont;
    if (!PyArg_Parse(args, "l",
		     &pFont
		     ))
	return NULL;
    delete pFont;
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject *
Py_vFont_GetFamily(PyObject* self, PyObject* args)
{
    vFont *pFont;
    if (!PyArg_Parse(args, "l",
			  &pFont
			  ))
	return NULL;
    return Py_BuildValue("l", (PyObject *) pFont->GetFamily());
}

PyObject *
Py_vFont_GetPointSize(PyObject* self, PyObject* args)
{
    vFont *pFont;
    if (!PyArg_Parse(args, "l",
			  &pFont
			  ))
	return NULL;
    return Py_BuildValue("i", (PyObject *) pFont->GetPointSize());
}

PyObject *
Py_vFont_GetStyle(PyObject* self, PyObject* args)
{
    vFont *pFont;
    if (!PyArg_Parse(args, "l",
			  &pFont
			  ))
	return NULL;
    return Py_BuildValue("l", (PyObject *) pFont->GetStyle());
}


PyObject *
Py_vFont_GetWeight(PyObject* self, PyObject* args)
{
    vFont *pFont;
    if (!PyArg_Parse(args, "l",
			  &pFont
			  ))
	return NULL;
    return Py_BuildValue("l", (PyObject *) pFont->GetWeight());
}

PyObject *
Py_vFont_GetUnderlined(PyObject* self, PyObject* args)
{
    vFont *pFont;
    if (!PyArg_Parse(args, "l",
			  &pFont
			  ))
	return NULL;
    return Py_BuildValue("l", (PyObject *) pFont->GetUnderlined());
}

PyObject *
Py_vFont_SetFontValues(PyObject* self, PyObject* args)
{
    vFont *pFont;
    vFontID fam, sty, wt;

    unsigned char *pBuf;
    int size, und;
    
    if (!PyArg_ParseTuple(args, "liiiii",
		     &pFont,
		     &fam,
		     &size,
		     &sty,
		     &wt,
		     &und))
	return NULL;

    pFont->SetFontValues(fam, size, sty, wt, und);

    Py_INCREF (Py_None);
    return Py_None;
}
