//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvedt.cpp
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================


#include "pyvedt.h"
//======================================================================
pytTextEditor::pytTextEditor(vBaseWindow* parent,
			PyObject *cb_ChangeLoc,
			PyObject *cb_ChangeInsMode,
			PyObject *cb_StatusMessage,
			PyObject *cb_ErrorMsg,
			PyObject *cb_EditKeyIn
			     ):vTextEditor(parent)

{

    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_ChangeLoc,     vTextEditor_cb_ChangeLoc     );
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_ChangeInsMode, vTextEditor_cb_ChangeInsMode );
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_StatusMessage, vTextEditor_cb_StatusMessage );
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_ErrorMsg,      vTextEditor_cb_ErrorMsg      );
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_EditKeyIn,     vTextEditor_cb_EditKeyIn     );
    
    Py_XINCREF( vTextEditor_cb_ChangeLoc        );
    Py_XINCREF( vTextEditor_cb_ChangeInsMode    );
    Py_XINCREF( vTextEditor_cb_StatusMessage    );
    Py_XINCREF( vTextEditor_cb_ErrorMsg         );
    Py_XINCREF( vTextEditor_cb_EditKeyIn        );
}


pytTextEditor::~pytTextEditor()
{
    Py_XDECREF( vTextEditor_cb_ChangeLoc        );
    Py_XDECREF( vTextEditor_cb_ChangeInsMode    );
    Py_XDECREF( vTextEditor_cb_StatusMessage    );
    Py_XDECREF( vTextEditor_cb_ErrorMsg         );
    Py_XDECREF( vTextEditor_cb_EditKeyIn        );
}



//======================================================================
void pytTextEditor::ChangeLoc(long line, int col)
{
  PyObject *arglist,*result;
  if(vTextEditor_cb_ChangeLoc != NULL)
  {
      arglist = Py_BuildValue("(li)", line, col);
      result  = PyEval_CallObject(vTextEditor_cb_ChangeLoc, arglist);
      CHECK_RETURN_RESULT ( result );
      Py_DECREF(arglist);
  }
}

//======================================================================
void pytTextEditor::ChangeInsMode(int IsInsMode)
{
    PyObject *arglist,*result;
    if(vTextEditor_cb_ChangeInsMode != NULL)
    {
	arglist = Py_BuildValue("(i)", IsInsMode);
	result  = PyEval_CallObject(vTextEditor_cb_ChangeInsMode, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
    }
}

//======================================================================
void pytTextEditor::StatusMessage(char *msg)
{
    PyObject *arglist,*result;
    if(vTextEditor_cb_StatusMessage != NULL)
    {
	arglist = Py_BuildValue("(s)", msg);
	result  = PyEval_CallObject(vTextEditor_cb_StatusMessage, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
    }
}
//======================================================================
void pytTextEditor::ErrorMsg(char *str)
{
    PyObject *arglist,*result;
    if(vTextEditor_cb_ErrorMsg != NULL)
    {
	arglist = Py_BuildValue("(s)", str);
	result  = PyEval_CallObject(vTextEditor_cb_ErrorMsg, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
    }
}

//======================================================================
int pytTextEditor::EditKeyIn(vKey key, unsigned int shift)
{
// Returns :  
//          process keystrokes -- return 1 if processed, 0 if
//          command fails, and -1 if not recognized

    PyObject *arglist,*result;
    if(vTextEditor_cb_EditKeyIn != NULL)
    {
	arglist = Py_BuildValue("(li)", key, shift);
	result  = PyEval_CallObject(vTextEditor_cb_EditKeyIn, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
	return 1;
    }
    else
	return vTextEditor::EditKeyIn(key, shift);
}

//======================================================================
//======================================================================
//======================================================================


PyObject * 
Py_vTextEditor_Constructor(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    
    vBaseWindow* parent;
    PyObject *cb_ChangeLoc;
    PyObject *cb_ChangeInsMode;
    PyObject *cb_StatusMessage;
    PyObject *cb_ErrorMsg;
    PyObject *cb_EditKeyIn;
    
    if (!PyArg_ParseTuple(args, "lOOOOO",
			  &parent,
			  &cb_ChangeLoc,
			  &cb_ChangeInsMode,
			  &cb_StatusMessage,
			  &cb_ErrorMsg,
			  &cb_EditKeyIn
			  ))
	return NULL;
    
    thisEdt = new pytTextEditor(parent,
				cb_ChangeLoc,
				cb_ChangeInsMode,
				cb_StatusMessage,
				cb_ErrorMsg,
				cb_EditKeyIn);

    return Py_BuildValue("l", thisEdt);
}


PyObject * 
Py_vTextEditor_Destructor(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    if (!PyArg_Parse(args, "l", &thisEdt))
	return NULL;
    delete thisEdt;
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextEditor_resetBuff(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    if (!PyArg_Parse(args, "l", &thisEdt))
	return NULL;
	thisEdt->resetBuff();
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextEditor_addLine(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    char *line;
    if (!PyArg_Parse(args, "(ls)", &thisEdt, &line))
	return NULL;
    return Py_BuildValue("l", thisEdt->addLine(line));
}

PyObject * 
Py_vTextEditor_getFirstLine(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    char line[MAX_CHARS];
    int rez;
    if (!PyArg_Parse(args, "l", &thisEdt))
	return NULL;
    rez=thisEdt->getFirstLine(line, MAX_CHARS);
    return Py_BuildValue("(is)", rez, line );
}

PyObject * 
Py_vTextEditor_getNextLine(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    char line[MAX_CHARS];
    int rez;
    if (!PyArg_Parse(args, "(li)", &thisEdt))
	return NULL;
    rez=thisEdt->getNextLine(line, MAX_CHARS);
    return Py_BuildValue("(is)", rez, line);
}

PyObject * 
Py_vTextEditor_getLine(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    char line[MAX_CHARS];
    long lineNum;
    int rez;
    if (!PyArg_Parse(args, "(ll)", &thisEdt, &lineNum))
	return NULL;
    rez=thisEdt->getLine(line, MAX_CHARS, lineNum);
    return Py_BuildValue("(is)", rez, line );
}

PyObject * 
Py_vTextEditor_displayBuff(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    long lineNum;
    if (!PyArg_Parse(args, "(ll)", &thisEdt, &lineNum))
	return NULL;
    thisEdt->displayBuff(lineNum);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextEditor_EditCommand(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    long lineNum;
    int id;
    long val;
    if (!PyArg_Parse(args, "(lil)", &thisEdt, &id, &val))
	return NULL;
    return Py_BuildValue("l", thisEdt->EditCommand(id, val));
}

PyObject * 
Py_vTextEditor_EditKeyIn(PyObject* self, PyObject* args)
{
    pytTextEditor* thisEdt;
    vKey key;
    unsigned int shift;
    if (!PyArg_Parse(args, "(lli)", &thisEdt, &key, &shift))
	return NULL;
    return Py_BuildValue("l", thisEdt->EditKeyIn(key, shift));
}



