//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvdbg.cpp
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================


#include "pyvdbg.h"

PyObject *
Py_vDebugDialog_Constructor(PyObject* self, PyObject* args)
{
    vDebugDialog* pDebug;
    vBaseWindow* win;	
    if (!PyArg_Parse(args, "l", &win))
	return NULL;
    pDebug = new vDebugDialog(win);
    return Py_BuildValue("l", (PyObject *) pDebug);
}
    


PyObject *
Py_vDebugDialog_Destructor(PyObject* self, PyObject* args)
{
    vDebugDialog* pDebug;
    if (!PyArg_Parse(args, "l",
		     &pDebug))
	return NULL;
    delete pDebug;
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_vDebugDialog_SetDebug(PyObject* self, PyObject* args)
{
    vDebugDialog* pDebug;
    if (!PyArg_Parse(args, "l",
		     &pDebug))
	return NULL;
    pDebug->SetDebug();
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_vDebugDialog_DialogCommand(PyObject* self, PyObject* args)
{
    vDebugDialog* pDebug;
    ItemVal id;
    ItemVal val;
    CmdType ctype;
    if (!PyArg_Parse(args, "(liii)",
		     &pDebug,
		     &id,
		     &val,
		     &ctype
		     ))
	return NULL;
    pDebug->DialogCommand(id, val, ctype);
    Py_INCREF (Py_None);
    return Py_None;
}




static int flag_pyvTrace=0;
static FILE *fd_pyvTrace=NULL;
static int   pyvTrace_FlushMode=1;


static flag_pyvTrace_Display=0;
static vCmdWindow *winDbg=NULL;
static vTextCanvasPane *paneTxt=NULL;
static int idx_Row, rows_DebugWin;

static void PYV_OUTPUT(char*, int);

static  PFV_OUTPUT_HNDLR_TYPE PYV_OUTPUT_FUNCTION=PYV_OUTPUT;

//
// Following two functions allow output redirection
// for Python and V code. 
// Currently it is useful for startup in WIN32
// Environment. This permits to save output
// of messages/errors during initialization.
//


//
// PYV_DefaultOutputFunction
// 
extern "C" void PYV_DefaultOutputFunction( )
{
    PYV_OUTPUT_FUNCTION=PYV_OUTPUT;
}

//
// PYV_NewOutputFunction
// 
extern "C" void PYV_NewOutputFunction( PFV_OUTPUT_HNDLR_TYPE  NewFunc )
{
    PYV_OUTPUT_FUNCTION=NewFunc;
    flag_pyvTrace=1;
}

//
// PYV_GetTraceFlag
// 
extern "C" int  PYV_GetTraceFlag()
{
    return flag_pyvTrace;
}

//
// PYV_SetTraceFlag
// 
extern "C" void  PYV_SetTraceFlag(int flg)
{
    flag_pyvTrace=flg;
}


PyObject *
Py_pyvTrace_Display(PyObject* self, PyObject* args)
{
    vCmdWindow *winDbg;

    winDbg = new vCmdWindow("Trace Log");
    paneTxt= new vTextCanvasPane();
    winDbg->AddPane(paneTxt);
    winDbg->ShowWindow();

    rows_DebugWin=paneTxt->GetRows();
    idx_Row=0;

    flag_pyvTrace_Display=1;
    
    Py_INCREF (Py_None);
    return Py_None;
}


static void PYV_OUTPUT(char *buf, int color)
{

    if(fd_pyvTrace!=NULL)
	fputs(buf, fd_pyvTrace);
    if(pyvTrace_FlushMode)	
	fflush(fd_pyvTrace);



    if(flag_pyvTrace_Display)
    {
	flag_pyvTrace=0;
	rows_DebugWin=paneTxt->GetRows();
	if(idx_Row == rows_DebugWin-1) 
	{
//	    paneTxt->Clear();
	    idx_Row=0;
	}
	paneTxt->DrawAttrText(buf, color);
	idx_Row++;
	flag_pyvTrace=1;
    }

}




static void PYT_OUTPUT(char *buf)
{
    (*PYV_OUTPUT_FUNCTION)(buf, ChBlue);
}

static void V_OUTPUT(char *buf)
{
    (*PYV_OUTPUT_FUNCTION)(buf, ChRed);
}



extern "C" int PYT_printf(char *buf)
{
    if(flag_pyvTrace)   PYT_OUTPUT(buf);
    return 1;
}

extern "C" int PYT_fprintf(int hndlr, char *buf)
{
    if(flag_pyvTrace)   PYT_OUTPUT(buf);
    return 1;
}

extern "C" int PYT_puts(char *buf)
{
    if(flag_pyvTrace)   PYT_OUTPUT(buf);
    return 1;
}

extern "C" int PYT_fwrite(char *ptr, int size, int n, FILE *stream)
{
    char buf[1024];
    int i, j, k;
    if(flag_pyvTrace)
    {
	for(i=0; i< n; i++)
	    for(j=0; j< size; j++)
	    {
		k=i*size+j;
		if(k>=1023) goto lbl;
		buf[k]=*(ptr++);
	    }
    lbl:
	buf[k+1]=0;
	PYT_OUTPUT(buf);
    }
    return 1;
}





extern "C" int V_fprintf(FILE *stream, const char *format, ...)
{
    va_list arg;
    int done;
    char buf[255];
    
    if(flag_pyvTrace)
    {
	va_start(arg, format);
	done = vsprintf(buf, format, arg);
	va_end(arg);
	
	V_OUTPUT(buf);
    }
    return done;
}



PyObject *
Py_pyvTraceFileOpen(PyObject* self, PyObject* args)
{
    char *pFile;
    if (!PyArg_Parse(args, "s",&pFile))
	return NULL;
    fd_pyvTrace=fopen(pFile,"w");
    flag_pyvTrace=1;
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_pyvTraceFileClose(PyObject* self, PyObject* args)
{
    fclose(fd_pyvTrace);
    flag_pyvTrace=0;
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_pyvTraceFileFlush(PyObject* self, PyObject* args)
{
    fflush(fd_pyvTrace);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_pyvTraceFileFlushMode(PyObject* self, PyObject* args)
{
    int OnOff;
    if (!PyArg_Parse(args, "i",&OnOff))
	return NULL;
    pyvTrace_FlushMode=OnOff;
    Py_INCREF (Py_None);
    return Py_None;
}




