#ifndef PYVCNVS_H
#define PYVCNVS_H

#include <pyv.h>

#include <v/vcanvas.h>
#include <v/vprinter.h>



class pytCanvasPane : public vCanvasPane
{
public:  //---------------------------------------- public
    pytCanvasPane(
	PyObject *cb_FontChanged,
        PyObject *cb_HPage,
        PyObject *cb_VPage,  
        PyObject *cb_HScroll,
        PyObject *cb_VScroll,
	PyObject *cb_MouseDown,
	PyObject *cb_MouseUp,
	PyObject *cb_MouseMove,
	PyObject *cb_MouseMotion,
	PyObject *cb_EnterFocus,
	PyObject *cb_LeaveFocus,
	PyObject *cb_Redraw,
	PyObject *cb_Resize
	);

    virtual ~pytCanvasPane();
    

    // Change messages
    virtual void FontChanged(vFont& vf);
    

    // Scrolling
    virtual void HPage(int Shown, int Top);	// Horiz page event
    virtual void VPage(int Shown, int Top);	// Vert page event
    virtual void HScroll(int step);		// Horiz scroll event
    virtual void VScroll(int step);		// Vert scroll event
    
    // Events
    virtual void MouseDown(int x, int y, int button);
    virtual void MouseUp(int x, int y, int button);
    virtual void MouseMove(int x, int y, int button);
    virtual void MouseMotion(int x, int y);
    
    virtual void EnterFocus();
    virtual void LeaveFocus();
    
    // Expose/redraw event
    virtual void Redraw(int x, int y,  int width, int height);
    virtual void Resize( int newW, int newH);


private:          //--------------------------------------- private
    PyObject *vCanvasPane_cb_FontChanged;
    PyObject *vCanvasPane_cb_HPage;
    PyObject *vCanvasPane_cb_VPage;
    PyObject *vCanvasPane_cb_HScroll;
    PyObject *vCanvasPane_cb_VScroll;
    PyObject *vCanvasPane_cb_MouseDown;
    PyObject *vCanvasPane_cb_MouseUp;
    PyObject *vCanvasPane_cb_MouseMove;
    PyObject *vCanvasPane_cb_MouseMotion;
    PyObject *vCanvasPane_cb_EnterFocus;
    PyObject *vCanvasPane_cb_LeaveFocus;
    PyObject *vCanvasPane_cb_Redraw;
    PyObject *vCanvasPane_cb_Resize;     

};

    




#endif
