//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvcmdob.cc
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include <pyv.h>


CommandObject * 
ProcessCommandObject(PyObject* objList)
{
    int sizeOfList, szBytes, i, j, nbrOfStr;
    CommandObject *cList, *pCmdObject;
    PyObject *objTmp, *objType, *objStr, *objCmdObjList, *tmpObj;
    char *pType, *pStr, *pTmp, *pBuf, *pMem;
    void **ppList;


#define NUMBER_OF_ITEMS_IN_CommandObject 11

#define PROCESS_ITEM( vItem, Casting_Type, nmbr )           \
                                                            \
	objTmp=PyList_GetItem(objCmdObjList,nmbr);          \
	Py_INCREF(objTmp);                                  \
	objType=PyObject_Type ( objTmp  );                  \
	objStr=PyObject_Str( objType  );                    \
	pType=PyString_AsString(objStr);                    \
	if(strcmp(pType,"<type 'int'>")!=0)                 \
	    Py_v_FATAL_ERR(                        \
             "ProcessCommandObject: <type 'int'> -- missing\n");\
        vItem= Casting_Type PyInt_AsLong(objTmp);           \
	Py_DECREF(objTmp);                                  \
	Py_DECREF(objType);                                 \
	Py_DECREF(objStr);



    sizeOfList=PyList_Size(objList);
    szBytes=sizeof(CommandObject)*(sizeOfList+1);

    cList=(CommandObject *)malloc(szBytes);
    if(cList==NULL)  
	Py_v_FATAL_ERR( 
	    "\nProcessCommandObject: pCmdObject malloc error.\n");

    pCmdObject=cList;


    for(i=0; i< sizeOfList; i++)
    {
	objCmdObjList=PyList_GetItem(objList,i);
	Py_INCREF(objCmdObjList);
	
	
	objType=PyObject_Type ( objCmdObjList  );
	objStr=PyObject_Str( objType  );
	
	pType=PyString_AsString(objStr);
	
	if(strcmp(pType,"<type 'list'>")!=0)
	    Py_v_FATAL_ERR(
		"\nProcessCommandObject: should to be the list type\n");

	Py_DECREF(objStr);
	Py_DECREF(objType);                                 \
	
	if(PyList_Size(objCmdObjList)
	   < NUMBER_OF_ITEMS_IN_CommandObject)
	    Py_v_FATAL_ERR(
		"\nProcessCommandObject: Not enough params in CommandObject\n");
	

	PROCESS_ITEM( pCmdObject->cmdType,   (CmdType),  0);
	PROCESS_ITEM( pCmdObject->cmdId,     (ItemVal),  1);
	PROCESS_ITEM( pCmdObject->retVal,    (ItemVal),  2);


//
// Processing of item -- char* title
// Order # 3
//
	objTmp=PyList_GetItem(objCmdObjList,3);
	Py_INCREF(objTmp);
	objType=PyObject_Type ( objTmp  );
	objStr=PyObject_Str( objType  );
	pType=PyString_AsString(objStr);
	if(strcmp(pType,"<type 'string'>")!=0)
	    Py_v_FATAL_ERR(
		"\nProcessCommandObject: <type 'string'> -- missing\n");
	pStr=PyString_AsString(objTmp);
	pBuf=(char *)malloc(strlen(pStr)+4);
	if(pBuf==NULL)
	    Py_v_FATAL_ERR(
		"\nProcessCommandObject: pStr=malloc error.\n");
	strcpy(pBuf,pStr);
	pCmdObject->title = pBuf;

	Py_DECREF(objTmp); 
	Py_DECREF(objType); 
	Py_DECREF(objStr);


//
// void* itemList                4
//
	objTmp=PyList_GetItem(objCmdObjList,4);
	Py_INCREF(objTmp);
	objType=PyObject_Type ( objTmp  );
	objStr=PyObject_Str( objType  );
	pType=PyString_AsString(objStr);
	
	if(strcmp(pType,"<type 'int'>")==0)
	{
	    if(! ((pCmdObject->cmdType==C_Icon) || 
		  (pCmdObject->cmdType==C_IconButton)) )
		Py_v_FATAL_ERR("\nProcessCommandObject: itemList <type 'int'> but not C_Icon or C_IconButton\n");
	    pCmdObject->itemList= (void *) PyInt_AsLong(objTmp); 
	    
	}
	else 
	{
	    nbrOfStr=PyList_Size(objTmp);
	    if(strcmp(pType,"<type 'list'>")!=0)
		Py_v_FATAL_ERR("\nProcessCommandObject: itemList should be <type 'list'> or <type 'int'>\n");
	    
	    nbrOfStr=PyList_Size(objTmp);
	    if(nbrOfStr==0)
	    {
		pCmdObject->itemList= (void *) NoList;
	    }
	    else 
	    {
    		PyObject  *objTxt, *objType, *objStr;
		
		ppList= (void **) malloc( (sizeof(void *)) * (nbrOfStr+2) );
		pCmdObject->itemList = (void *) &ppList[0];
		if(ppList==NULL)
		    Py_v_FATAL_ERR(
				   "\nProcessCommandObject: pCmdObject->itemList=malloc error.\n");
		ppList[nbrOfStr]=(void*) NULL;
		for(j=0;j<nbrOfStr;j++)
		{
		    objTxt=PyList_GetItem(objTmp,j);
		    Py_INCREF(objTxt);
		    
		    objType=PyObject_Type ( objTxt  );
		    objStr=PyObject_Str( objType  );
		    pType=PyString_AsString(objStr);
		    if(strcmp(pType,"<type 'string'>")!=0)
			Py_v_FATAL_ERR("\nProcessCommandObject: list itemshould be string type\n");
		    
		    Py_DECREF(objType); 
		    Py_DECREF(objStr);
		    
		    objStr=PyObject_Str( objTxt  );
		    pStr=PyString_AsString(objStr);
		    pMem=(char *)malloc(strlen(pStr)+2);
		    if(pMem==NULL) 
			Py_v_FATAL_ERR(
				       "\nProcessCommandObject: pMem=malloc error.\n");
		    strcpy(pMem, pStr);
		    Py_DECREF(objStr);
		    ppList[j]=(void *)pMem;
		    
		    Py_DECREF(objTxt);
		}
	    }
	    
	    Py_DECREF(objTmp); 
	    Py_DECREF(objType); 
	    Py_DECREF(objStr);
	}

	PROCESS_ITEM( pCmdObject->attrs,    (CmdAttribute),  5);
	PROCESS_ITEM( pCmdObject->Sensitive, (int),          6);
	PROCESS_ITEM( pCmdObject->cFrame,    (ItemVal),      7);
	PROCESS_ITEM( pCmdObject->cRightOf,  (ItemVal),      8);
	PROCESS_ITEM( pCmdObject->cBelow,    (ItemVal),      9);
	PROCESS_ITEM( pCmdObject->size,      (int),         10);

	pCmdObject++;

	Py_DECREF(objCmdObjList); 
    }
    pCmdObject->cmdType  = C_EndOfList;
    pCmdObject->cmdId    = 0;
    pCmdObject->retVal   = 0;
    pCmdObject->title    = 0;
    pCmdObject->itemList = 0;
    pCmdObject->attrs    = CA_None;
    pCmdObject->Sensitive= 0;
    pCmdObject->cFrame   = 0;
    pCmdObject->cRightOf = 0;
    pCmdObject->cBelow   = 0;
    pCmdObject->size     = 0;

    return cList;
}
