/* -*- C -*- ***********************************************
Copyright 1991-1995 by Stichting Mathematisch Centrum, Amsterdam,
The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Module configuration */

/* This file contains the table of built-in modules.
   See init_builtin() in import.c. */

#define PLEASE_WITHOUT_STDIO_REDEFINITION

#include "Python.h"

extern void initarray();
extern void initaudioop();
extern void initbinascii();
extern void initcmath();
extern void initerrno();
extern void initimageop();
extern void initmath();
extern void initmd5();
extern void initnew();
extern void initnt();
extern void initoperator();
extern void initregex();
extern void initrgbimg();
extern void initrotor();
extern void initsignal();
extern void initselect();
extern void init_socket();
extern void initsoundex();
extern void initstrop();
extern void initstruct();
extern void inittime();
extern void initthread();

#define DllExport	__declspec( dllexport )

DllExport void SetVinit();

typedef char* (*PFV)();

static PFV Func_Stdio[20]={0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L};

void SetVinit(PFV *func)	
{
		Func_Stdio[0]=(PFV) func[0];  /* initv     */
		Func_Stdio[1]=(PFV) func[1];  /* printf    */
		Func_Stdio[2]=(PFV) func[2];  /* fprintf   */
		Func_Stdio[3]=(PFV) func[3];  /* puts      */
		Func_Stdio[4]=(PFV) func[4];  /* fputs     */
		Func_Stdio[5]=(PFV) func[5];  /* putc      */
		Func_Stdio[6]=(PFV) func[6];  /* fputc     */
		Func_Stdio[7]=(PFV) func[7];  /* getc      */
		Func_Stdio[8]=(PFV) func[8];  /* fgets     */
		Func_Stdio[9]=(PFV) func[9];  /* fwrite    */
}		



void initvv()
{
	if (Func_Stdio[0]!=(PFV) NULL)
	{
		(*Func_Stdio[0])();
	}
}


int pyt_printf(char *format, ...)
{
  va_list arg;
  int done;
  char buf[512];

  va_start(arg, format);
  done = vsprintf(buf, format, arg);
  va_end(arg);

  if(Func_Stdio[1]!=(PFV) NULL) 
  {
      return (int) (*Func_Stdio[1])(buf);
  }
  return printf("%s", buf);
}


int pyt_fprintf(FILE *stream, char *format, ...)
{
  va_list arg;
  int done;
  char buf[512];

  va_start(arg, format);
  done = vsprintf(buf, format, arg);
  va_end(arg);

  if(((stream == stdout) || (stream == stderr)) && (Func_Stdio[2]!=(PFV) NULL))
  {
	  (*Func_Stdio[2])(stream, buf);
	  return done;
  }
  else
	  return fprintf(stream, "%s", buf);
}



int pyt_puts(const char *str)
{
  if (Func_Stdio[3]!=(PFV) NULL)
      return (int) (*Func_Stdio[3])(str);
  else 
      return puts(str);
}




int pyt_fputs(const char *str, FILE *stream)
{
  if(((stream == stdout) || (stream == stderr)) && (Func_Stdio[4]!=(PFV) NULL))
      return (int) (*Func_Stdio[4])(str, stream);
  else
	  return fputs(str, stream);
}


int pyt_putc(int c, FILE *stream)
{
  if(((stream == stdout) || (stream == stderr)) && (Func_Stdio[5]!=(PFV) NULL))
      return (int) (*Func_Stdio[5])(c, stream);

  else return putc(c, stream);
}


int pyt_fputc(int c, FILE *stream)
{
  if(((stream == stdout) || (stream == stderr)) && (Func_Stdio[6]!=(PFV) NULL))
      return (int) (*Func_Stdio[6])(c, stream);
  else return fputc(c, stream);
}

int pyt_getc(FILE *stream)
{
  if ((stream == stdin) && (Func_Stdio[7]!=(PFV) NULL))
      return (int) (*Func_Stdio[7])(stream);
  else return getc(stream);
}


char *pyt_fgets(char *s, int n, FILE *stream)
{
  if ((stream == stdin) &&  (Func_Stdio[8]!=(PFV) NULL))
      return (char *) (*Func_Stdio[8])(s, n, stream);
  else return (char *) fgets(s, n, stream);
}



size_t pyt_fwrite(void *buffer, size_t size, size_t count, FILE *stream)
{
  if(((stream == stdout) || (stream == stderr)) && (Func_Stdio[9]!=(PFV) NULL))
	  return (size_t) (*Func_Stdio[9])(buffer, size, count, stream);
  else 
	  return (size_t) fwrite(buffer, size, count, stream);

}


/* -- ADDMODULE MARKER 1 -- */

extern void PyMarshal_Init();
extern void initimp();

struct _inittab inittab[] = {

        {"array", initarray},
#ifdef M_I386
        {"audioop", initaudioop},
#endif
        {"binascii", initbinascii},
        {"cmath", initcmath},
        {"errno", initerrno},
        {"imageop", initimageop},
        {"math", initmath},
        {"md5", initmd5},
        {"new", initnew},
        {"nt", initnt},	/* Use the NT os functions, not posix */
        {"operator", initoperator},
        {"regex", initregex},
        {"rgbimg", initrgbimg},
        {"rotor", initrotor},
        {"signal", initsignal},
#ifdef USE_SOCKET
	{"_socket", init_socket},
	{"select", initselect},
#endif
        {"soundex", initsoundex},
        {"strop", initstrop},
        {"struct", initstruct},
        {"time", inittime},
#ifdef WITH_THREAD
        {"thread", initthread},
#endif
		{"v", initvv},
/* -- ADDMODULE MARKER 2 -- */

        /* This module "lives in" with marshal.c */
        {"marshal", PyMarshal_Init},

        /* This lives it with import.c */
        {"imp", initimp},

        /* These entries are here for sys.builtin_module_names */
        {"__main__", NULL},
        {"__builtin__", NULL},
        {"sys", NULL},

        /* Sentinel */
        {0, 0}
};
