##################################################################################
#   
#      PYV -- Binding of Python and GUI V.
#  
# 
#      File: V.py
#
#      Version: 57570317 (V_version())
# 
#      Author: 
#               Sofin Raskin, sofin@ecitele.com
# 
##################################################################################

import v
from v import * 




__AboutMenu=[

        ["       PYV       ",   998,      isSens,  notChk,   noKeyLbl,   noKey,   noSub],
        ["  Python + GUI V ",   998,      isSens,  notChk,   noKeyLbl,   noKey,   noSub],
        ["-",                    M_Line, notSens,  notChk,   noKeyLbl,   noKey,   noSub],
        ["(c)  Sofin Raskin",   998,      isSens,  notChk,   noKeyLbl,   noKey,   noSub],
        ["sofin@ecitele.com",   998,      isSens,  notChk,   noKeyLbl,   noKey,   noSub],
        ["-    ",                M_Line, notSens,  notChk,   noKeyLbl,   noKey,   noSub],
	]

pyv___DefaultMenu=[
	["About",    M_File,   notSens,  notUsed,  notUsed,    noKey,   __AboutMenu ],
	]


if V_VersionWindows: pyv___flgDefineDefaultMenu=1
else:                pyv___flgDefineDefaultMenu=0


##################################################################################
#		              V_version
##################################################################################
def V_version():
	return "57570317"
	
##################################################################################
#		              v_version
##################################################################################
def pyv_version():
	return v.v_Version()




##
##
pyv___pyv_dict_of_windows={}
#

##################################################################################
#		                    vApp
##################################################################################
class vApp:
	def __init__(self, 
		     cb_AppCommand=None,
		     cb_CloseAppWin=None,
		     cb_Exit=None,
		     cb_KeyIn=None):

		if cb_CloseAppWin!=None:
			self.user_cb_CloseAppWin=cb_CloseAppWin
			cb_CloseAppWin=self.cb_CloseAppWin

		self.win=v.vApp_Constructor(cb_AppCommand,
					    cb_CloseAppWin,
					    cb_Exit,
					    cb_KeyIn)
		return
	
	def cb_CloseAppWin(self, win):
		
		try:
			objWin=pyv___pyv_dict_of_windows[win]
		except:
			pass
		else:
			self.user_cb_CloseAppWin(objWin)

			
		

	def doEventLoop(self):
		return v.vApp_doEventLoop()
		

	def appContext(self):
		return v.vApp_appContext()


	def display(self):
		return v.vApp_display()
		

	def CloseAppWin(self, Win):
		return v.vApp_CloseAppWin(Win.win)


	def Exit(self):
		return v.vApp_Exit()


	def NewAppWin(self, Win, Name, w, h, winInfo):
		NewWin=v.vApp_NewAppWin(Win,
					Name,
					w, h, 
					winInfo)
		return NewWin

	def CheckEvents(self):
		return v.vApp_CheckEvents()

	def DefaultHeight(self):
		return v.vApp_DefaultHeight()

	def DefaultWidth(self):
		return v.vApp_DefaultWidth()

	def GetDefaultFont(self):
		font=vFontEmpty()
		font.font=v.vApp_GetDefaultFont()
		return  font

	def GetVVersion(self):
		return v.vApp_GetVVersion()

	def IsRunning(self):
		return v.vApp_IsRunning()

	def ScreenHeight(self):
		return v.vApp_ScreenHeight()

	def ScreenWidth(self):
		return v.vApp_ScreenWidth()

	def SendWindowCommandAll(self, id, val, ctype):
	       return v.vApp_SendWindowCommandAll(id, val, ctype)

	def SetAppTitle(self, title):
	       return v.vApp_SetAppTitle(title)

	def SetValueAll(self, id, val, ctype):
	       return v.vApp_SetValueAll(id, val, ctype)

	def SetStringAll(self, id, strng):
	       return v.vApp_SetStringAll( id, strng)


	def ShowList(self):
		return v.vApp_ShowList()



##################################################################################
#		              vCmdWindow
##################################################################################


class vCmdWindow:
	def __init__(self, 
			name, 
			width,
			height,
			cb_WindowCommand=None,  
			cb_MenuCommand=None,
			cb_KeyIn=None,
			cb_Win95_Msg_Processing=None  
				):
		global pyv___pyv_dict_of_windows

		self.win=v.vCmdWindow_Constructor(
					cb_Win95_Msg_Processing,
					cb_KeyIn,
					cb_MenuCommand,
					cb_WindowCommand,
					name, 
					height, 
					width)
		
		pyv___pyv_dict_of_windows[self.win]=self

		#	
		# This flag is defined in order to force
		# to provide for every window the menu pane.
		# W95 crashes without menu pane.
		# 
		self.flgMenu=0

		return 


	def __del__(self):
		v.vCmdWindow_Destructor(self.win)

	def AddPane(self, pane):
		v.vCmdWindow_AddPane(self.win, pane.Pane)
		return pane.InitAfter_AddPane(self)
		return

		
	def GetValue(self,itemId):
		return v.vCmdWindow_GetValue(self.win, itemId)

	def GetPosition(self):		# returns tuple (left, top, width, height)
		return v.vCmdWindow_GetPosition(self.win)

	def SetPosition(self, left, top):
		return v.vCmdWindow_SetPosition(self.win, left, top)

	def RaiseWindow(self):
		return v.vCmdWindow_RaiseWindow(self.win)


	def SetValue(self, itemId, Val, what):
		return v.vCmdWindow_SetValue(self.win, itemId, Val, what)


	def SetValueAll(self, itemId, Val, what):
		return v.vCmdWindow_SetValueAll(self.win, itemId, Val, what)

	def SetString(self, itemId, title):
		return v.vCmdWindow_SetString(self.win, itemId, title)

	def SetStringAll(self, id, strng):
	       return v.vCmdWindow_SetStringAll(self.win,  id, strng)

	def SetTitle(self, title):
	       return v.vCmdWindow_SetTitle(self.win, title)

	def ShowPane(self, pane, OnOrOff):
	       return v.vCmdWindow_ShowPane(self.win,  pane.Pane, OnOrOff)


	def ShowWindow(self):
		
		#
		# See more expanation about the default menu
		# at the top of the file
		#

		if not self.flgMenu:
			if pyv___flgDefineDefaultMenu:
				self.DefaultMenuPane=vMenuPane(pyv___DefaultMenu)
				self.AddPane(self.DefaultMenuPane)
			
		return v.vCmdWindow_ShowWindow(self.win)


##################################################################################
#		              vCommandPane
##################################################################################
class vCommandPane:
	def __init__(self, lstCmdObject):
		lstObj=[]
		for cmd in lstCmdObject:
			if str(type(cmd[4]))=="<type 'instance'>":
				lstObj.append([ cmd[0],
					     cmd[1],
					     cmd[2],
					     cmd[3],
					     cmd[4].icon,
					     cmd[5],
					     cmd[6],
					     cmd[7],
					     cmd[8],
					     cmd[9],
					     cmd[10] ])
			else:
				lstObj.append(cmd)
		self.Pane=vCommandPane_Constructor(lstObj)
		return

	def InitAfter_AddPane(self, win):
		return 

	def GetTextIn(self, Id):
		return vCommandPane_GetTextIn(self.Pane, Id)
	     
	def SetCmdVal(self, val, ItemSetType):
		return vCommandPane_SetCmdVal(self.Pane, val, ItemSetType)
	     

##################################################################################
#		              vMenuPane
##################################################################################
class vMenuPane:
	def __init__(self, Menu):
		self.Menu=Menu
		self.Pane=vMenuPane_Constructor(Menu)
		return


	def InitAfter_AddPane(self, win):
		# 
		# To mark, that this window has menu pane.
		#
		win.flgMenu=1
		return
	     
	def PrintMenu(self):
		for  i in self.Menu:
			t1=type(i[6])
			t2=type([])
			flgSubMenu= not cmp(t1,t2)

			print i[0], i[1], i[2], i[3], i[4], i[5], flgSubMenu

			if flgSubMenu:
				print 'Sub Menu Call'


##################################################################################
#		              vDC
##################################################################################
class vDC:
	def __init__(self):
		return

	def Clear(self):
		return v.vDC_Clear(self.vDC)

	def ClearRect(self, left, top, width,  height ):
		return v.vDC_ClearRect(self.vDC, left, top, width, height)

	def CopyFromMemoryDC(self, vmemdc, destX, destY, srcX=0, srcY=0, srcW=0, srcH=0):
		return v.vDC_CopyFromMemoryDC(self.vDC, vmemdc.memDC, destX, destY, srcX, srcY, srcW, srcH )

	def DrawAttrText(self, x, y, Str, attr):
		return v.vDC_DrawAttrText(self.vDC, x, y, Str, attr)

	def DrawText(self, x, y, Str):
		return v.vDC_DrawText(self.vDC, x, y, Str)

	def DrawEllipse(self, x, y, width, height):
		return v.vDC_DrawEllipse(self.vDC, x, y, width, height)

	def DrawIcon(self, x, y, icon):
		if icon.icon==0:
			return
		return v.vDC_DrawIcon(self.vDC, x, y, icon.icon)


	def DrawLine(self, x, y, xend, yend):
		return v.vDC_DrawLine(self.vDC,  x, y, xend, yend)

	def DrawLines(self, lstLines, count=0):
		return v.vDC_DrawLines(self.vDC, lstLines)

	def DrawPoint(self, x, y):
		return v.vDC_DrawPoint(self.vDC, x, y)


	def DrawPoints(self, pointList, count=0):
		return v.vDC_DrawPoints(self.vDC, pointList)


	def DrawPolygon(self, n=0, pointList, fillMode=vAlternate):
		return v.vDC_DrawPolygon(self.vDC, pointList, fillMode)


	def DrawRoundedRectangle(self, x, y, width, height, radius=10):
		return v.vDC_DrawRoundedRectangle(self.vDC, x, y, width, height, radius)


	def DrawRectangle(self, x, y, width, height):
		return v.vDC_DrawRectangle(self.vDC, x, y, width, height)


	def DrawRectangles(self, lstRect, count=0):
		return v.vDC_DrawRectangles(self.vDC, lstRect)


	def DrawRubberLine(self, x, y, xend, yend):
		return v.vDC_DrawRubberLine(self.vDC,  x, y, xend, yend)


	def DrawRubberEllipse(self, x, y, width, height):
		return v.vDC_DrawRubberEllipse(self.vDC, x, y, width, height)


	def DrawRubberPoint(self, x, y):
		return v.vDC_DrawRubberPoint(self.vDC, x, y)


	def DrawRubberRectangle(self, x, y, width, height):
		return v.vDC_DrawRubberRectangle(self.vDC, x, y, width, height)


	def BeginPrinting(self, filename = "", ask = 1, isColor = 0):
		return v.vDC_BeginPrinting(self.vDC, filename, ask, isColor)


	def EndPrinting(self):
		return v.vDC_EndPrinting(self.vDC)


	def BeginPage(self):
		return v.vDC_BeginPage(self.vDC)


	def EndPage(self):
		return v.vDC_EndPage(self.vDC)

	def GetPhysHeight(self):
		return v.vDC_GetPhysHeight(self.vDC)

	def GetPhysWidth(self):
		return v.vDC_GetPhysWidth(self.vDC)

	def SetBackground(self, color):
		return v.vDC_SetBackground(self.vDC, color.color)

	def SetScale(self, mult, div):
		return v.vDC_SetScale(self.vDC, mult, div)

	def GetScale(self, mult, div):
		return v.vDC_GetScale(self.vDC, mult, div)

	def SetTranslate(self, x, y):
		return v.vDC_SetTranslate(self.vDC, x, y)

	def SetTransX(self, x):
		return v.vDC_SetTransX(self.vDC, x)

	def SetTransY(self, y):
		return v.vDC_SetTranslate(self.vDC, y)

	def GetTranslate(self, x, y):
		return v.vDC_GetTranslate(self.vDC, x, y)

	def GetTransX(self):
		return v.vDC_GetTransX(self.vDC)

	def GetTransY(self):
		return v.vDC_GetTransY(self.vDC)


	def SetBrush(self, brush):
		return v.vDC_SetBrush(self.vDC, brush.brush)

	def GetBrush(self):
		brush=vBrushEmpty()
		brush.brush=v.vDC_GetBrush(self.vDC)
		return brush


	def SetFont(self, font):
		return v.vDC_SetFont(self.vDC, font.font)

	def GetFont(self):
		font=vFontEmpty()
		font.font=v.vDC_GetFont(self.vDC)
		return  font

	def SetPen(self, pen):
		return v.vDC_SetPen(self.vDC, pen.pen)

	def GetPen(self):
		pen=vPenEmpty()
		pen.pen=v.vDC_GetPen(self.vDC)
		return pen

	def SetPrinter(self, Printer):
		return v.vDC_SetPrinter(self.vDC,Printer.printer)

	def TextHeight(self, asc, des):
		return v.vDC_TextHeight(self.vDC,asc, des)

	def TextWidth(self, strng):
		return v.vDC_TextWidth(self.vDC, strng)



##################################################################################
#		              vCanvasPane
##################################################################################
class vCanvasPane(vDC):
	def __init__(self, 
		     cb_FontChanged=None,
		     cb_HPage=None, 
		     cb_VPage=None,
		     cb_HScroll=None, 
		     cb_VScroll=None,
		     cb_MouseDown=None, 
		     cb_MouseUp=None,
		     cb_MouseMove=None,
		     cb_MouseMotion=None,
		     cb_EnterFocus=None,
	             cb_LeaveFocus=None,
		     cb_Redraw=None,
		     cb_Resize=None):
		self.Pane=v.vCanvasPane_Constructor(cb_FontChanged,
							      cb_HPage,
							      cb_VPage,	
							      cb_HScroll, 
							      cb_VScroll,
							      cb_MouseDown, 
							      cb_MouseUp,
							      cb_MouseMove,
							      cb_MouseMotion,
							      cb_EnterFocus,
							      cb_LeaveFocus,
							      cb_Redraw,
							      cb_Resize)
		return

	def InitAfter_AddPane(self, win):
		self.vDC=v.vCanvasPane_GetDC(self.Pane)
		return

	def ShowPane(self, OnOrOff):
		return v.vCanvasPane_ShowPane(self.Pane, OnOrOff)


	def SetWidthHeight(self, width, height):
		return v.vCanvasPane_SetHeightWidth(self.Pane, width, height)

	def SetCursor(self, id):
		return v.vCanvasPane_SetCursor(self.Pane, id)

	def GetCursor(self):
		return v.vCanvasPane_GetCursor(self.Pane)

	def UnSetCursor(self):
		return v.vCanvasPane_UnSetCursor(self.Pane)


	def ShowHScroll(self, OnOrOff):
		return v.vCanvasPane_ShowHScroll(self.Pane, OnOrOff)

	def ShowVScroll(self, OnOrOff):
		return v.vCanvasPane_ShowVScroll(self.Pane, OnOrOff)

	def SetHScroll(self, Shown, Top):
		return v.vCanvasPane_SetHScroll(self.Pane, Shown, Top)

	def SetVScroll(self, Shown, Top):
		return v.vCanvasPane_SetVScroll(self.Pane, Shown, Top)

	def GetHScroll(self):
		return v.vCanvasPane_GetHScroll(self.Pane)

	def GetVScroll(self):
		return v.vCanvasPane_GetVScroll(self.Pane)

	def GetWidth(self):
		return v.vCanvasPane_GetWidth(self.Pane)

	def GetHeight(self):
		return v.vCanvasPane_GetHeight(self.Pane)

	def GetDC(self):
		return v.vCanvasPane_GetDC(self.Pane)






##################################################################################
#		              vTextCanvasPane
##################################################################################
class vTextCanvasPane(vCanvasPane):
	def __init__(self,
		     cb_MouseDown=None,
		     cb_MouseUp=None,
		     cb_MouseMove=None,
		     cb_HPage=None,
		     cb_VPage=None,
		     cb_HScroll=None,
		     cb_VScroll=None,
		     cb_ResizeText=None,
		     cb_Redraw=None
		):

	         self.Pane=v.vTextCanvasPane_Constructor(cb_MouseDown,
		    					cb_MouseUp,
							cb_MouseMove,
		     					cb_HPage,
							cb_VPage,
		     					cb_HScroll,
		     					cb_VScroll,
							cb_ResizeText,
							cb_Redraw)
		 return


	def InitAfter_AddPane(self, win):
		self.vDC=v.vCanvasPane_GetDC(self.Pane)
		return


	def ShowHScroll(self, OnOrOff):
		return v.vTextCanvasPane_ShowHScroll(self.Pane, OnOrOff)

	def ShowVScroll(self, OnOrOff):
		return v.vTextCanvasPane_ShowVScroll(self.Pane, OnOrOff)

	def SetHScroll(self, Shown, Top):
		return v.vTextCanvasPane_SetHScroll(self.Pane, Shown, Top)

	def SetVScroll(self, Shown, Top):
		return v.vTextCanvasPane_SetVScroll(self.Pane, Shown, Top)

	def Clear(self):
		return v.vTextCanvasPane_Clear(self.Pane)

	def ClearRow(self, row, col):
		return v.vTextCanvasPane_ClearRow(self.Pane, row, col)

	def ClearToEnd(self, row, col):
		return v.vTextCanvasPane_ClearToEnd(self.Pane, row, col)

	def GetCols(self):
		return v.vTextCanvasPane_GetCols(self.Pane)

	def GetRows(self):
		return v.vTextCanvasPane_GetRows(self.Pane)

	def GetRC(self):
		return v.vTextCanvasPane_GetRC(self.Pane)

	def GotoRC(self, row, col):
		return v.vTextCanvasPane_GotoRC(self.Pane, row, col)

	def DrawAttrText(self, text, attr):
		return v.vTextCanvasPane_DrawAttrText(self.Pane, text, attr)

	def DrawChar(self, chr, attr):
		return v.vTextCanvasPane_DrawChar(self.Pane, chr, attr)

	def DrawText(self, text):
		return v.vTextCanvasPane_DrawText(self.Pane, text)

	def HideTextCursor(self):
		return v.vTextCanvasPane_HideTextCursor(self.Pane)

	def ShowTextCursor(self):
		return v.vTextCanvasPane_ShowTextCursor(self.Pane)

	def ScrollText(self, count):
		return v.vTextCanvasPane_ScrollText(self.Pane, count)

	def ResizeText(self, rows, cols):
		return v.vTextCanvasPane_ResizeText(self.Pane, rows, cols)

	def TextMouseDown(self, row, col, button):
		return v.vTextCanvasPane_TextMouseDown(self.Pane, row, col, button)

	def TextMouseUp(self, row, col, button):
		return v.vTextCanvasPane_TextMouseUp(self.Pane, row, col, button)

	def TextMouseMove(self, row, col, button):
		return v.vTextCanvasPane_TextMouseMove(self.Pane, row, col, button)

	def Redraw(self, x, y, width, height ):
		return v.vTextCanvasPane_Redraw(self.Pane, x, y, width, height)



##################################################################################
#		              vStatusPane
##################################################################################

class vStatusPane:
	def __init__(self,StatusList):
		self.Pane=v.vStatusPane_Constructor(StatusList)
		return
		

	def InitAfter_AddPane(self, win):
		return





##################################################################################
#		              vMemoryDC
##################################################################################
class vMemoryDC(vDC):
	def __init__(self, width, height):
		self.memDC=v.vMemoryDC_Constructor(width, height)
		self.vDC=self.memDC
		return 

	def __del__(self):
		v.vMemoryDC_Destructor(self.memDC)


##################################################################################
#		              vPrintDC
##################################################################################
class vPrintDC(vDC):
	def __init__(self):
		self.printDC=v.vPrintDC_Constructor()
		self.vDC=self.printDC
		return 

	def __del__(self):
		v.vPrintDC_Destructor(self.printDC)

##################################################################################
#		              vPrinter
##################################################################################
class vPrinter     :
	def __init__(self):
		self.printer=v.vPrinter_Constructor()
		return 

	def __del__(self):
		v.vPrinter_Destructor(self.printer)

	def Setup(self, file=""):
		v.vPrinter_Setup(self.printer, file)


##################################################################################
#		              vYNReplyDialog
##################################################################################
def vYNReplyDialog(win, msg):
		
		return v.vYNReplyDialog(win, msg)



##################################################################################
#		              vTimer
##################################################################################
class vTimer:
	def __init__(self, cb_TimerTick):
		self.timer=v.vTimer_Constructor(cb_TimerTick)
		return

	def __del__(self):
		v.vTimer_Destructor(self.timer)
	
	def TimerSet(self, interval ):
		return v.vTimer_TimerSet(self.timer, interval)

	def TimerStop(self):
		return v.vTimer_TimerStop(self.timer)



##################################################################################
#		              vFileSelect
##################################################################################
def vFileSelect(win,
		prompt,
		filename,
		maxLen, 
		filterList,
		filterIndex):
                rez =v.vFileSelect(win.win,
				   prompt,
				   filename,
				   maxLen, 
				   filterList,
				   filterIndex)
		return rez


##################################################################################
#		              vFileSelectSave
##################################################################################
def vFileSelectSave(win,
		prompt,
		filename,
		maxLen, 
		filterList,
		filterIndex):
	
	return v.vFileSelectSave(win.win,
				 prompt,
				 filename,
				 maxLen, 
				 filterList,
				 filterIndex)

##################################################################################
#		              vFontSelect  
##################################################################################
def vFontSelect(win, font, msg=""):
	
	(rez, font.font)=v.vFontSelect(win.win, font.font, msg)
	return(rez, font)


##################################################################################
#		              vNoticeDialog
##################################################################################
def vNoticeDialog(win, prompt):
	
	v.vNoticeDialog(win.win, prompt)


##################################################################################
#		              vReplyDialog
##################################################################################
def vReplyDialog(win, prompt, maxLen):
	
	return v.vReplyDialog(win.win, prompt, maxLen)





##################################################################################
#		              vDialog
##################################################################################
class vDialog:
	def __init__(self,
		     win,
		     cb_DialogCommand
		):

	         self.dialog=v.vDialog_Constructor(win.win,
							cb_DialogCommand)
		 return

	def __del__(self):
		v.vDialog_Destructor(self.dialog)
	

	def AddDialogCmds(self, cList):
		return v.vDialog_AddDialogCmds(self.dialog, cList)

	def SetDialogTitle(self, title):
		return v.vDialog_SetDialogTitle(self.dialog, title)

	def CancelDialog(self):
		return v.vDialog_CancelDialog(self.dialog)

	def CloseDialog(self):
		return v.vDialog_CloseDialog(self.dialog)

	def GetDialogPosition(self):
		return v.vDialog_GetDialogPosition(self.dialog)

	def GetTextIn(self, Id):
		return v.vDialog_GetTextIn(self.dialog, Id)

	def GetValue(self, Id):
		return v.vDialog_GetValue(self.dialog, Id)

	def IsDisplayed(self):
		return v.vDialog_IsDisplayed(self.dialog)

	def SetDialogPosition(self, top, left):
		return v.vDialog_SetDialogPosition(self.dialog, top, left)

	def SetValue(self, Id, Val, type):
		return v.vDialog_SetValue(self.dialog, Id, Val, type)

	def SetString(self, Id, String):
		return v.vDialog_SetString(self.dialog, Id, String)

	def ShowDialog(self, msg=""):
		return v.vDialog_ShowDialog(self.dialog, msg)


##################################################################################
#		              vModalDialog
##################################################################################
class vModalDialog:
	def __init__(self,
		     win,
		     cb_DialogCommand
		):

	         self.modal=v.vModal_Constructor(win.win,
							cb_DialogCommand)
		 return

	def __del__(self):
		v.vModal_Destructor(self.modal)

	def AddDialogCmds(self, cList):
		return v.vModal_AddDialogCmds(self.modal, cList)

	def SetDialogTitle(self, title):
		return v.vModal_SetDialogTitle(self.modal, title)

	def CancelDialog(self):
		return v.vModal_CancelDialog(self.modal)

	def CloseDialog(self):
		return v.vModal_CloseDialog(self.modal)

	def GetDialogPosition(self):
		return v.vModal_GetDialogPosition(self.modal)

	def GetTextIn(self, Id):
		return v.vModal_GetTextIn(self.modal, Id)

	def GetValue(self, Id):
		return v.vModal_GetValue(self.modal, Id)

	def IsDisplayed(self):
		return v.vModal_IsDisplayed(self.modal)

	def SetDialogPosition(self, top, left):
		return v.vModal_SetDialogPosition(self.modal, top, left)

	def SetValue(self, Id, Val, type):
		return v.vModal_SetValue(self.modal, Id, Val, type)

	def SetString(self, Id, String):
		return v.vModal_SetString(self.modal, Id, String)

	def ShowDialog(self, msg=""):
		return v.vModal_ShowDialog(self.modal, msg)

	def ShowModalDialog(self, msg=""):
		return v.vModal_ShowModalDialog(self.modal, msg)


##################################################################################
#		              vIcon
##################################################################################
class vIcon:

	def __init__(self, filename):
		self.filename=filename
		(self.icon, self.memsize, self.height, self. width, self.depth)=v.vIcon_Constructor(filename)
		return

	def __del__(self):
		v.vIcon_Destructor(self.icon)


##################################################################################
#		              vFont
##################################################################################
class vFont:

	def __init__(self, fam=vfDefaultFixed, size=10, sty=vfNormal, wt=vfNormal, und=0):
		self.font=v.vFont_Constructor(fam, size, sty, wt, und)
		return

	def __del__(self):
		return v.vFont_Destructor(self.font)
	
	def GetFamily(self):
		return v.vFont_GetFamily(self.font)

	def GetPointSize(self):
		return v.vFont_GetPointSize(self.font)

	def GetStyle(self):
		return v.vFont_GetStyle(self.font)

	def GetWeight(self):
		return v.vFont_GetWeight(self.font)

	def GetUnderlined(self):
		return v.vFont_GetUnderlined(self.font)

	def SetFontValues(self, 
			  fam=vfDefaultFixed, 
			  size=10, 
			  sty=vfNormal, 
			  wt=vfNormal, 
			  und=0):
		return v.vFont_SetFontValues(self.font, fam, size, sty, wt, und)


##################################################################################
#		              vFontEmpty
##################################################################################
class vFontEmpty(vFont):
	def __init__(self):
		return

	def __del__(self):
		d=dir(self)
		if 'font' in d:
			vFont.__del__(self)

	

##################################################################################
#		              vBrush
##################################################################################
class vBrush:

	def __init__(self, r, g, b, style=vSolid, fillMode=vAlternate):

		self.brush=v.vBrush_Constructor(r, g, b, style, fillMode)
		return

	def __del__(self):
		return v.vBrush_Destructor(self.brush)
	
	def GetColor(self):
		color=vColorEmpty()
		color.color=v.vBrush_GetColor(self.brush)
		return color

	def GetFillMode(self):
		return v.vBrush_GetFillMode(self.brush)

	def GetStyle(self):
		return v.vBrush_GetStyle(self.brush)

	def SetColor(self, color):
		return v.vBrush_SetColor(self.brush, color.color)

	def SetFillMode(self, fillMode):
		return v.vBrush_SetFillMode(self.brush, fillMode)

	def SetStyle(self, style):
		return v.vBrush_SetStyle(self.brush, style)


##################################################################################
#		              vBrushEmpty
##################################################################################
class vBrushEmpty(vBrush):
	def __init__(self):
		return

	def __del__(self):
		d=dir(self)
		if 'brush' in d:
			vBrush.__del__(self)




##################################################################################
#		              vColor
##################################################################################
class vColor:

	def __init__(self, r=0, g=0, b=0):

		self.color=v.vColor_Constructor(r, g, b)
		return

	def __del__(self):
		return v.vColor_Destructor(self.color)
	
	def BitsOfColor(self):
		return v.vColor_BitsOfColor(self.color)
	
	def ResetColor(self, r=0, g=0, b=0):
		return v.vColor_ResetColor(self.color, r, g, b)
	
	def Set(self, r=0, g=0, b=0):
		return v.vColor_Set(self.color, r, g, b)
	
	def SetR(self, r=0):
		return v.vColor_SetR(self.color, r)
	
	def SetG(self, g=0):
		return v.vColor_SetG(self.color, g)
	
	def SetB(self, b=0):
		return v.vColor_SetB(self.color, b)
	
	def r(self):
		return v.vColor_r(self.color)
	
	def g(self):
		return v.vColor_g(self.color)
	
	def b(self):
		return v.vColor_b(self.color)
	

##################################################################################
#		              vColorEmpty
##################################################################################
class vColorEmpty(vColor):
	def __init__(self):
		return

	def __del__(self):
		d=dir(self)
		if 'color' in d:
			vColor.__del__(self)




##################################################################################
#		              vPen
##################################################################################
class vPen:

	def __init__(self, r=0, g=0, b=0, width=1, style=vSolid):

		self.pen=v.vPen_Constructor(r, g, b, width, style)
		return

	def __del__(self):
		return v.vPen_Destructor(self.pen)

	def GetColor(self):
		color=vColorEmpty()
		color.color=v.vPen_GetColor(self.pen)
		return color
	
	def GetStyle(self):
		return v.vPen_GetStyle(self.pen)
	
	def GetWidth(self):
		return v.vPen_GetWidth(self.pen)
	
	def SetColor(self, color):
		return v.vPen_SetColor(self.pen, color.color)
	
	def SetStyle(self, style):
		return v.vPen_SetStyle(self.pen, style)
	
	def SetWidth(self, width):
		return v.vPen_SetWidth(self.pen, width)
	


##################################################################################
#		              vPenEmpty
##################################################################################
class vPenEmpty(vPen):
	def __init__(self):
		return

	def __del__(self):
		d=dir(self)
		if 'pen' in d:
			vPen.__del__(self)




##################################################################################
#		              vTextEditor
##################################################################################
class vTextEditor:

	def __init__(self, 
		     win,
		     cb_ChangeLoc=None,
		     cb_ChangeInsMode=None,
		     cb_StatusMessage=None,
		     cb_ErrorMsg=None,
		     cb_EditKeyIn=None
		     ):

		self.edt=v.vTextEditor_Constructor(win.win,
						   cb_ChangeLoc,
						   cb_ChangeInsMode,
						   cb_StatusMessage,
						   cb_ErrorMsg,
						   cb_EditKeyIn
						   )
		self.Pane=self.edt
		return

	def InitAfter_AddPane(self, win):
		self.vDC=v.vCanvasPane_GetDC(self.Pane)
		return


	def __del__(self):
		return v.vTextEditor_Destructor(self.edt)
	
	def resetBuff(self):
		return v.vTextEditor_resetBuff(self.edt)

	def addLine(self, line):
		return v.vTextEditor_addLine(self.edt, line)

	def getFirstLine(self):
		return v.vTextEditor_getFirstLine(self.edt)

	def getNextLine(self):
		return v.vTextEditor_getNextLine(self.edt)

	def getLine(self, lineNum):
		return v.vTextEditor_getLine(self.edt, lineNum)

	def displayBuff(self, lineNum):
		return v.vTextEditor_displayBuff(self.edt, lineNum)

	def EditCommand(self, id, val):
		return v.vTextEditor_EditCommand(self.edt, id, val)

	def EditKeyIn(self, key, shift):
		return v.vTextEditor_EditKeyIn(self.edt, key, shift)





##################################################################################
#		              vDebugDialog
##################################################################################
class vDebugDialog:

	def __init__(self, win):
		self.dbg=v.vDebugDialog_Constructor(win.win)
		return

	def __del__(self):
		return v.vDebugDialog_Destructor(self.dbg)
	

	def SetDebug(self):
		return v.vDebugDialog_SetDebug(self.dbg)
	
	def DialogCommand(self, id, val, ctype):
		return v.vDebugDialog_SetDebug(self.dbg, id, val, ctype)
	


	
##################################################################################
##################################################################################
##################################################################################

##################################################################################
#		              pyv_UNX_XtAddInput
##################################################################################
class pyv_UNX_XtAddInput:
    def __init__(self, cb_Func=None, file=None, fileno=0):

	if fileno==0:
		self.fileno=file.fileno()
	else:
		self.fileno=fileno

	self.id=v.pyv_X11_XtAppAddInput(cb_Func, self.fileno)

    def __del__(self):
	return v.pyv_X11_XtRemoveInput(self.id)



##################################################################################
#		              pyv_W95_WSAAsyncSelect
##################################################################################
def pyv_W95_WSAAsyncSelect(sock, win, wMsg, lEvent):
#
#  wMsg must be WM_USER + nn
#  lEvent or of following bits:
#                FD_READ, FD_WRITE, FD_OOB, FD_ACCEPT, FD_CONNECT, FD_CLOSE
#
	return v.pyv_W95_WSAAsyncSelect(sock, win.win, wMsg, lEvent)



##################################################################################
#		              pyv_W95_WSAGetLastError
##################################################################################
def pyv_W95_WSAGetLastError():
	return v.pyv_W95_WSAGetLastError()



##################################################################################
#		              pyvTraceFileOpen
##################################################################################
def pyvTraceOpen(filename):
	v.pyvTraceFileOpen(filename)


##################################################################################
#		              pyvTraceFileClose
##################################################################################
def pyvTraceClose():
	v.pyvTraceFileClose()



##################################################################################
#		              pyvTraceFileFlush
##################################################################################
def pyvTraceFlush():
	v.pyvTraceFileFlush()



##################################################################################
#		              pyvTraceFileFlushMode
##################################################################################
def pyvTraceFlushMode(OnOff):
	v.pyvTraceFileFlushMode(OnOff)



##################################################################################
#		              pyvDisplayTraceWindow()
##################################################################################
def pyvDisplayTraceWindow():
	v.pyvTrace_Display()



##################################################################################
#		              pyv_W95_SendMessage
##################################################################################
def pyv_W95_SendMessage(win, msg, wParam, lParam):
	return v.pyv_W95_SendMessage(win.win, msg, wParam, lParam)
	






