#!/usr/bin/python


PLUGIN_SERVER_GID = "0"

# -- include library classes
from gdtm import *


"""
	A collection of tasks used to setup
	a plugin architecture on a group of
	sites. The architecture is built on 
	the Paos client/server database which
	houses plugin objects as well as 
	statistical data on the dependancy 
	files that the plugin needs.
	
	The plugin server is itself a resident 
	task that sits on top of the gdtm server.
	The pluginServer manages all plugins and 
	depandancy files.
	
	There is an assumed directory structure
	used by the plugins. This is to ensure
	that depandant modules and plugins are
	put in a place where PYTHONPATH can find
	them.
	
	agents/plugin - house plugin modules
	agents/plugin/dependancies/<pluginName> - 
		house files that the plugins are
		depandant on.
"""

def getClassAndName(x):
	import strop
	x = strop.split( str(x) )[0]
	# go past the '<' character
	list = strop.splitfields(x[1:],".")
	return (list[0], list[1])

# successfull completion of task
class success(task):
	def __init__(self, gid=None, sender=None, taskname="", data=None):
		task.__init__(self, gid)
		self.data = data
		self.taskname = taskname
		self.sender = sender
		
	def destinations(self):
		return [self.sender]
	
	def call(self, resTask):
		resTask.success(self.taskname, self.data)

# failure in task
class failure(task):
	def __init__(self, gid=None, sender=None, taskname="", data=None):
		task.__init__(self, gid)
		self.data = data
		self.taskname = taskname
		self.sender = sender
		
	def destinations(self):
		return [self.sender]
	
	def call(self, resTask):
		resTask.failure(self.taskname, self.data)

# see if a plugin exists and if it does return it
class loadPlugin(task):
	def __init__(self, gid=None, senderId = None, name = None, docName=None):
		if gid == None: return

		print gid
		task.__init__(self, gid)
		
		self.name = name
		self.senderId = senderId
		self.docName = docName
		
	# lookup plugin in the archive
	def call(self, resTask):
		self.c = resTask.lookup(self.name)
		
	# send plugin back to server
	def next(self):
		if self.c == None:
			p = failure(self.gid, self.senderId,"loadPlugin","Failed to load %s" % (self.name))
		else:
			p = success(self.gid, self.senderId,"loadPlugin",(self.getId(),self.c,self.docName))		
		return p

# plugin record
class record:
	def __init__(self, plugin = None):
		if plugin == None: return	
		(cn,on) = getClassAndName(plugin)
				
		# cacoon object
		c = cacoon(plugin,cn,on)		

		# create attributes 
		self.__name__ = plugin.nameOf()
		self.__version__ = plugin.version()
		self.__deleted__ = 0

		# add cacooned plugin
		self.__plugin__ = c

# add a plugin to the archive
class addPlugin(task):
	def __init__(self, gid=None, sender=None, plugin = None):
		if plugin == None: return
		
		task.__init__(self, gid)
		self.sender = sender
		self.db = record(plugin)

		
	def call(self, resTask):
		self.x = resTask.addPlugin(self.db)
	
	# return response		
	def next(self):
		if self.x == false:
			msg = "Unable to add plugin name '%s'" % (self.db.__name__)
			return failure(self.localhost,"addPlugin",msg)
		return success(self.localhost,"addPlugin",self.db.__name__)


# -- simple task that calls the createPluginServer

# send an obj from the XMLFactory
class plugin_tag(task):
	def __init__(self, obj=None, level=None, xmlfile=None):
		task.__init__(self, PLUGIN_SERVER_GID)
		self.obj = cacoon(obj)
		self.xmlfile = xmlfile
		self.level = level
	def call(self, ps):
		ps.plugin_tag( self.obj.unpickle(), self.level, self.xmlfile )
	
# execute plugins
class ExecDoc(task):
	def __init__(self, docName = None):
		task.__init__(self, PLUGIN_SERVER_GID)
		self.docName = docName
	def call(self, ps):
		ps.execDoc( self.docName )
		


# create a pluginRepository
class createPluginSystem(task):
	def __init__(self, xmlfile=None):
		task.__init__(self, PLUGIN_SERVER_GID )
		self.xmlfile = xmlfile

	# create a system of plugins using an xml file
	# as a template
	def call(self, ps):
		ps.createPluginSystem( self.xmlfile )

# at the end call each of the plugin's execute methods
class endDoc(task):
	def __init__(self, docname=None, cnt=None):
		task.__init__(self, PLUGIN_SERVER_GID )
		self.docname = docname
		self.cnt = cnt
	def call(self, ps):
		ps.endDoc( self.docname, self.cnt )


# have the server process kill a child task
class killTask(task):
	def __init__(self, pid=None):
		task.__init__(self)
		self.pid = pid
	def call(self, ps):
		import os
		os.system("kill -SIGTERM %d" % (self.pid))
								
# main task, goes resident and never dies until the server
# dies.
class pluginServer(resident):
	def __init__(self, gid=None, dbname="vars/plugin.odb"):
		resident.__init__(self, gid)
		# each document processed has a set of plugins
		# associated with it. This table contains all
		# active documents on this site.
		self.docTable = {}
		self.dbname = dbname
		self.cnt = 0
		self.eofHandler = false

	# setup shop on the server	
	def call(self, pServer):	
		print "pluginServer.call"

		global archive
		archive = shelve.open(self.dbname)

			
	def getParent(self, docName, id):
		p = self.docTable[docName].getParent(id)		
		if p != None:
			self.docTable[docName][id].interput( p )	
			
	#---- api used other tasks that come in -----
	def plugin_tag(self, obj, level, docName):
		self.docTable[docName].query( obj, level )

	def execDoc(self, docName):
		self.docTable[docName].execute()
		
	def eod(self, docName):
		try:
			if self.docTable[docName].__last__ == self.docTable[docName].__cnt__:
				from dtm import send, cacoon
				t = ExecDoc(docName)
				x = cacoon(t)
				send( x )
		except:
			pass
	# called when the end of the document has been reached
	def endDoc(self, docName, last):
		# execute all plugins
		print "endDoc"

		self.docTable[docName].__last__ = last
		# set handler for when we have processed the last tag
		self.eofHandler = true
		self.eod( docName ) 		


	#*****
	# This is the entry point that creates the plugin
	# system.
	# uses an xml file to create a system of plugins
	def createPluginSystem(self, xmlfile):
		import pluginRepository
		# maintains active plugins
		pluginRepository = pluginRepository.repository(xmlfile)
		
		# mark this class with docname
		docname = pluginRepository.getDocName()
		
		# add to document table
		self.docTable[ docname ] = pluginRepository
					
	# add a plugin to the archive
	def addPlugin(self, db):
		global archive	
		archive[ db.__name__ ] = db
		return true
		
	# return all plugin records in archive
	def values(self):
		v = []
		global archive 
		for k in archive.keys():
			v.append( archive[ k ] )
		return v

	# load a plugin based on name,if more than one 
	# choose the one with the highest version
	# if none found returns None
	def lookup(self, name):
		print "pluginServer.lookup"

		proplist = [("__name__","==",name),("__deleted__","==",0)]

		from gdtm import query
		values = []
		list = query( proplist, self.values() )

		if len(list) == 0: 
			print "plugin.__name__ ",name," not found"
			return None
		
		# get the plugin with the highest version
		maxversion = 0.0
		maxI = None
		
		for i in list:
			v = i.__version__
			if v > maxversion:
				maxI, maxversion = i, v	
		
		# unpickle plugin
		print "returning from pluginServer.lookup"
		return i.__plugin__.unpickle()
		
	# delete a plugin
	def delPlugin(self, p):
		proplist = [("__name__","==",p.nameOf()),("__version__","==",p.version())]
		list = query( proplist, self.values() )
		global archive
		del archive[ list[0].__name__ ]
		
	# failure and success interupts	
	def failure(self, taskname, data):
		pass
		
	def success(self, taskname, data):
		if   taskname == "loadPlugin":
			print "success: self.pluginRepository.process( data )"
			docName = data[2]
			if not hasattr(self.docTable[docName],"__cnt__"):
				self.docTable[docName].__cnt__ = 1
			else:
				self.docTable[docName].__cnt__ = self.docTable[docName].__cnt__	+ 1
			# process that new plugin
			self.docTable[docName].process( data )
			if self.eofHandler == true:
				self.eod(docName)
		elif taskname == "addPlugin":	
			print "Plugin ",data," succesfully added"
		elif taskname == "qr_results":
			print data
		else:
			print "Unknown task name",taskname	
			
# temporary resident that queries all residents in
# a web site then returns the results		

# another temp resident
class qr_results(resident):
	def __init__(self, owner=None,results=None):
		resident.__init__(self)
		self.owner=None
		self.results
		
	def destinations(self):
		return [self.owner]
		
	def call(self, gs):
		gs.success("qr_results", self.results)
	
# temporary resident so I can speek to the server
class queryResidents(resident):
	def __init__(self, sender=None, proplist=None):
		resident.__init__(self)
		self.sender = sender
		self.proplist = proplist
	
	def call(self, gs):
		self.result = gs.queryResidents(self.proplist)
		
	def next(self):
		# after spawning child die.
		self.kill()
		return qr_results(self.sender,self.result)
		
