#!/usr/bin/python

"""
	The plugin repository uses an xml file
	to generate plugin objects. This repository 
	sits inside a special resident task that
	communicate to a a datbase of plugins.
	
	The respository mearly hold the plugins.
	Each plugin is stored along with a "level"
	number. This allows for plugins to be children 
	of one another.
		For example, given an XML file:

			
	<window title="test">
		<toolbar>
			<button name=b1 caption="mybutton"/>
			<button name=b1 caption="another"/>
		<toolbar/>
	<window/>		
	
	Would create a list of plugins like this
			
	level, plugin name
	------------------		
	(0, window)
	(1, toolbar)
	(2, button)
	(2, button)		
	
	It is the job of the repository to create this
	list structure based on an xml file. Then call
	each of the plugin calsses execute methods
	will be called.

"""

from pluginServer import failure, success, PLUGIN_SERVER_GID, killTask
from XMLClient import ClientBase
false,true = 0,1


# a little sloppy but it is not frequently called
# it behaves like splitpath, only its portable.
def fname(p):
        import regex

        def strrev(x):
                i,r = len(x)-1,""
                while i >= 0:
                        r = r + x[i]
                        i = i - 1
                return r


        x = regex.compile("\([a-zA-Z_.0-9]+\)")
        p = strrev(p)
        l = x.match(p)
        p = p[:l]
        return strrev(p)



# a place where plugins live
class repository:
	def __init__(self, docName=None):
#		ClientBase.__init__(self)
		# a table used to map an interupt to
		# a message
		self.msgTable = {}
		# where the plugins live
		self.pluginTable = {}
		# perserves the order of plugins as they are
		# inserted.
		self.idList = []
		
		self.docName = docName
		self.cnt = 0

	def getDocName(self):
		return self.docName

	# query database
	def query(self, obj, level):
		from dtm import send
		from pluginServer import loadPlugin		

		m = loadPlugin(PLUGIN_SERVER_GID,"", obj.nameOf(), self.docName)

		import os, cPickle	
		# save id and xml entity object		
		os.environ[ m.getId() ] = cPickle.dumps( (obj, level) )

		# dispatch message and handle interupt
		print "sending loadPlugin message to pluginServer"
		send( m )
		
	
	# --- api for pluginServer ---------------	
	
	def do_execute(self, k):
		self.pluginTable[k][1].execute()

	def execute(self):
		print "execute"

		# Activate plugins	

		# -- choose multitasking over multithreading if possible.
		mode = "NoMultitask"
		try:
			import thread
			mode = "thread"
		except:
			try:
				import os
				os.fork
				mode = "fork"
			except:
				pass
	

		for k in self.pluginTable.keys():
			if   mode == "NoMultitask":
				self.pluginTable[k][1].execute()
			elif mode == "fork":	
				import os
				if os.fork() == 0:
					# inside child process
					self.do_execute(k)
			else:
				import thread
				thread.start_new( self.do_execute, (k,))

			
	# process a plugin
	# add it to the pluginTable
	def process(self, data):
		# get the interupt id
		id = data[0]
		newPlugin = data[1]
		docName = data[2]

		import os, cPickle
		(obj, level) = cPickle.loads( os.environ[ id ] )
		
		# test to see if attributes in tag
		# are valid
		(r, why) = newPlugin.isValid(obj)
		if r == false:
			print why
			return false

		# embedd information into plugin
		newPlugin.__pluginId__ = id
		newPlugin.__docName__ = docName

		# add plugin to table
		self.pluginTable[ id ] = (level, newPlugin)
		self.idList.append(id)
		
		# delete message
		del os.environ[ id ]

		print "succesfully added plugin"	
		return true
		
	#----------------------------------------	
	#--       api for agent tasks          -- 
	#----------------------------------------
	
	# get the plugin that corresponds to the parent
	# tag
	def getParent(self, id):
		import strop

		# get plugin level
		level = self.pluginTable[id][0]
		
		i = self.idList.index( id )
		while i > 0:
			i = i - 1
			# get the id based on postion
			id = self.idList[i]
			
			if self.pluginTable[id][0] < level:
				return self.pluginTable[id][1] 
		
		# cout backwards until the level
		# number decreases 
		#while strop.atoi(id) > 0:
		#	id = "%d" % (strop.atoi(id) - 1)
		#	if self.pluginList[id][0] < level:
		#		return self.pluginList[id][1] 
		
		return None
		
	# peforms a query on a group of plugins			
	def getPluginByAttr(self, proplist):
		from gdtm import query
		list = []
		for (level,plugin) in self.pluginTable.values():
			list.append(plugin)
		return query(proplist, list)
		
		
			
			





