#!/usr/bin/python


"""
	A generic interface for an object.
	
	Allows for other plugins to communicate 
	with one another using agents. The
	entire network is hidden from end user.
	
	* Plugins send messages and recieve 
	  interupts
"""

false,true=0,1
nameOfNotOverloaded = "plugin.nameOfNotOverloaded"



# base class for all plugins
class plugin:
	def __init__(self):
		# test to see if user overloaded method
		self.nameOf()
		self.cbtable = {}
			
	# version number; mantessa is the major, decimal	
	# portion is the minor.
	def version(self):
		return 0.0
		
	# must be supplied by derived class
	def nameOf(self):
		raise nameOfNotOverloaded, "You must supply a nameOf() method!"
		
	# is the tag in the xml file that corresponds to
	# this class valid ?
	def isValid(self, obj):
		return (true, "")			
		
	# This is what does the user defined work for this
	# object	
	def execute(self):
		pass	
		
	# all incoming agents	
	def interupt(self, agent):
		if self.cbtable.has_key(agent.getId()):
			cb = self.cbtable[agent.getId()]
			cb( agent )
			del self.cbtable[agent.getId()]
			
	#	
	#-- api for derived class --------
	# 
	
	# -- all getXXX function return agents that how
	#    to get to the plugins in question
	
	# get the plugin that corresponds to the parent
	# tag
	def getParent(self, cb):
		from agent import getParent
		from dtm import send
				
		x = getParent(self)
		self.cbtable[ x.getId() ] = cb
		send( x )
			
	# peforms a query on a group of plugins			
	def getPluginByAttr(self, proplist, cb, documents = []):
		pass
		
	# searches network for all active documents.
	# These documents are xml files with thier plugin
	# represntations through the web. 	
	def getOpenedDocuments(self, filespec="*.*"):
		pass	
		
	# sends a message to a plugin via an agent
	# pass a callback function cb to handle a response
	def send(self, agent, cb):		
		pass

	# -- interupts recieved ------------
	def parent(self, agent):
		pass
		
	def puginByAttr(self, agent):
		pass
		
	def openDocuments(self, agent):
		pass		
		
	# -- error interupts
	def error(self, agent):
		pass
	
