#!/usr/bin/python



# use gdtm's task driven architecture
from gdtm import *

# for exception handling
import sys, os

# -- constants
BLOCK_SIZE = 1024 * 4


"""
	network file copy based on gdtm.
	
	* Error recovery
	* Ability to resume tasks after network
	  re-established
	* Fast
"""


# force unpickle to be called in this module
def mySend(rawData, dest):
	send( cacoon(rawData, "mftp", classname(rawData)), dest)


#*********************************************#
#------  main function for module ------------# 
#*********************************************#
# copy a file to one or more hosts to possibly 
# different locations on each host.
# spath - source path
# list  - list of (host,path) tuples. 
def mftp(src, spath, list):
#	s = source(gid,spath, list)
	s = jobMonitor(src,spath,list)
	mySend( s, [src])
	return s.groupId()


# sits at the local gdtm server and dispatches a
# source task. It is the duty of this task to monitor 
# the mftp job and log its findings to an environment
# variable which is called JOB_<groupId>
class jobMonitor(resident):
	def __init__(self,src=None,spath=None,list=None)
		resident.__init__(self)
		self.src,self.spath,self.list=src,spath,list
		
	def call(self, gdtmServer):	
		gdtmServer.shared[

	
	def next(self):
		return cacoon( source(self.groupId(),self.localhost,self.spath,self.list), [self.src] )
		
	def log(self, msg):
		

"""
	Client driven file copy. The current
	hype around this technique is called
	"push".
	

	Task1
		Open source file and dispatch
		task2 objects to destinations.
		
		* task1 sends different pieces
		  of the file different requesting
		  clients
		* When all destinations report done 
		  close file and terminate group.
		   
	Task2
		Request a 1k block of data from a 
		source file by using an offset number.
		When eof is reached task2 dies.

"""		

# callback sent to monitor for status
class status(task):
	def __init__(self, sgid =None, sa=None, errinfo=None, statinfo=None, jobGid=None):
		task.__init__(self, sgid)
		self.sa = sa
		self.errinfo = errinfo
		self.statinfo = statinfo
		self.jobGid = jobGid
		
	def destinations(self):
		return [self.sa]
		
	# report status and error information	
	def call(self, senderRes):
		if self.errinfo != None:
			senderRes.errorStat(self.jobGid, self.errinfo)
		if self.statinfo != None:
			senderRes.normStat(self.jobGid, self.statinfo)
		
# close file
class closeFile(task):
	def __init__(self,sender=None,gid=None):
		task.__init__(self, gid)
		self.sender = sender
		
	def destinations(self):
		return [self.sender]
		
	def call(self, destRes):
		self.destRes_id = destRes.getId()
		destRes.close()
		
	def next(self):
		return 		
		

# comes from source to write to destination
class incomingChunk(task):
	def __init__(self,sender=None,gid=None,data=None,num=None):
		task.__init__(self, gid)
		self.sender,self.data,self.num=sender,data,num
	
	def destinations(self):
		return [self.sender]
	
	def call(self, destRes):
#		 "incomingChunk.call()"
		destRes.writeChunk( self.num, self.data )
		self.nextT = destRes.next()
		
	def next(self):
		return self.nextT				
		
		
		
# failure from source
class failure(task):
	def __init__(self,sender=None,gid=None,msg):
		task.__init__(self, gid)
		self.sender,self.gid,self.msg=sender,gid,msg

	def destinations(self):
		return [self.sender]
		
	def call(self, destRes):
#		print "failure.call()"
		destRes.readFailure(self.msg)


# goes from destination to source to grab a block
class requestChunk(task):
	def __init__(self, sender=None, gid=None, src=None, num=None):
		task.__init__(self, gid)
		# the source of teh chunk
		self.src = src
		self.num = num
		# the destination of the chunk
		self.sender = sender		
		self.errMsg = ""
		
	def destinations(self):
		return [ self.src ]	
		
	# get one chunk of data	
	def call(self, srcRes):
#		print "requestChunk.call()"
		self.data = srcRes.chunk(self.num)
		if self.data == None:
			if srcRes.fileErr != "":
				self.errMsg = self.fileErr
			
	# send either data, or a request to close file.
 	# If an error send a message			
	def next(self):		
		if self.data != None:
			# send chunk back to destination
			r = incomingChunk(self.sender,self.gid,self.data,self.num)
		else:
			# if errMsg send error 
			if self.errMsg != "": 
				r = errmsg(self.sender,self.gid,self.errMsg)
			else:	
				# else close file
				r = closeFile(self.sender,self.gid)
		return r				
	
"""
	Base class of resident tasks for mftp.
	Handles exceptions from tasks
"""	
class mftpResident(resident):
	def __init__(self, gid=None, origin=None):
		resident.__init__(self, gid)
		self.error = false
		self.errinfo = None
		self.statinfo = {}
		self.origin = origin
	
	def exception(self, method):	
		self.errinfo = [sys.exc_type, sys.exc_value, method]	
		self.error = true

	# get a status task which describes that status
	# of this resident
	def report(self, monGid, dest, jobGid):
		return status(monGid,dest,self.errinfo,self.statinfo,jobGid)
				
# three states of a destination file				
OPENED,WRITING,CLOSED=0,1,2
		
		
"""
	The destination controls the copy operation.
	It issues requests for chunks of data then
	closes the file when done.
"""
class destination(mftpResident):
	def __init__(self, self.origin=None,senderhost = None, gid=None, host=None, path=None):
		# override gid generation
		mftpResident.__init__(self, gid)
		self.path = path
		self.host = host
		self.cnt = 0
		self.senderHost = senderhost
		mftpResident.statinfo["state"] = (None,None)
		self.origin = origin
		
	def destinations(self):
		return [ self.host ] 
		
	def call(self, gdtmMgr):
		try:
			import tempfile, shelve
			self.tfile = tempfile.mktemp()
			self.buffer = shelve.open( self.tfile )
			self.file = open(self.path,"w")
			
			# log current status
			mftpResident.statinfo["state"] = (OPENED, "")
		except:
			mftpResident.exception(self,"destination.call")		
		
	def next(self):
		r = requestChunk(self.localhost, self.gid, self.senderHost, self.cnt)
		self.cnt = self.cnt + 1						
		return r
				
	# write a block of data to a buffer			
	def writeChunk(self, num, data):
		try:
			self.buffer[ "%d" % (num) ] = data		
			# log current status
			mftpResident.statinfo["state"] = (WRITING, num)
		except:
			mftpResident.exception(self,"destination.writeChunk")
		
	# return a status task that is to be sent to
	# the monitor	
	def getStatus(self, sa):
		pass
		
	def __def__(self):
		try:
			self.file.close()
			self.buffer.close()
			import os
			os.remove( self.tfile )
		except:
			pass

		
	def close(self):
		try:
			for i in range(0, len(self.buffer)):
				data = self.buffer["%d" % (i)]
				self.file.write( data )
			self.kill()
			
			# log current status
			mftpResident.statinfo["state"] = (CLOSED, "")
		except:
			mftpResident.exception(self,"destination.close")
			
				

# 1st task. 
# Ensures file exists.
class source(mftpResident):
	def __init__(self, gid=None,origin=None,sfile=None, list=None):
		mftpResident.__init__(self, gid)
		self.sfile, self.list = sfile, list
		mftpResident.statinfo["completed"] = []
		self.origin = origin

	# grabs a chunk of text from an arbitrary
	# place
	def chunk(self, n):
		p = n * BLOCK_SIZE
		if p > self.size:
			return None
			
		try:
			# seek to position
			self.file.seek( p )
			# read chunk
			return self.file.read( BLOCK_SIZE )	
		except:
			mftpResident.exception(self, "source.chunk")
			return None	
			
	# entry function
	def call(self, gtmMgr):
		# open file
		try:
			self.file = open(self.sfile,"r+b")
			self.file.seek(0,2)	
			self.size = self.file.tell()
			self.file.seek(0)
		except:
			mftpResident.exception(self, "source.call")
			return

		self.result = true
		self.localhost = gtmMgr.localhost
		
	# next task
	def next(self):
		#print "source.next()"
		if self.result == false: return None
		rlist = []
		for (host,path) in self.list:
			d = destination(self.localhost, self.groupId(), host, path)
			rlist.append(d)
		return rlist			

		
				

if __name__ == "__main__":
	import sys
	
	p = len(sys.argv)
	if p < 4 or p % 2 == 1:
		print "Usage: mftp <source path> (<host1> <destination path1> ... <hostN> <destination pathN>)"
		sys.exit(0)
	else:
		spath = sys.argv[1]
		i, list = 2, []
		while i < p:
			host = sys.argv[i]
			path = sys.argv[i+1]
			
			i = i + 2
			list.append( host, path )
			
		# multicast copy	
		mftp(spath, list)
		
			
			
			
		
		
		
		
	
		














