#!/usr/bin/python


"""
	Interface for a java script view
	Allows for new tasks to be generated.
"""

import shelve

NEXT_JOB="__nj__"
MFTP_GID="1" 


# -- requests status of a mftp resident task
class requestStatus(task):
	def __init__(self, monGid=None, destGid=None,sa=None,jobId=None):
		task.__init__(destGid)
		self.sa = None
		self.monGid
		self.jobId = jobId
		
	def call(self, mftpRes):
		self.status = mftpRes.report(self.monGid,self.sa,self.jobId)
	
	# send status back to 
	def next(self):
		return self.status
	

FAULT,NOFAULT=0,1
	
# -- Monitors mftp jobs.
class mftpJobMgr(resident):
	def __init__(self):
		resident.__init__(self, MFTP_GID)

	def call(self, gdtmSever):
		self.db = shelve.open("vars/jobs.odb")
		
	def start(self, src, path, destList):
		from mftp import mftp
		jobGid = mftp(src,path,destList) 
		self.db[jobGid] = ((src,path,destList),(None))

	def poll(self):
		for k in self.db.keys():
			(jinfo,stat) = self.db[k]
						
	# updates of messages					
	def errorStat(self, jobGid, errinfo):
		(jinfo,stat) = self.db[jobGid]
		stat = (FAULT,errinfo)
		self.db[jobGid] = (jinfo,stat)
		
	def normStat(self, jobGid, statinfo):
		(jinfo,stat) = self.db[jobGid]
		stat = (NOFAULT,statinfo)
		self.db[jobGid] = (jinfo,stat)
		
	def jobEnd(self, jobGid):
		del self.db[jobGid]
				
	



	

	
