#!/usr/bin/python


from gdtm import *

# amount of bytes read from source file at once
BLOCKSIZE = 1024 * 1.5 

# -- transcient variables
MONGID   = "monGid"
MONLOC   = "monLoc"

SRCGID   = "srcGid"
SRCLOC   = "srcLoc"
SRCPATH  = "srcPath"

DESTINFO = "destInfo"
DESTGID  = "destGid"
DESTLOC  = "destLoc"
DESTPATH = "destPath"

FILESIZE = "filesize"
FILEPOS  = "filepos"
BLOCKNUM = "bocknum"
CHUNK    = "chunk"


# flag used for debugging
DEBUG=false



"""
	Base class for all residents. Provides
	error handling routines. Note that any
	or all residents may lie on the same machine 
	so they each generate a groupId that they
	must pass to each other in order to establish
	communication.
"""
class mftpResident(resident):
	def __init__(self, tr=None):
		# have resident generate its own gid
		resident.__init__(self)
		self.fobj = None
		self.tr = tr

	def addressChange(self, oldIp, newIp):
		for k in (MONLOC,SRCLOC,DESTLOC):		
			if self.tr.has_key(k):
				if self.tr[k] == oldIp:
					self.tr[k] = newIp

		
	# produce a failure task that navigates back to
	# the monitor to report an error	
	def error(self, msg=None):
		self.fobj = failure( self.tr[MONGID], self.tr[MONLOC], msg )	

		


"""
	The monitor starts the mftp process. It
	recieves status messages from the network
	and presents them to the end user.
"""
class monitor(mftpResident):
	def __init__(self, tr={}):
		mftpResident.__init__(self,tr)
	
								
		
	# report failure object
	def failure(self, fobj):	
		print "At ",fobj.localhost
		print fobj.exc_type
		print fobj.exc_value
		if fobj.msg != None:
			print fobj.msg

	# called when a destination completes a file copy
	def completed(self, tr):
		print "Copy from ",tr[SRCLOC]," to ",tr[DESTLOC]," complete."

	def progress(self, tr):
		filepos  = 1.0 * tr[FILEPOS]
		filesize = 1.0 * tr[FILESIZE]
		percent = filepos / filesize * 100.00
		
		print "Dest[",tr[DESTLOC],"] ",percent," percent finished"
		

	# spawns the source task which spawns the destination tasks.
	def next(self):
		if DEBUG == true: print "monitor.next"

		# the source task need to be able to find
		# this resident. 
		self.tr[MONGID] = self.groupId()
		self.tr[MONLOC] = self.localhost

		return source( self.tr )


		
		

"""
	Opens a source file and sends out the destination tasks.
	Each destination task will in an indeterminate order
	request chunks from this file
"""
class source(mftpResident):
	def __init__(self, tr={}):
		mftpResident.__init__(self, tr)
		# table of destinations which have copy jobs
		# active
		self.active_dest = {}
		

	def destinations(self):
		# take me to source location
		return [self.tr[SRCLOC]]	
		
	def call(self, gdtmServer):
		if DEBUG == true: print "source.call"
		try:
		
			# this is so the destinations know how 
			# to talk to this task.
			self.tr[SRCGID] = self.groupId()
			self.tr[SRCLOC] = self.localhost	

			srcfile = self.tr[SRCPATH]
			self.file = open(srcfile)	
	

			# determine file size
			self.file.seek(0,2)
			self.tr[FILESIZE] = self.file.tell()
			# reset file position

			self.file.seek(0)
		except:
			mftpResident.error(self)			

	def writeAcknowledge(self, destTr):
		# record status 
		self.active_dest[ destTr[DESTLOC] ] = destTr[BLOCKNUM]
		
	def completed(self, destTr):
		del self.active_dest[ destTr[DESTLOC] ]
		if len(self.active_dest) == 0:
			self.kill()		

	# extracts a chunk from a file at some random file position
	def requestChunk(self, destTr):
		offset = destTr[BLOCKNUM] * BLOCKSIZE
		if offset > destTr[FILESIZE]:
			return None
		else:
			#print self
			self.file.seek( offset )	
			return self.file.read( BLOCKSIZE )
	
	def next(self):
		if DEBUG == true: print "source.next"
		# if there is an error send the failure
		# object
		if self.fobj != None: return self.fobj

		# multicast destination task to copy file
		# accross the network.
		result = []
		for (destPath, destLoc) in self.tr[DESTINFO]:
			tr = self.tr
			#del tr[DESTINFO]
		
			tr[DESTPATH] = destPath
			tr[DESTLOC] = destLoc
			tr[BLOCKNUM] = 0
		
			d = destination( tr )

			# add to active list 
			self.active_dest[ destLoc ] = None

			# append to destination list			
			result.append( d )
			
		return result		





# opens a destination file.
# It is in charge of the copy. It sends requests 
# to the source resident for chunks of a file
# and posts status 
class destination(mftpResident):
	def __init__(self, tr={}):
		mftpResident.__init__(self, tr)

	def destinations(self):
		# use the position number to get
		# path and location
		# take to our destination	
		return [ self.tr[DESTLOC] ]
			
	def call(self, gdtmServer):
		if DEBUG == true: print "destination.call"
		try:
			# initial task is to create the file
			self.file = open(self.tr[DESTPATH],"w")
		except:
			mftpResident.error(self)			

	# deposit a chunk to a file then request next
	# chunk.
	def depositChunk(self, tr):
		if DEBUG == true:  print "destination.despositChunk"
	
		data = tr[CHUNK]

		# When we get a chunk 
		if data == None:
			# close file
			self.file.close()
			# kill ourselves
			self.kill()
			# send off a notification to 
			# monitor.
			return completed( tr )
		try:
			self.file.write(data)
			tr[FILEPOS] = self.file.tell()
			tr[BLOCKNUM] = tr[BLOCKNUM] + 1
		except:
			mftpResident.error(self)
			return self.fobj 
			
		return writeAcknowledge( tr )
			

	def next(self):
		if DEBUG == true: print "destination.next"
		# if there is an error send the failure
		# object
		if self.fobj != None: return self.fobj
		
		self.tr[DESTGID] = self.groupId()
		self.tr[DESTLOC] = self.localhost

		return requestChunk( self.tr )

# -- three tasks to provide a copy of a chunk from
# from source to destination
# 1) Destination issues a request to source
#     for a chunk of the file
# 2) Upon receipt a chunk is delivered
# 3) An acknowledge is sent to both source and monitor
#    to display status     
# repeat until 2 fails due to eof.

"""
	After a chunk is delivered go back to
	the source machine and notify it that 
	the chunk arrived.
"""
class writeAcknowledge(task):
	def __init__(self, tr=None):
		if tr == None: return
		
		task.__init__(self, tr[SRCGID])		
		self.tr = tr		

	def destinations(self):
		return [ self.tr[SRCLOC] ]

	def call(self, source):
		if DEBUG == true: print "writeAcknowledge.call"
		source.writeAcknowledge( self.tr )
		
	def next(self):
		if DEBUG == true: print "writeAcknowledge.next"
		# send both an other request an a
		# status message for monitor
		result = []
		
		result.append( progress(self.tr) )
		result.append( requestChunk(self.tr) )
		
		return result

import copy, marshal


"""
	After source recieves a request for a 
	chunk of the source file we send despositChunk
	which appends the chunk to the destination file.
"""
class depositChunk(task):
	def __init__(self, tr=None):
		if tr == None: return 
		task.__init__(self, tr[DESTGID])
		self.tr = tr
		
	def destinations(self):
		return [ self.tr[DESTLOC] ]
			
	def call(self, destination):
		if DEBUG == true: print "despositChunk.call"
		self.nextTask = destination.depositChunk( self.tr )
		# get rid a baggage 
		del self.tr[CHUNK]

	def next(self):
		if DEBUG == true: print "despositChunk.next"
		#print "self.nextTask = ", self.nextTask
		return self.nextTask
		
		
# task that goes from dest to source
class requestChunk(task):
	def __init__(self, tr=None):
		if tr == None: return

		task.__init__(self, tr[SRCGID])
		self.tr = tr
		
	def destinations(self):
		return [ self.tr[SRCLOC] ]	
		
	def call(self, source):
		if DEBUG == true: print "requestChunk.call"
		self.tr[CHUNK] = source.requestChunk( self.tr )	



		#from compress import *
		#cChunk = compress(chunk)
		#lpc_chunk = len(cPickle.dumps(cChunk))
		#lp_chunk = len(cPickle.dumps(chunk))
		#print lpc_chunk
		# if compressed the pickle length decreases
		#if  lpc_chunk < lp_chunk: 
		#	# store compressed
		#	self.tr[CHUNK] = (true, cChunk)
		#else:
		#	# store umcompressed
		#	self.tr[CHUNK] = (false, chunk)			

	def next(self):
		if DEBUG == true: print "requestChunk.next"
		return depositChunk( self.tr )	

# -- exception handling task
class failure(task):
	def __init__(self, monGid=None,monLoc=None,msg=None):
		task.__init__(self, monGid)
		import sys
		self.exc_type = sys.exc_type		 
		self.exc_value = sys.exc_value
		self.monLoc = monLoc
		self.msg = msg
		
	def destinations(self):
		return [self.monLoc]

	# call the monitor resident
	def call(self, monitor):
		monitor.failure( self )		


# base class for all status messages sent to
# to monitor
class status(task):
	def __init__(self, tr=None):
		if tr == None: return
		task.__init__(self, tr[MONGID])
		self.tr = tr
		
	def destinations(self):
		return [ self.tr[MONLOC] ]			

# call source completed
class completed2(task):
	def __init__(self, tr=None):
		if tr == None: return
		task.__init__(self,tr[SRCGID])
		self.tr = tr

	def destinations(self):
		return [ self.tr[SRCLOC] ]			

	def call(self, source):
		source.completed( self.tr )
	

# sent to monitor when task is completed		
class completed(status):
	def __init__(self, tr=None):
		status.__init__(self,tr)

	def destinations(self):
		return [ self.tr[MONLOC] ]			

	def call(self, mon):
		mon.completed( self.tr )

	def next(self):
		return completed2( self.tr )		


# sent to monitor when task is completed		
class progress(status):
	def __init__(self, tr=None):
		status.__init__(self,tr)

	def call(self, monitor):
		if DEBUG == true: print "progress.call"
		monitor.progress( self.tr )		
		



		
if __name__ == '__main__':
	import sys
	dlist = []
	tr = {}

	#try:	
	tr[SRCPATH] = sys.argv[1]
	tr[SRCLOC] = sys.argv[2]	

	i = 3
	while i < len(sys.argv):
		# get path and host tuples
		dlist.append( (sys.argv[i], sys.argv[i+1]) )
		i = i + 2

	#except:
	#	print "Usage: mftp.py <srcPath> <srcLoc> (<destPath>,<destLoc>)+"
	#	sys.exit(0)
				
	tr[DESTINFO] = dlist
					
	send( cacoon(monitor( tr ),"mftp","monitor" ) ) 			
