#!/usr/bin/python



from dtm import *


"""

	GDTM - Group dtm
	
	Allows groups of messages to interact
	with other groups. Each message is called 
	a task. There are different types of tasks.
	
	Resident tasks stay resident on the server
	and interact with other tasks in the group.
	
	Response tasks are tasks that are used by
	Duplex tasks that need a response. They
	carry state information about whether or 
	not a task was successful
	
	Duplex tasks need a response, and until they 
	recieve a response they block all other
 	incoming tasks in a group.
	
	Normal tasks perform some action then spawn
	child tasks, then die. They have very brief
	lives.

"""

# -- exceptions
InternalError = "gdtm.InternalError"





# ---- helper functions


# get the name of a class
def classname(x):
	import strop
	x = strop.split( str(x) )[0]
	return strop.splitfields(x,".")[1]

#*****
# Generic query, this code was lifted from Store.py
# in Paos. It tests a list of objects for membership
# in a subset. This code was written by
# Carlos Maltzahn at the University of Colorado.
def query(properties, scope_list):
  # select those objects from the scope by the given properties
  # and build a list of objects (obj_list) 
  obj_list = []
  if len(properties) == 0: 
    obj_list = scope_list
  else:
    for object in scope_list:
      for (label, op, value) in properties:
	if not hasattr(object, label):
	  break
	else:
	  if op == '==':
	    if getattr(object, label) != value:
	      break
	  elif op == '!=':
	    if getattr(object, label) == value:
	      break
	  elif op == 'in':
	    if getattr(object, label) not in value:
	      break
	  elif op == 'not in':
	    if getattr(object, label) in value:
	      break
	  elif op == 'has':
	    if value not in getattr(object, label):
	      break
	  elif op == 'has not':
	    if value in getattr(object, label):
	      break
	  elif op == 'all in':
	    foundall = 1
	    for item in getattr(object, label):
	      if item not in value:
		foundall = 0
		break
	    if not foundall:
	      break
	  elif op == 'not all in':
	    foundall = 1
	    for item in getattr(object, label):
	      if item not in value:
		foundall = 0
		break
	    if foundall:
	      break
	  elif op == 'some in':
	    found = 0
	    for item in getattr(object, label):
	      if item in value:
		found = 1
		break
	    if not found:
	      break
	  elif op == 'none in':
	    found = 0
	    for item in getattr(object, label):
	      if item in value:
		found = 1
		break
	    if found:
	      break
	  else:
	    raise ValueError, 'Unknown relation'
      else:
	obj_list.append(object)
  return obj_list

"""
	Basic atomic message type. Belongs to a group
	and can interact with a group.
"""
class task:
	def __init__(self, gid=None):
		if gid == None:
			#print "Using unique key"
			self.gid = unique_key()
		else:
			self.gid = gid

		self.id = unique_key()
		self.__name__ = "task"
		
	def send(self, rawData, dest):
		send( rawData, dest)
		
	def getId(self):
		return self.id	

	def setId(self, id):
		self.id = id	
		
	def groupId(self):
		return self.gid
		
	def call(self, res):
		pass
		
	def next(self):
		pass
		
	def destinations(self):
		return [""]

	def getId(self):
		return self.id
		
		
"""
	A duplex task perfomrs an action then
	blocks all other tasks in a group until
	a response message is recieved.
"""		
class duplex(task):
	def __init__(self, gid=None):
		task.__init__(self, gid)		
		self.__name__ = "duplex"		
		
	def getId(self):
		return self.id

		
	def success(self):
		pass
		
	def failure(self, why):
		pass	

	def sendSuccess(self):
		r = response( self.groupId() )
		task.send(self, r, [ self.senderAddress ] )

	def sendFailure(self, msg):
		r = response( self.groupId() )
		r.errmsg(msg)
		task.send(self, r, [ self.senderAddress ] )
		

"""
	A response is a type of message that is 
	returned to the sender to unblock other
	messages in a group.
"""			
class response(task):
	def __init__(self, gid=None):
		task.__init__(self, gid)		
		self.__name__ = "response"
		self.err = None
	
	def errmsg(self, x):
		self.err = x
	
	def failureMsg(self):
		return self.err	
		
	def killGroup(self):
		return true	

		 
"""
	A resident is the server node manager for a 
	group of messages only one resident per group
	and ip address is allowed.
"""		
class resident(task):
	def __init__(self, gid=None):
		task.__init__(self, gid)		
		self.q = []
		self.die = false
		# generate a unique key for this group
		if gid == None:
			self.gid = unique_key()		
		else:
			self.gid = gid
		self.__name__ = "resident"
			
	# sends a duplex message and tasgs it with the
	# sender id
	def sendDuplex(self):
		# call this task's call() method
		self.q[0].call(self)
		
		# get the next task
		t = self.q[0].next()
		
		# if there is one tag and and ship it ...
		if t != None:
			if type(t) == type([]):
				for _t in t:
					# tag it it with the sernder's id
					# and address
					_t.senderId = self.q[0].getId()	
					_t.senderAddress = self.localhost
	
					# send it off ...
					task.send(self, _t, _t.destinations() )
			else:
				# tag it it with the sernder's id
				# and address
				t.senderId = self.q[0].getId()			
				t.senderAddress = self.localhost

				# send it off ...
				task.send(self, t, t.destinations() )
		
		
	# dequeue the queue of tasks until empty or another
	# duplex task is encountered	
	def dequeue(self, why):	

		# respond to blocking message	
		x = self.q[0]
		# was the task a success or failure ?
		if why == None:
			x.success()
		else:
			x.failure(why)
			if x.killGroup() == "true":
				self.die = true
				return true
				
		# delete it from queue		
		del self.q[0]
		
		# dump queue	
		while (len(self.q) > 0):
			
			x = self.q[0]
			# is this a duplex task ?
			if x.__name__ == "duplex":
				self.sendDuplex()
				return true
	
			# call task handler, from the message point
			# of view it just arrived			
			self.taskHandler(x)
			del self.q[0]
			
		return false
		
	# handle blocking tasks	
	def block(self, other):
		# if queue is empty we are not blocking
		if len(self.q) == 0: return false
	
		# is this a response
		if other.__name__ == "response":
			why = other.failureMsg()
			return self.dequeue(why)			
		
		# append message to queue, it is not a response
		self.q.append( other )
		
		# continue blocking
		return true
		
	# handle a task and send its child	
	def taskHandler(self, other):	
		# call main entry point for task
		other.call( self )

		# if this is a duplex task add to queue
		if other.__name__ == "duplex":
			#print other, " is a duplex task"
			# paranoid check
			if len(self.q) != 0:
				print "Out of sequence, queue must be zero !"
				#import sys
				#sys.exit(0)
				return
				
			# add to queue					
			self.q.append(other)
			# send duplex task
			self.sendDuplex()
		else:			
			#print other, "is a regualre task"
			# get next task
			t = other.next()
			# see if it exists
			if t != None:
				if type(t) == type([]):
					for _t in t:
						# send it out
						task.send(self, _t, _t.destinations() )
				else:				
					# send it out
					task.send(self, t, t.destinations() )
		
	# This task meets with other tasks
	def meeting(self, other):
		#print "resident.meeting"
		# see if we're blocked
		if self.block(other) == true: return
		# we are not or no longer, blocked
		self.taskHandler(other)	

	# kill this resident		
	def kill(self):
		self.die = true
		
	# see if this resident died	
	def isDead(self):
		return self.die	


"""
	gdtm server.
	Manages resident tasks.
"""
class gdtmServer(dtmMgr):
	def __init__(self, verbose = false):
		dtmMgr.__init__(self, verbose)
		
		import shelve
		# make residents persistant in case we go down
#		self.r = shelve.open("vars/gdtmServer.odb")
		self.r = {}
		self.fileTable = {}
		self.mode = "Coop"
		
	def threadMode(self):
		self.mode = "thread"
		
	def forkMode(self):
		self.mode = "fork"
		
	def getMode(self):
		return self.mode	

	def hasGid(self, gid):
		return self.r.has_key(gid)

		
	# query the residents to see if any match		
	def queryResidents(self, proplist):
		list = []
		for k in self.r.keys():
			list.append( self.r[k] )
		return query(proplist, list)	
		
	# Called when there is no response from a node.
	def failedMessage(self, m):
		# --- note ----
		# In the future I want to try to do auto-routing
		# In case if a message failes I should have been able
		# to keep track of all the nodes that were succesful.
		# I could try to rewire the message to them instead
		# of just declaring this node dead.
		print "gdtmServer.failedMessage",m
		

	# execute next task
	def doNext(self, x):
		t = x.next()
		if t != None:
			if type(t) == type([]):
				for _t in t:
					d = _t.destinations()
					#print "d = ",d
					x.send( _t, d )
			else:
				x.send( t, t.destinations() )

	# execute a non resident task
	def execTask(self, t):
		if self.r.has_key( t.groupId() ):
			#self.r[ t.groupId() ].meeting( t )	
			x = self.r[ t.groupId() ]
			x.meeting( t )
			self.r[ t.groupId() ] = x
			# has the task killed the resident ?
			if x.isDead() == true:
				del self.r[ t.groupId() ]
	
	def specialUnpickle(self, x):
		# go past id byte
		x = x[1:]
		
		# split module and function
		import strop
		
		header = strop.splitfields( x, chr(2) )
		module = header[0]
		func = header[1]
		num = strop.atoi(header[2])
		
		chunk = header[3][:num]
		p = header[3][p:]
		
		cmd = "import %s; result = %s.%s(chunk, p)" % (module,module,func)
		exec(compile(cmd,"<string>","exec"))
		return result
		
		

	# called by dtmMgr whenever a message is recieved
	def messageHandler(self, m):
		import cPickle
		x = cPickle.loads(m.data)
		if x.__class__ == cacoon().__class__:
			x = x.unpickle()

		# process tasks which have a name attribute
		if hasattr(x,"__name__"):
			# tell the resident his ip address
			x.localhost = self.localhost

			if x.__name__ == "resident":
				if self.verbose == true:
					print "Resident for group id ",x.groupId()," loaded."
				
				self.r[ x.groupId() ] = x
				x.call(self)
				self.doNext(x)
			else:
				self.execTask(x)
				
	def failure(self, msg):
		print msg			
		
		
# ============== test harness =======================


class task2(duplex):
	def __init__(self, gid=None):
		duplex.__init__(self, gid)

	def getId(self):
		return duplex.getId(self)

	def call(self, x):
		self.cresult = x.copy()
		if self.cresult == false:
			x.kill()
		duplex.sendSuccess(self)
		
	def next(self):
		if self.cresult == true:
			return self
		else:
			return None

class task1(resident):
	def __init__(self, sfile=None, dfile=None):
		resident.__init__(self)
		self.sfile,self.dfile = sfile,dfile
		
	def __del__(self):
		try:
			self.sfile.close()
			self.dfile.close()		
		except:
			pass
		
	def copy(self):
		data = self.sfile.read(100)
		if data == None: return false
		if len(data) == 0: return false
		
		self.dfile.write(data)
		return true

	def call(self, x):
		self.sfile = open(self.sfile)
		self.dfile = open(self.dfile,"w")

	def next(self):
		t = task2(self.groupId())				
		t.senderId = self.getId()
		t.senderAddress = self.localhost
		return t			
			
def test():			
	send( task1(sys.argv[2], sys.argv[3]), [""] )
					

if __name__ == "__main__":
	import sys
	
	if sys.argv[1] == "start_server":
		gdtmServer(false).server()
	else:
		test()				




# required by dtm.cacoon
def unpickle(x):
	import cPickle
	return cPickle.loads(x)











