#!/usr/bin/python


"""
	This is a simple compression utility written
	in python. It is a workaround for one of the 
	caveats of cPickle wich uses 4 bytes to store
	a non ascii character which makes it too
	bulky for binary data transfer.
"""

def compress( rawData ):
	cData = ""
	list = []
	i = -1
	prev = ""
	
	for c in rawData:
		if i == -1:
			list.append( (c,0) )
			i = i + 1
		else:
			(prev, cnt) = list[i]
			if prev != c or cnt == 255:
				list.append( (c,0) )
				i = i + 1
			else:
				cnt = cnt + 1
				list[i] = (prev, cnt)
	
	for (c,cnt) in list:
		cData = cData + c + chr(cnt)	
		
	return cData	


def decompress( cData ):
	i, rawData = 0, ""
	import strop
	while i < len(cData):
		c = cData[i]
		cnt = ord(cData[i+1]) + 1
	
		x = c * cnt
		rawData = rawData + x	
		i = i + 2

	return rawData
	
	
def test():
	from rand import rand
	
	_in = ""
	for i in range(0,1000):
		_in = _in + chr(rand() % 256)
	
	before = _in
	
	print "begining test ..."
	
	after = decompress( compress( before ) )
	
	if after != before:
		print "Failure"	
			
def test2():
	before = chr(1) * 100
	x = compress( before ) 
		
	print len(x), x	
	
	after = decompress( x )
	if after != before:
		print "Failure"	
					
			
				
if __name__ == "__main__":
	for i in range(0,10):
		test()		
#	test2()
		
