#!/usr/bin/python


"""
	Agents represent a family of tasks used
	by plugins to communicate with one another.
	In this way two plugins are never allowed to 
	communicate with one another.
"""		

from gdtm import *
false,true = 0,1

class agent(task):
	def __init__(self, plugin=None):
		from pluginServer import PLUGIN_SERVER_GID
		task.__init__(self, PLUGIN_SERVER_GID)
		if plugin == None: 
			self.empty = true
		else:
			self.empty = false			

		# extract plugin information
		self.pluginId  = plugin.__pluginId__ 
		self.docName = plugin.__docName__
		self.__target__ = None
		
	# return the result of some action	
	def queryData(self):	
		return self.__target__


class getParent(agent):
	def __init__(self, plugin=None):
		agent.__init__(self, plugin)
		
	def call(self, ps):
		parent = ps.getParent(self.docName, self.pluginId)
		if parent != None:
			self.__target__ = [parent.__pluginId__]
			return self
		return None









