"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.
"""

import string, shelve
ROOT_NAME = "__root__"

false, true = 0,1


class ordered_dict:
	def __init__(self):
		self.list = []
			
	def has_key(self, key):
		p = self.__getitem__(key)
		if p == None: return false
		return true			

	def regexpr(self, key):
		import regex
		x = regex.compile(key)
		result = []
		for (k,v) in self.list:
			if x.search(k) != -1:
				result.append(v)
		return result
		
	def append(self, data):
		self.list.append( ("__noname__", data) )

	def __getitem__(self, key):
		if type(key) == type(0):
			if key < len(self.list):
				return self.list[key][1]
		else:
			for (k,v) in self.list:
				if k == key:
					return v
			return None
			
	def keys(self):
		result = []
		for (k,v) in self.list:		
			result.append(k)
		return result

	def values(self):
		result = []
		for (k,v) in self.list:		
			result.append(v)
		return result

	def __setitem__(self, key, data):
		if type(key) == type(0):
			(k, d) = self.list[ key ]
			self.list[key] = (k, data)
		else:	
			self.list.append( (key,data) )

	def __delitem__(self, key):
		if type(key) == type(0):
			if key >= len(self.list):
				del self.list[key]
		else:
			i = 0
			for (k,v) in self.list:
				if k == key:
					del self.list[i]
					return	
				i = i + 1
	def length(self):
		return len(self.list)					



class tree_node:
	# ---------- public methods ----------------
	
	# constructor
	def __init__(self, data = None, name = ROOT_NAME):
		self.data = data
		self.name = name
		self.children = ordered_dict()
		
	def foreach(self, func):
		if self.data != None:
			if func(self) == true:
				return true
		for child in self.children.values():
			if child.foreach(func) == true:
				return true
		return false	

	def subtree(self, list):
		if len(list) == 0:
			try:
				return self
			except:
				return None
		for child in self.children.values():
			if child.name == list[0]:
				return child.subtree(list[1:])
		return None	
				

	def find(self, list, key):
		if len(list) == 0:
			try:
				return self.children[key]
			except:
				return None
		for child in self.children.values():
			if child.name == list[0]:
				return child.find(list[1:], key)
		return None	
	def apply_functor(self, list, name, functor):
		if len(list) == 0:
			try:
				self.children[name] = functor.execute( self.children[name] )
				return 1
			except:
				return 0
		for child in self.children.values():
			if child.apply_functor(list[1:], name, functor) == 1:
				return 1
		return 0	

	def add(self, list, n):
		if len(list) == 0:
			self.children[n.name] = n
			return 1 
		else:
			for child in self.children.values():
				if child.name == list[0]:
					if child.add(list[1:], n) == 1:
						return 1
						
			# add a new subdirectory
			x = tree_node(None, list[0])
			self.children[x.name] = x
			return x.add(list[1:], n)				
		return 0
		
		
	def remove(self, list, n):
		if len(list) == 0:
			del self.children[n]
			return 1
		for child in self.children.values():
			if child.name == list[0]:
				if child.remove(list[1:], n) == 1:
					return 1
		return 0 
				
'''
	Classical data structure 
		
'''		
class tree:
	def __init__(self):
		self.root = tree_node()	
	def subtree(self, path):
		return self.root.subtree(path)	
	def add(self, catagory, name, data):
		path = [ROOT_NAME] + catagory
		newnode = tree_node(data, name)
		return self.root.add(path, newnode)
	def remove(self, catagory, name):
		path = [ROOT_NAME] + catagory
		return self.root.remove(path, name)
	def foreach(self, func):
		self.root.foreach(func)
	def find(self, catagory, name):
		path = [ROOT_NAME] + catagory
		return self.root.find(path, name)
	def apply_functor(self, catagory, name, functor):
		path = [ROOT_NAME] + catagory
		return self.root.apply_functor(path, name, functor)
	def dump(self):
		def func(object):
			print "name = %s, data = %s" % (object.name, object.data)
			return false
		self.foreach( func )	
			

class tree_iterator:
	def create(self, theTree):
		class temp:
			def __init__(self):
				self.list = []
			def push(self, node):
				self.list.append( node )
		t = temp()
		theTree.foreach( t.push )
		self.list = t.list
		self.i = 0
	def __getitem__(self, i):
		return self.list[i]	
	def deref(self):
		return self.list[ self.i ]
	def incr(self):
		try:
			x = self.list[ self.i + 1 ]
		except:
			return None
		self.i = self.i + 1
		return x
	def decr(self):
		if self.i == 0:
			return None
		self.i = self.i - 1
 		return self.deref()
	def __len__(self):
		return len(self.list)
	def erase(self, _from, to=-1):
		if to == -1:
			del self.list[_from]
		else:		
			del self.list[_from:to]





def test():
	class thefunctor:
		def execute(self, object):
			object.dummy = 1
			return object

	t = tree()   
	
	print ""
	print ""
	t.add(["subscribers"],"david","schere")
	t.add(["subscribers","wife"], "divina", "schere")	
	t.add(["subscribers","mistress"],"nobody","")
	t.remove(["subscribers","mistress"], "nobody")
	t.add(["subscribers","mistress"],"nobody","")

	t.apply_functor(["subscribers","mistress"], "nobody", thefunctor()  )
		
			
	object = t.find(["subscribers","mistress"], "nobody")
	print "object = ", vars(object)	


	iter = tree_iterator()
	iter.create( t )
	
	while 1:
		x = iter.incr()
		if x == None: break
		print vars(x)
if __name__ == '__main__':
	test()
