#!/usr/bin/python

"""
	Simple program that opens a shelve and displays its
	contents as html. Allows the user to get detailed information
	by using JavaScript.
"""

DrawMode = "text"

# primitives for draw elements 


def draw_level(level):
	if DrawMode == "text":
		print "\t" * level,


def draw_none(e, level):
	draw_level(level)
	if DrawMode == "text":
		print "None"

def draw_string(e, level):
	draw_level(level)
	if DrawMode == "text":
		print "String value=",e

def draw_integer(e, level):
	draw_level(level)
	if DrawMode == "text":
		print "Integer value=",e

def draw_float(e, level):
	draw_level(level)
	if DrawMode == "text":
		print "Float value=",e

def draw_list(e, level):
	draw_level(level)
	if DrawMode == "text":
		print "List"

def draw_dict(e, level):
	draw_level(level)
	if DrawMode == "text":
		print "Dictionary"

def draw_class(e, level):
	draw_level(level)
	if DrawMode == "text":
		print "class"




def draw_elm( e, level = 0):
	# check for atomic types
	if   type(e) == type(None):
		draw_none(e,level)
	elif type(e) == type(""):
		draw_string(e,level)
	elif type(e) == type(0):
		draw_integer(e,level)
	elif type(e) == type(0.0):
		draw_float(e,level)
	# check for data structures
	elif type(e) == type([]):
		draw_list(e,level)
		for e1 in e:
			draw_elm(e1,level+1)
	elif type(e) == type({}):
		draw_dict(e,level)
		for (k, e1) in e.items():
			draw_string(k, level+1)
			draw_elm(e1,level+1)
	else:
		# check for class 
		if hasattr(e,"__dict__"):
			draw_class(e,level)
			draw_elm(vars(e),level+1)
		  
def view(s):
	for k in s.keys():
		try:
			draw_elm( s[k] )		
		except:
			print "Can't construct class object for key ",k

##############################################################



def ErrMsg(msg, title="error"):
	print "<html><title>",title,"</title>"
	print "<body text=BLACK bgcolor=WHITE>",msg
	print "</body></html>"


def viewShelve( path ):
	import shelve
	s = shelve.open( path, "r")
	view(s)


def main():
	import sys, string
	from cgi import *

	# ----------------------------------------------------- #
	# Absolute requirement -- this must be the first thing 
	# sent to the server or else a fatal error.
	# ----------------------------------------------------- #
	print "Content-type: text/html"
	print ""

	# automatically parses html document
	htmlDict = FormContent()

	# open gnu dbm file
	path = htmlDict["path"][0]
	try:
		viewShelve(path)
	except:
		ErrMsg("Unable to open %s" % (path))
			
if __name__ == '__main__':
	#main()
	import sys
	DrawMode = "text"
	viewShelve(sys.argv[1])