"""
	Generic TCP/IP server and client. Based on the Paos c/s database 
"""



import socket
import select
try:
	import cPickle
	pickle = cPickle
except:
	import pickle

try:
	import strop
	string = strop
except:
	import string

from types import *
import traceback
import Utilities

#*****
# server object based on the Paos client/server database
# allows for the derived objects to craete thier own services
class server:
  def __init__(self, port, timeout = 5):
    self.port, self.timeout = port, timeout
    self.command = {}
  # add a user defined command
  def addCommand(self, command, func):
    self.command[ command ] = func
  # remove a user defined command
  def delCommand(self, command):
    try:
      del self.command[ command ]
    except:
      pass
  def mainloop(self):
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    s.bind('',self.port)

    s.listen(self.timeout)

    conn_table = {} # conn -> client
    client_table = {} # client -> conn
    conn_list = [s]
    print 'Server: ready and listening'

    while 1:
      (ready_list, x, y) = select.select(conn_list, [], [])
      for ready_conn in ready_list:
        if ready_conn is s:
          (conn, address) = s.accept()
          conn_table[conn] = ''
          conn_list.append(conn)
          print 'Server: connection accepted from', address
        else:
          try:
            data = Utilities.RECV(ready_conn, 20000)
            order = pickle.loads(data)
     	    conn_table[ready_conn] = order[0]
	    client_table[order[0]] = ready_conn

	    if not self.command.has_key( order[1] ):
	      print "Server: Unable to process command ", order[1]
	    else:
	      func = self.command[ order[1] ]
	      result = func( order )
	      Utilities.SEND(ready_conn, pickle.dumps(answer))
	      
          except: 
    	    # handle all errors in one handler
	    if sys.exc_type in [TypeError, ValueError, RuntimeError]:
	      data = pickle.dumps(('error', sys.exc_type, sys.exc_value))
	      Utilities.SEND(ready_conn, data)
	      print "Server:", traceback.print_exc()

	    elif sys.exc_type in [EOFError, socket.error]:
	      if sys.exc_type is socket.error and \
	         sys.exc_value[0] not in [32, 54]:
	         raise socket.error, sys.exc_value
	  
	      print 'Server: closing connection, deleting locks and requests of',\
		    conn_table[ready_conn]
	      ready_conn.close()
	      Store.release_all_locks(conn_table[ready_conn])
	      Store.delete_all_requests(conn_table[ready_conn])
	      if client_table.has_key(conn_table[ready_conn]):
	        del client_table[conn_table[ready_conn]]
	      del conn_table[ready_conn]
	      conn_list.remove(ready_conn)

	    else:
	      Store.db.close()
	      raise sys.exc_type, sys.exc_value


