"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.


	Sends a query to a web server, this has two modes GET and POST
"""
import regex, strop, regsub
false, true = 0,1

HostTimeOut = "query.HostTimeOut"

#*****
# extract_host_and_port
#	get the port number and the host name from the cgi path
def extract_host_and_port(cgi):
	cgi = strop.strip(cgi)
	x = regex.compile("http://\([^:/]+\)[:]\([0-9]+\)")
	if x.match(cgi) == -1:
		x = regex.compile("http://\([^/]+\)")
		if x.match(cgi) == -1:
			msg = "Unable to extract host name from url %s" % (cgi)
			raise WIDLError_MalformedDocument, msg
		return (x.group(1), 80)
	return (x.group(1), strop.atoi(x.group(2)))	

def getUrlDoc(url):
	from XMLProcessor import XMLProcessor
	from InputDoc import InputDoc

	c = InputDoc()
	x = XMLProcessor(c)
	x.verbose = true
	#print "fetching ",url
	x.run(url)

	return c.getGrove() 			

#****
# match the form that has the input variables that match 
# the varlist
def getFormObj(doc, dict):
	if not hasattr(doc,"FORM"):
		return None
	
	#print doc.FORM.list
	wlist = map(strop.upper, dict.keys())

	# convert a list of widl object to a list of names
	def getname(i):
		if not i.obj.has_key("name"):
			return ""		
		#print i.obj["name"]
		return strop.upper(i.obj["name"])
		
	# see if all the words match within the input list
	def match(wlist, ilist):
		#print "wlist = ",wlist
		#print "ilist = ",ilist
		for word in wlist:
			if not word in ilist:
				return false
		return true		

	# search for a form that matches the inputs
	for i in range(0,doc.FORM.length()):	
		d = doc.FORM[i]
		ilist = map(getname, d.findall("INPUT"))
		if match(wlist,ilist) == true:
			return d			
		
	return None

# query remote host put the result into a document object
def send_query(url, retries, waitpieriod, dict):
	from socket import *
	import time
	buffer, cgi = "", ""

	# goto remote server and fetch the document, them place it into
	# a document object
	remoteDoc = getUrlDoc(url)

	form = getFormObj(remoteDoc, dict)
	#print form
	if form == None:
		return remoteDoc
		
	# get the action attribute that has the cgi program at the other
	# end. Form the query string based on action attribute method and
	# the input dictionary
	cgi = form.obj["action"]
	try:
		method = form.obj["method"]
	except:
		method = "GET"

	# If the host is hard coded in the cgi then use it else
	# use the input url as the host.
	try:
		#** this is only successful if the host has been hard coded
		# extract the host and port from the url
		host, port = extract_host_and_port(cgi)
	except:
		# else use the input url
		# extract the host and port from the url
		host, port = extract_host_and_port(url)

	#print "cgi = ", cgi
			 
	# use the encoder module to create the query message
	import encoder
	msg = encoder.formatQuery(method,cgi,dict)

	#print "msg = ",msg

	#------ begin socket connection stuff ---------
	# standard socket
	s = socket(AF_INET, SOCK_STREAM)
	
	# try to establish a connection
	while 1:		
		try:
			s.connect(host, port)
			break
		except:
			if retries == 0:
				err = "Unable to contact host %s" % (host)
				raise HostTimeOut, err
		
			time.sleep(waitperiod)
			retries = retries - 1
	# send the msg
#	print "***** sending message ****"
#	print msg
#	print "**************************"
	s.send(msg)
	
	# process the response into a document object
	from WIDLDocObject import DocClient
	from XMLFactory import XMLFactory
	
	c = DocClient()
	factory = XMLFactory(c)

	firstpass = true
	while 1:
		data = s.recv(4096)
		if firstpass == true:
			firstpass = false
			# go past the header
			data = data[strop.find(data,"\r\n\r\n"):]
			
		data = regsub.gsub('\r','',data)	
		if data == None: break
                if data == "": break

		# feed raw data to factory to create widl document tree
		factory.feed(data)
		
	# close the socket	
	s.close()
	
	# get a widl document object
	return c.getGrove()

#*****
# decrypt
#	replace variable names with values
def decrypt(x, varlist):
	import regsub
	
	for v in varlist:
		s = "%" + v.getname() + "%"
		x = regsub.gsub(s,v.getvalue(),x)
	return x
		

#****
# query
# 	main routine for module organizes variable and service data to preform
# 	a request then sends 	
def query(widl, service, varlist):
	# make cgi path
	cgi = widl.getbaseurl() + service.geturl()
	cgi = decrypt(cgi,varlist)
	method = service.getmethod()
	
	dict = {}
	for v in varlist:
		dict[ v.getformname() ] = v.getvalue()
	
	#import encoder
	#msg = encoder.formatQuery(method,cgi,dict)
	
	return send_query(cgi, service.getretries(), service.gettimeout(), dict)
