#!/usr/bin/python


from XMLClient import *
from plugin import *
import strop

InvalidTag = "qtXMLClient.InvalidTag"
UnhandledTag = "qtXMLClient.UnhandledTag"

TopNode = None

"""
	Creates a tree structure of Qt widgets that represent
	a form created by the xml file. 
"""
class pluginTree:
	def __init__(self):
		self.t = []
		self.curr = 0
		
	def getRoot(self):
		try:
			return self.t[0][0]
		except:
			return None		
		
	def newEntry(self, w):
		if self.curr == len(self.t):
			# if it doesn't exist
			self.t.append( [w] )
		else:
			self.t[ self.curr ].append( w )	
			
	def onNonEmptyTag(self, w):
		self.newEntry( w )
		self.curr = self.curr + 1

	def onEndTag(self):
		self.curr = self.curr - 1
		
	def onEmptyTag(self, w):
		self.newEntry( w )
		
	def getParent(self):
		if self.curr > 0:
			list = self.t[ self.curr-1 ]		
			return list[ len(list) - 1 ]
		else:
			return None	
	
	def push(self, w):
		self.onNonEmptyTag(w)			
			


"""
	xml client that parses an xml file with qt tags.
"""
class qtXMLClient(ClientBase):

	def nameOf(self):
		return "qpx"

	def __init__(self, child=false):
		ClientBase.__init__(self)
		self.table = {}
		self.pt = pluginTree()
		self.nametable = {}
		self.child = child

		import glob, strop
		for filename in glob.glob("plugins/*.py"):
			l = strop.splitfields(filename,"/")
			n = l[ len(l) - 1]	
			modname = n[0: len(n) - 3 ]
			
			cmd = """
import %(m)s		
for i in %(m)s.init():
	self.register(i)
"""			
			cmd = cmd % { 'm': modname }
			cobj = compile(cmd, "<string>", "exec") 
			exec( cobj )

	# Register a new tag 		
	def register(self, np):
		n = strop.upper(np.nameOf())
		self.table[ n ] = np
		
	# get the parent widget
	def getParent(self):
		return self.pt.getParent()

	# try to match widget
	def match(self, obj):
		n = strop.upper(obj.nameOf())
		if self.table.has_key(n):
			x = self.table[n].clone()
			p = self.getParent()

			# if p is none then we 			
			if p == None:
				x.setTopLevel( self.pt.getRoot() )
			else:	
				w = p.getWidget()
				x.setParent( w )
				
			if x.isValid( obj ) == false:
				msg = "Invalid attributes for tag %s" % (obj.nameOf())	 	 				
				raise InvalidTag, msg

			# call plugin 
			x.call( obj, self )

			if x.useText() == true:
				self.textH = x
			return x
		return None
		
	# refers to getting the text of the widget	
	def __getitem__(self, key):
		if self.nametable.has_key( key ):
			x = self.nametable[key]
			return x
		return None
			
	def has_key(self, key):
		return self.nametable.has_key( key )	

	def __setitem__(self, key, text):
		if self.nametable.has_key( key ):
			self.nametable[key].text(text)

	# text handler
	def text(self, obj):
		if hasattr(self, "textH"):
			self.textH.texthandler( obj )
			delattr(self,"textH")
		
	def setNameTable(self, obj, x):
		if obj.has_key("name"):
			self.nametable[ obj["name"] ] = x				
			
	# tag handlers 	
	def nonEmptyTag(self, obj):
		ClientBase.nonEmptyTag(self, obj)
		if strop.upper(obj.nameOf()) == "QPX": return
		
		x = self.match(obj)
		if x != None:
			#self.widgetStack.append( x )
			self.pt.onNonEmptyTag( x )
			self.setNameTable(obj,x)
			return
			
		msg = "Unknown tag %s" % (obj.nameOf())
		raise UnhandledTag, msg
				
	def emptyTag(self, obj):
		ClientBase.emptyTag(self, obj)
		x = self.match(obj)
		if x == None:
			msg = "Unknown tag %s" % (obj.nameOf())
			raise UnhandledTag, msg
		self.pt.onEmptyTag( x )
		self.setNameTable(obj,x)
				
	def endTag(self, obj):
		ClientBase.endTag(self, obj)
		if strop.upper(obj.nameOf()) == "QPX": return
		self.pt.onEndTag()


	def endfile(self):
		global QtApp

		if hasattr(self,"mainwidget"):
			self.mainwidget.show()

		if self.child == false:
			QtApp.setMainWidget( self.mainwidget )
			QtApp.execLoop()
	

def ParseQtXMLFile(xmlfile, isChild = false ):
	from XMLProcessor import *

	c = qtXMLClient( isChild )
	x = XMLProcessor( c )
	x.run( xmlfile )
		
				

if __name__ == '__main__':
	import sys
	ParseQtXMLFile( sys.argv[1] )
