#!/usr/bin/python

from connection import *
from popup import *

def init():
	return [popup_item()]

class popup_item(connection):
	def __init__(self, parent=None):
		connection.__init__(self, parent)

	def clone(self):
		return popup_item(self.parent)

	def nameOf(self):
		return "popup_item"

	def isValid(self, obj):
		self.reqlist = ["module","method"]
		self.signal = "clicked"
		return connection.isValid(self, obj)

		
	def call(self, obj, control):
		self.owner = control
		if hasattr(self,"xmlfile"):
			self.handler = self.child
		else:
			self.handler = self.callback
		

		mode = 0		
		caption = ""
		if obj.has_key("caption") == true:
			caption = obj["caption"]
			mode = mode | POPUP_TEXT

		pixmap = QPixmap()
		if obj.has_key("img") == true:
			pixmap = QPixmap( obj["img"] )
			mode = mode | POPUP_PIXMAP

		self.parent.insert( mode, \
			caption, pixmap, PopupMenu(), self.handler)
		
	

  
	
