#!/usr/bin/python

from plugin import *


def init():
	return [notebook()]

"""
	Tabbed Dialog Object (Notebook under widoze).
	Use this object for the main window in utilities. 
"""
class notebook(qtplugin):
	def __init__(self, parent=None):
		qtplugin.__init__(self, parent)

	def clone(self):
		return notebook(self.parent)

	# pythonqt workaround
	def quit(self):
		import os, posix
		os.system("rm -SIGTERM %d" % (posix.getpid()) )

	def isValid(self, obj):
		return qtplugin.hasManditoryAttributes(self, \
		("left","top","width","hieght"), obj)

	def nameOf(self):
		return "notebook"

	def call(self, obj, control):
		qtplugin.call(self, obj, control)

		caption, modal = "", 0
		if obj.has_key("caption"):
			caption = obj["caption"]
		if obj.has_key("modal"):
			modal = 1
					
		if self.parent == None:
			self.w = TabDialog()
			qtplugin.setMainWidget(self)
			self.w.setCaption(caption)
		else:
			self.w = TabDialog(self.parent, \
				caption, modal)
				
		self.w.setGeometry(self.prop["left"], \
			self.prop["top"], self.prop["width"], \
			self.prop["hieght"] )

		qtplugin.frameStyle(self, self.w, obj)		

		# set button styles		
		list = []
		list.append( ("ok",self.w.setOKButton) )
		list.append( ("cancel",self.w.setCancelButton) ) 
		list.append( ("apply", self.w.setApplyButton) )
		list.append( ("default", self.w.setDefaultButton) )
		
		for (n,f) in list:
			if obj.has_key(n):
				v = obj[n]
				if v == None: v = n
				f(v)
#		self.w.show()
			
			
		
							
		
		
		
		
