#!/usr/bin/python

"""
	ListBox manipulated by xml

	<listbox multiselect >
		<listbox_item caption="" image=""/>
		<connection ... /> 
	</listbox> 

"""
from plugin import *

def init():
	return [listbox(), listbox_item()]

class listbox(qtplugin):
	def __init__(self, parent=None):
		qtplugin.__init__(self, parent)

	def clone(self):
		return listbox()

	def nameOf(self):
		return "listbox"

	def insertItem(self, x):
		self.w.insertItem( x )

	def call(self, obj, control):
		if self.parent == None:
			self.w = ListBox();
		else:
			self.w = ListBox( self.parent, "" )

		if obj.has_key( ("left","top","width","height") ):
			self.w.setGeometry( \
				obj["left"], obj["top"], \
				obj["width"], obj["height"] )

		if obj.has_key("multiselect") == true:	
			self.w.setMultiSelection( true )

			
class listbox_item(qtplugin):
	def __init__(self, parent=None):
		qtplugin.__init__(self, parent)

	def clone(self):
		return listbox_item()

	def nameOf(self):
		return "listbox_item"

	def call(self, obj, control):
		text,pixmap = "",None

		#print self.parent
		if obj.has_key("caption") == true:
			self.parent.insertText( obj["caption"] )
		if obj.has_key("img") == true:
			self.parent.insertPixmap( QPixmap( obj["image"] ) )
		
		
		
