#!/usr/bin/python


from plugin import *

def init():
	return [select(),combobox() ]

"""
	<combobox>
		<connection signal=activatedIndex />
		<select>Line 1</select>
		<select>Line 2</select>
		<select>Line 3</select>
		<select>Line 4</select>
	</combobox> 
"""

SelectWithoutComboBox = "SelectWithoutComboBox.combobox"

class select(qtplugin):
	def __init__(self, parent=None):
		qtplugin.__init__(self, parent)

	def clone(self):
		return select(self.parent)
	
	def nameOf(self):
		return "select"
		
	def useText(self):
		return true		
	
	def isValid(self, obj):
		if self.parent == None:
			raise SelectWithoutComboBox
		
	# gets the text between <select> 
	# and </select>	
	def texthandler(self, obj):
		# parent is combobox object
		self.parent.insertList( [ obj.value() ] )
		
		
"""
	Represents a combobox
"""		
class combobox(qtplugin):
	def __init__(self, parent=None):
		qtplugin.__init__(self, parent)
	
	def nameOf(self):
		return "combobox"

	def text( self, ntext = None ):
		if ntext == None:
			return self.w.currentText()
			
		
	def isValid(self, obj):
		return qtplugin.hasManditoryAttributes(self, \
		("left","top","width","hieght"), obj)

	def call(self, obj, owner):
		self.w = ComboBox(0, self.parent)
		self.w.setGeometry(self.prop["left"], \
			self.prop["top"], self.prop["width"], \
			self.prop["hieght"] )
#		self.w.show()		
	
					
			


		
		




